/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.reporting.SourceFiles;
import mockit.coverage.reporting.StaticFiles;
import mockit.coverage.reporting.packages.IndexPage;
import mockit.coverage.reporting.sourceFiles.FileCoverageReport;
import mockit.coverage.reporting.sourceFiles.InputFile;

class CoverageReport {
    private final String outputDir;
    private final List<File> sourceDirs;
    private final Map<String, FileCoverageData> fileToFileData;
    private final Map<String, List<String>> packageToFiles;
    private final boolean withCallPoints;
    private final Collection<String> sourceFilesNotFound;

    protected CoverageReport(String outputDir, String[] srcDirs, CoverageData coverageData, boolean withCallPoints) {
        this.outputDir = outputDir.length() > 0 ? outputDir : "coverage-report";
        this.sourceDirs = srcDirs == null ? null : new SourceFiles().buildListOfSourceDirectories(srcDirs);
        this.fileToFileData = coverageData.getFileToFileDataMap();
        this.packageToFiles = new HashMap<String, List<String>>();
        this.withCallPoints = withCallPoints;
        this.sourceFilesNotFound = srcDirs == null ? null : new ArrayList();
    }

    public final void generate() throws IOException {
        boolean withSourceFilePages;
        this.createReportOutputDirIfNotExists();
        File outputFile = this.createOutputFileForIndexPage();
        if (outputFile == null) {
            return;
        }
        boolean bl = withSourceFilePages = this.sourceDirs != null;
        if (withSourceFilePages && this.sourceDirs.size() > 1) {
            System.out.println("JMockit: Coverage source dirs: " + this.sourceDirs);
        }
        this.generateFileCoverageReportsWhileBuildingPackageLists();
        new IndexPage(outputFile, this.sourceDirs, this.sourceFilesNotFound, this.packageToFiles, this.fileToFileData).generate();
        new StaticFiles(this.outputDir).copyToOutputDir(withSourceFilePages);
        System.out.println("JMockit: Coverage report written to " + outputFile.getParentFile().getCanonicalPath());
    }

    private void createReportOutputDirIfNotExists() {
        File outDir = new File(this.outputDir);
        if (!outDir.exists()) {
            boolean dirCreated = outDir.mkdir();
            assert (dirCreated) : "Failed to create output dir: " + this.outputDir;
        }
    }

    private File createOutputFileForIndexPage() throws IOException {
        File outputFile = new File(this.outputDir, "index.html");
        if (outputFile.exists() && !outputFile.canWrite()) {
            System.out.println("JMockit: " + outputFile.getCanonicalPath() + " is read-only; report generation canceled");
            return null;
        }
        return outputFile;
    }

    private void generateFileCoverageReportsWhileBuildingPackageLists() throws IOException {
        Set<Map.Entry<String, FileCoverageData>> files = this.fileToFileData.entrySet();
        for (Map.Entry<String, FileCoverageData> fileAndFileData : files) {
            this.generateFileCoverageReport(fileAndFileData.getKey(), fileAndFileData.getValue());
        }
    }

    private void generateFileCoverageReport(String sourceFile, FileCoverageData fileData) throws IOException {
        if (this.sourceDirs == null) {
            this.addFileToPackageFileList(sourceFile);
        } else {
            InputFile inputFile = new InputFile(this.sourceDirs, sourceFile);
            if (inputFile.wasFileFound()) {
                new FileCoverageReport(this.outputDir, inputFile, fileData, this.withCallPoints).generate();
            } else {
                this.sourceFilesNotFound.add(sourceFile);
            }
            this.addFileToPackageFileList(sourceFile);
        }
    }

    private void addFileToPackageFileList(String file) {
        int p = file.lastIndexOf(47);
        String filePackage = p < 0 ? "" : file.substring(0, p);
        List<String> filesInPackage = this.packageToFiles.get(filePackage);
        if (filesInPackage == null) {
            filesInPackage = new ArrayList<String>();
            this.packageToFiles.put(filePackage, filesInPackage);
        }
        filesInPackage.add(file.substring(p + 1));
    }
}

