/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mockit.coverage.paths.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path
implements Serializable {
    private static final long serialVersionUID = 8895491272907955543L;
    final List<Node> nodes = new ArrayList<Node>(4);
    private final AtomicInteger executionCount = new AtomicInteger();
    private final boolean shadowed;
    private Path shadowPath;

    Path(Node.Entry entryNode) {
        this.shadowed = false;
        this.addNode(entryNode);
    }

    Path(Path sharedSubPath, boolean shadowed) {
        this.shadowed = shadowed;
        sharedSubPath.shadowPath = shadowed ? this : null;
        this.nodes.addAll(sharedSubPath.nodes);
    }

    void addNode(Node node) {
        this.nodes.add(node);
    }

    boolean countExecutionIfAllNodesWereReached(List<Node> nodesReached) {
        boolean allNodesReached = this.nodes.equals(nodesReached);
        if (allNodesReached) {
            this.executionCount.getAndIncrement();
        }
        return allNodesReached;
    }

    public boolean isShadowed() {
        return this.shadowed;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public int getExecutionCount() {
        int count = this.executionCount.get();
        if (this.shadowPath != null) {
            count += this.shadowPath.executionCount.get();
        }
        return count;
    }

    void addCountFromPreviousTestRun(Path previousPath) {
        int previousExecutionCount = previousPath.executionCount.get();
        this.executionCount.set(previousExecutionCount);
    }

    void reset() {
        this.executionCount.set(0);
    }
}

