/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.coverage.Metrics;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.paths.NodeBuilder;
import mockit.external.asm4.AnnotationVisitor;
import mockit.external.asm4.ClassReader;
import mockit.external.asm4.ClassVisitor;
import mockit.external.asm4.ClassWriter;
import mockit.external.asm4.FieldVisitor;
import mockit.external.asm4.Label;
import mockit.external.asm4.MethodVisitor;
import mockit.external.asm4.MethodWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CoverageModifier
extends ClassVisitor {
    private static final Map<String, CoverageModifier> INNER_CLASS_MODIFIERS = new HashMap<String, CoverageModifier>();
    private static final int FIELD_MODIFIERS_TO_IGNORE = 4112;
    private static final int MAX_CONDITIONS = Integer.getInteger("jmockit-coverage-maxConditions", 10);
    private String internalClassName;
    private String simpleClassName;
    private String sourceFileName;
    private FileCoverageData fileData;
    private boolean cannotModify;
    private final boolean forInnerClass;
    private boolean forEnumClass;
    private String kindOfTopLevelType;

    static byte[] recoverModifiedByteCodeIfAvailable(String innerClassName) {
        CoverageModifier modifier = INNER_CLASS_MODIFIERS.remove(innerClassName);
        return modifier == null ? null : modifier.toByteArray();
    }

    static ClassReader createClassReader(Class<?> aClass) {
        return CoverageModifier.createClassReader(aClass.getClassLoader(), aClass.getName().replace('.', '/'));
    }

    private static ClassReader createClassReader(ClassLoader cl, String internalClassName) {
        InputStream classFile = cl.getResourceAsStream(internalClassName + ".class");
        if (classFile == null) {
            return null;
        }
        try {
            return new ClassReader(classFile);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    CoverageModifier(ClassReader cr) {
        super(new ClassWriter(cr, 1));
        this.forInnerClass = false;
    }

    private CoverageModifier(ClassReader cr, CoverageModifier other, String simpleClassName) {
        super(new ClassWriter(cr, 1));
        this.sourceFileName = other.sourceFileName;
        this.fileData = other.fileData;
        this.internalClassName = other.internalClassName;
        this.simpleClassName = simpleClassName;
        this.forInnerClass = true;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean nestedType;
        if ((access & 0x1000) != 0) {
            throw new VisitInterruptedException();
        }
        boolean bl = nestedType = name.indexOf(36) > 0;
        if (!nestedType && this.kindOfTopLevelType == null) {
            this.kindOfTopLevelType = this.getKindOfJavaType(access, superName);
        }
        boolean bl2 = this.forEnumClass = (access & 0x4000) != 0;
        if (!this.forInnerClass) {
            this.internalClassName = name;
            int p = name.lastIndexOf(47);
            if (p < 0) {
                this.simpleClassName = name;
                this.sourceFileName = "";
            } else {
                this.simpleClassName = name.substring(p + 1);
                this.sourceFileName = name.substring(0, p + 1);
            }
            boolean bl3 = this.cannotModify = (access & 0x2000) != 0;
            if (!this.forEnumClass && (access & 0x20) != 0 && nestedType) {
                INNER_CLASS_MODIFIERS.put(name.replace('/', '.'), this);
            }
        }
        int finalVersion = (version & 0xFFFF) == 51 ? 50 : version;
        super.visit(finalVersion, access, name, signature, superName, interfaces);
    }

    private String getKindOfJavaType(int typeModifiers, String superName) {
        if ((typeModifiers & 0x2000) != 0) {
            return "annotation";
        }
        if ((typeModifiers & 0x200) != 0) {
            return "interface";
        }
        if ((typeModifiers & 0x4000) != 0) {
            return "enum";
        }
        if ((typeModifiers & 0x400) != 0) {
            return "abstractClass";
        }
        if (superName.endsWith("Exception") || superName.endsWith("Error")) {
            return "exception";
        }
        return "class";
    }

    @Override
    public void visitSource(String file, String debug) {
        if (!this.forInnerClass) {
            if (this.cannotModify) {
                throw VisitInterruptedException.INSTANCE;
            }
            this.sourceFileName = this.sourceFileName + file;
            this.fileData = CoverageData.instance().addFile(this.sourceFileName, this.kindOfTopLevelType);
        }
        super.visitSource(file, debug);
    }

    @Override
    public void visitInnerClass(String internalName, String outerName, String innerName, int access) {
        super.visitInnerClass(internalName, outerName, innerName, access);
        if (this.forInnerClass || this.isSyntheticOrEnumClass(access) || !this.isNestedInsideClassBeingModified(outerName)) {
            return;
        }
        String innerClassName = internalName.replace('/', '.');
        if (INNER_CLASS_MODIFIERS.containsKey(innerClassName)) {
            return;
        }
        ClassReader innerCR = CoverageModifier.createClassReader(CoverageModifier.class.getClassLoader(), internalName);
        if (innerCR != null) {
            CoverageModifier innerClassModifier = new CoverageModifier(innerCR, this, innerName);
            innerCR.accept(innerClassModifier, 0);
            INNER_CLASS_MODIFIERS.put(innerClassName, innerClassModifier);
        }
    }

    private boolean isSyntheticOrEnumClass(int access) {
        return (access & 0x1000) != 0 || access == 16392;
    }

    private boolean isNestedInsideClassBeingModified(String outerName) {
        if (outerName == null) {
            return false;
        }
        int p = outerName.indexOf(36);
        String outerClassName = p < 0 ? outerName : outerName.substring(0, p);
        return outerClassName.equals(this.internalClassName);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.fileData != null && (access & 0x1010) == 0 && Metrics.DataCoverage.isActive()) {
            this.fileData.dataCoverageInfo.addField(this.simpleClassName, name, (access & 8) != 0);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean withPathOrDataCoverage;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.fileData == null || (access & 0x1000) != 0) {
            return mv;
        }
        boolean bl = withPathOrDataCoverage = Metrics.PathCoverage.isActive() || Metrics.DataCoverage.isActive();
        if (name.charAt(0) == '<') {
            if (name.charAt(1) == 'c') {
                return this.forEnumClass ? mv : new StaticBlockModifier(mv);
            }
            if (withPathOrDataCoverage) {
                return new ConstructorModifier(mv);
            }
        }
        return withPathOrDataCoverage ? new MethodModifier(mv, name) : new BaseMethodModifier(mv);
    }

    private final class StaticBlockModifier
    extends BaseMethodModifier {
        StaticBlockModifier(MethodVisitor mv) {
            super(mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.assertFoundInCurrentLine = opcode == 182 && "java/lang/Class".equals(owner) && "desiredAssertionStatus".equals(name);
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private final class ConstructorModifier
    extends MethodOrConstructorModifier {
        ConstructorModifier(MethodVisitor mv) {
            super(mv, CoverageModifier.this.simpleClassName);
        }
    }

    private final class MethodModifier
    extends MethodOrConstructorModifier {
        MethodModifier(MethodVisitor mv, String methodName) {
            super(mv, methodName);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            boolean isTestMethod;
            boolean bl = isTestMethod = desc.startsWith("Lorg/junit/") || desc.startsWith("Lorg/testng/");
            if (isTestMethod) {
                throw VisitInterruptedException.INSTANCE;
            }
            return this.mw.visitAnnotation(desc, visible);
        }
    }

    private class MethodOrConstructorModifier
    extends BaseMethodModifier {
        private final String methodOrConstructorName;
        private NodeBuilder nodeBuilder;
        private Label entryPoint;
        private int jumpCount;

        MethodOrConstructorModifier(MethodVisitor mv, String methodOrConstructorName) {
            super(mv);
            this.methodOrConstructorName = methodOrConstructorName;
            this.nodeBuilder = new NodeBuilder();
        }

        public final void visitLabel(Label label) {
            if (this.nodeBuilder == null) {
                super.visitLabel(label);
                return;
            }
            int line = label.line;
            if (this.entryPoint == null) {
                this.entryPoint = new Label();
                this.mw.visitLabel(this.entryPoint);
                this.mw.visitLineNumber(line, this.entryPoint);
                this.nodeBuilder.handleEntry(line);
                this.generateCallToRegisterNodeReached(0);
            }
            super.visitLabel(label);
            int newNodeIndex = this.nodeBuilder.handleJumpTarget(label, line > 0 ? line : this.currentLine);
            this.generateCallToRegisterNodeReached(newNodeIndex);
        }

        private void generateCallToRegisterNodeReached(int nodeIndex) {
            if (nodeIndex >= 0) {
                this.mw.visitLdcInsn(CoverageModifier.this.sourceFileName);
                this.mw.visitLdcInsn(this.nodeBuilder.firstLine);
                this.mw.visitIntInsn(17, nodeIndex);
                this.mw.visitMethodInsn(184, "mockit/coverage/TestRun", "nodeReached", "(Ljava/lang/String;II)V");
            }
        }

        public final void visitJumpInsn(int opcode, Label label) {
            if (this.nodeBuilder == null || this.entryPoint == null || this.visitedLabels.contains(label)) {
                super.visitJumpInsn(opcode, label);
                return;
            }
            boolean conditional = this.isConditionalJump(opcode);
            if (conditional && ++this.jumpCount > MAX_CONDITIONS) {
                this.nodeBuilder = null;
            } else {
                int nodeIndex = this.nodeBuilder.handleJump(label, this.currentLine, conditional);
                this.generateCallToRegisterNodeReached(nodeIndex);
            }
            super.visitJumpInsn(opcode, label);
        }

        public final void visitInsn(int opcode) {
            if (this.nodeBuilder != null) {
                if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                    int newNodeIndex = this.nodeBuilder.handleExit(this.currentLine);
                    this.generateCallToRegisterNodeReached(newNodeIndex);
                } else {
                    this.handleRegularInstruction(opcode);
                }
            }
            super.visitInsn(opcode);
        }

        private void handleRegularInstruction(int opcode) {
            if (this.nodeBuilder != null) {
                int nodeIndex = this.nodeBuilder.handleRegularInstruction(this.currentLine, opcode);
                this.generateCallToRegisterNodeReached(nodeIndex);
            }
        }

        public final void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            this.handleRegularInstruction(opcode);
        }

        public final void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var, increment);
            this.handleRegularInstruction(132);
        }

        public final void visitLdcInsn(Object cst) {
            super.visitLdcInsn(cst);
            this.handleRegularInstruction(18);
        }

        public final void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, desc);
            this.handleRegularInstruction(opcode);
        }

        public final void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            this.handleRegularInstruction(opcode);
        }

        public final void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!Metrics.DataCoverage.isActive()) {
                super.visitFieldInsn(opcode, owner, name, desc);
                return;
            }
            boolean getField = opcode == 178 || opcode == 180;
            boolean isStatic = opcode == 179 || opcode == 178;
            char fieldType = desc.charAt(0);
            boolean size2 = fieldType == 'J' || fieldType == 'D';
            String classAndFieldNames = null;
            boolean fieldHasData = false;
            if (!owner.startsWith("java/") && (fieldHasData = ((CoverageModifier)CoverageModifier.this).fileData.dataCoverageInfo.isFieldWithCoverageData(classAndFieldNames = owner.substring(owner.lastIndexOf(47) + 1) + '.' + name)) && !isStatic) {
                this.generateCodeToSaveInstanceReferenceOnTheStack(getField, size2);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
            if (fieldHasData) {
                this.generateCallToRegisterFieldCoverage(getField, isStatic, size2, classAndFieldNames);
            }
            this.handleRegularInstruction(opcode);
        }

        private void generateCodeToSaveInstanceReferenceOnTheStack(boolean getField, boolean size2) {
            if (getField) {
                this.mw.visitInsn(89);
            } else if (size2) {
                this.mw.visitInsn(93);
                this.mw.visitInsn(88);
                this.mw.visitInsn(91);
                this.mw.visitInsn(91);
                this.mw.visitInsn(87);
            } else {
                this.mw.visitInsn(90);
                this.mw.visitInsn(87);
                this.mw.visitInsn(90);
                this.mw.visitInsn(90);
                this.mw.visitInsn(87);
            }
        }

        private void generateCallToRegisterFieldCoverage(boolean getField, boolean isStatic, boolean size2, String classAndFieldNames) {
            if (!isStatic && getField) {
                if (size2) {
                    this.mw.visitInsn(93);
                    this.mw.visitInsn(88);
                } else {
                    this.mw.visitInsn(90);
                    this.mw.visitInsn(87);
                }
            }
            this.mw.visitLdcInsn(CoverageModifier.this.sourceFileName);
            this.mw.visitLdcInsn(classAndFieldNames);
            String methodToCall = getField ? "fieldRead" : "fieldAssigned";
            String methodDesc = isStatic ? "(Ljava/lang/String;Ljava/lang/String;)V" : "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V";
            this.mw.visitMethodInsn(184, "mockit/coverage/TestRun", methodToCall, methodDesc);
        }

        public final void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            this.handleRegularInstruction(opcode);
        }

        public final void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            super.visitTryCatchBlock(start, end, handler, type);
            this.handleRegularInstruction(0);
        }

        public final void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            if (this.nodeBuilder != null) {
                int nodeIndex = this.nodeBuilder.handleForwardJumpsToNewTargets(dflt, labels, this.currentLine);
                this.generateCallToRegisterNodeReached(nodeIndex);
            }
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public final void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            if (this.nodeBuilder != null) {
                int nodeIndex = this.nodeBuilder.handleForwardJumpsToNewTargets(dflt, labels, this.currentLine);
                this.generateCallToRegisterNodeReached(nodeIndex);
            }
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public final void visitMultiANewArrayInsn(String desc, int dims) {
            super.visitMultiANewArrayInsn(desc, dims);
            this.handleRegularInstruction(197);
        }

        public final void visitEnd() {
            if (this.currentLine > 0 && this.nodeBuilder != null) {
                MethodCoverageData methodData = new MethodCoverageData(this.methodOrConstructorName);
                methodData.buildPaths(this.currentLine, this.nodeBuilder);
                CoverageModifier.this.fileData.addMethod(methodData);
            }
        }
    }

    private class BaseMethodModifier
    extends MethodVisitor {
        static final String DATA_RECORDING_CLASS = "mockit/coverage/TestRun";
        final MethodWriter mw;
        final List<Label> visitedLabels;
        final List<Label> jumpTargetsForCurrentLine;
        private final Map<Label, Label> unconditionalJumps;
        final Map<Integer, Boolean> pendingBranches;
        int currentLine;
        LineCoverageData lineData;
        boolean assertFoundInCurrentLine;
        boolean nextLabelAfterConditionalJump;
        boolean potentialAssertFalseFound;

        BaseMethodModifier(MethodVisitor mv) {
            super(mv);
            this.mw = (MethodWriter)mv;
            this.visitedLabels = new ArrayList<Label>();
            this.jumpTargetsForCurrentLine = new ArrayList<Label>(4);
            this.unconditionalJumps = new HashMap<Label, Label>(2);
            this.pendingBranches = new HashMap<Integer, Boolean>();
        }

        public void visitLineNumber(int line, Label start) {
            if (!this.pendingBranches.isEmpty()) {
                this.pendingBranches.clear();
            }
            this.lineData = CoverageModifier.this.fileData.addLine(line);
            this.currentLine = line;
            this.jumpTargetsForCurrentLine.clear();
            this.nextLabelAfterConditionalJump = false;
            this.unconditionalJumps.clear();
            this.generateCallToRegisterLineExecution();
            this.mw.visitLineNumber(line, start);
        }

        private void generateCallToRegisterLineExecution() {
            this.mw.visitLdcInsn(CoverageModifier.this.sourceFileName);
            this.pushCurrentLineOnTheStack();
            this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, "lineExecuted", "(Ljava/lang/String;I)V");
        }

        private void pushCurrentLineOnTheStack() {
            if (this.currentLine <= Short.MAX_VALUE) {
                this.mw.visitIntInsn(17, this.currentLine);
            } else {
                this.mw.visitLdcInsn(this.currentLine);
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            if (this.lineData == null || this.visitedLabels.contains(label)) {
                this.assertFoundInCurrentLine = false;
                this.mw.visitJumpInsn(opcode, label);
                return;
            }
            this.jumpTargetsForCurrentLine.add(label);
            this.nextLabelAfterConditionalJump = this.isConditionalJump(opcode);
            if (this.nextLabelAfterConditionalJump) {
                int branchIndex = this.lineData.addBranch(this.mw.currentBlock, label);
                this.pendingBranches.put(branchIndex, false);
                if (this.assertFoundInCurrentLine) {
                    BranchCoverageData branchData = this.lineData.getBranchData(branchIndex);
                    branchData.markAsUnreachable();
                }
            } else {
                this.unconditionalJumps.put(label, this.mw.currentBlock);
            }
            this.mw.visitJumpInsn(opcode, label);
            if (this.nextLabelAfterConditionalJump) {
                this.generateCallToRegisterBranchTargetExecutionIfPending();
            }
        }

        protected final boolean isConditionalJump(int opcode) {
            return opcode != 167 && opcode != 168;
        }

        private void generateCallToRegisterBranchTargetExecutionIfPending() {
            this.potentialAssertFalseFound = false;
            if (this.pendingBranches.isEmpty()) {
                return;
            }
            for (Integer branchIndex : this.pendingBranches.keySet()) {
                if (branchIndex >= this.lineData.getBranches().size()) {
                    return;
                }
                BranchCoverageData branchData = this.lineData.getBranchData(branchIndex);
                Boolean firstInsnAfterJump = this.pendingBranches.get(branchIndex);
                if (firstInsnAfterJump.booleanValue()) {
                    branchData.setHasJumpTarget();
                    this.generateCallToRegisterBranchTargetExecution("jumpTargetExecuted", branchIndex);
                    continue;
                }
                branchData.setHasNoJumpTarget();
                this.generateCallToRegisterBranchTargetExecution("noJumpTargetExecuted", branchIndex);
            }
            this.pendingBranches.clear();
        }

        public void visitLabel(Label label) {
            Label unconditionalJumpSource;
            this.visitedLabels.add(label);
            this.mw.visitLabel(label);
            if (this.nextLabelAfterConditionalJump) {
                int branchIndex = this.jumpTargetsForCurrentLine.indexOf(label);
                if (branchIndex >= 0) {
                    this.pendingBranches.put(branchIndex, true);
                    this.assertFoundInCurrentLine = false;
                }
                this.nextLabelAfterConditionalJump = false;
            }
            if ((unconditionalJumpSource = this.unconditionalJumps.get(label)) != null) {
                int branchIndex = this.lineData.addBranch(unconditionalJumpSource, label);
                BranchCoverageData branchData = this.lineData.getBranchData(branchIndex);
                branchData.setHasJumpTarget();
                this.generateCallToRegisterBranchTargetExecution("jumpTargetExecuted", branchIndex);
            }
        }

        private void generateCallToRegisterBranchTargetExecution(String methodName, int branchIndex) {
            this.mw.visitLdcInsn(CoverageModifier.this.sourceFileName);
            this.pushCurrentLineOnTheStack();
            this.mw.visitIntInsn(17, branchIndex);
            this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, methodName, "(Ljava/lang/String;II)V");
        }

        public void visitInsn(int opcode) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTypeInsn(opcode, desc);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitFieldInsn(opcode, owner, name, desc);
            this.assertFoundInCurrentLine = opcode == 178 && "$assertionsDisabled".equals(name);
            this.potentialAssertFalseFound = true;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitIincInsn(var, increment);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitMultiANewArrayInsn(desc, dims);
        }
    }
}

