/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import java.util.ArrayList;
import java.util.List;
import mockit.coverage.CallPoint;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineSegmentData;
import mockit.external.asm4.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineCoverageData
extends LineSegmentData {
    private static final long serialVersionUID = -6233980722802474992L;
    private List<BranchCoverageData> branches;

    public int addBranch(Label jumpSource, Label jumpTarget) {
        if (this.branches == null) {
            this.branches = new ArrayList<BranchCoverageData>(4);
        }
        BranchCoverageData data = new BranchCoverageData(jumpSource, jumpTarget);
        this.branches.add(data);
        return this.branches.size() - 1;
    }

    public BranchCoverageData getBranchData(int index) {
        return this.branches.get(index);
    }

    public void registerExecution(int branchIndex, boolean jumped, CallPoint callPoint) {
        BranchCoverageData data = this.branches.get(branchIndex);
        if (jumped) {
            data.registerJumpExecution(callPoint);
        } else {
            data.registerNoJumpExecution(callPoint);
        }
    }

    public boolean containsBranches() {
        return this.branches != null;
    }

    public List<BranchCoverageData> getBranches() {
        return this.branches;
    }

    public int getNumberOfSegments() {
        return this.branches == null ? 1 : 1 + this.branches.size();
    }

    public int getNumberOfCoveredSegments() {
        if (this.unreachable) {
            return this.getNumberOfSegments();
        }
        if (this.executionCount == 0) {
            return 0;
        }
        if (this.branches == null) {
            return 1;
        }
        return this.getSegmentsCovered();
    }

    private int getSegmentsCovered() {
        int segmentsCovered = 1;
        for (BranchCoverageData branch : this.branches) {
            if (!branch.isCovered()) continue;
            ++segmentsCovered;
        }
        return segmentsCovered;
    }

    public void addCountsFromPreviousTestRun(LineCoverageData previousData) {
        this.addExecutionCountAndCallPointsFromPreviousTestRun(previousData);
        if (this.containsBranches()) {
            for (int i = 0; i < this.branches.size(); ++i) {
                BranchCoverageData segmentData = this.branches.get(i);
                BranchCoverageData previousSegmentData = previousData.branches.get(i);
                segmentData.addCountsFromPreviousTestRun(previousSegmentData);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.branches != null) {
            for (BranchCoverageData branchData : this.branches) {
                branchData.reset();
            }
        }
    }
}

