/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import mockit.coverage.CoverageCheck;
import mockit.coverage.OutputFileGenerator;
import mockit.coverage.data.CoverageData;
import mockit.coverage.modification.ClassModification;
import mockit.coverage.standalone.Startup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeCoverage
implements ClassFileTransformer {
    private static CodeCoverage instance;
    private final ClassModification classModification;
    private final OutputFileGenerator outputGenerator;

    public static void main(String[] args) {
        OutputFileGenerator generator = CodeCoverage.createOutputFileGenerator(null);
        generator.generateAggregateReportFromInputFiles(args);
    }

    private static OutputFileGenerator createOutputFileGenerator(ClassModification classModification) {
        OutputFileGenerator generator = new OutputFileGenerator(classModification);
        CoverageData.instance().setWithCallPoints(generator.isWithCallPoints());
        return generator;
    }

    public CodeCoverage() {
        this(true);
    }

    private CodeCoverage(final boolean generateOutputOnShutdown) {
        if (generateOutputOnShutdown && "none".equals(System.getProperty("jmockit-coverage-output"))) {
            throw new IllegalStateException("JMockit: coverage tool disabled");
        }
        this.classModification = new ClassModification();
        this.outputGenerator = CodeCoverage.createOutputFileGenerator(this.classModification);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (generateOutputOnShutdown) {
                    if (CodeCoverage.this.outputGenerator.isOutputToBeGenerated()) {
                        CodeCoverage.this.outputGenerator.generate();
                    }
                    new CoverageCheck().verifyThresholds();
                }
                Startup.instrumentation().removeTransformer(CodeCoverage.this);
            }
        });
    }

    public static CodeCoverage create(boolean generateOutputOnShutdown) {
        instance = new CodeCoverage(generateOutputOnShutdown);
        return instance;
    }

    public static void resetConfiguration() {
        Startup.instrumentation().removeTransformer(instance);
        CoverageData.instance().clear();
        Startup.instrumentation().addTransformer(CodeCoverage.create(false));
    }

    public static void generateOutput(boolean resetState) {
        CodeCoverage.instance.outputGenerator.generate();
        if (resetState) {
            CoverageData.instance().reset();
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String internalClassName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] originalClassfile) {
        if (loader == null || classBeingRedefined != null || protectionDomain == null) {
            return null;
        }
        String className = internalClassName.replace('/', '.');
        return this.classModification.modifyClass(className, protectionDomain, originalClassfile);
    }
}

