/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.ReverseEWAHIterator;
import com.googlecode.javaewah.RunningLengthWord;

final class ReverseIntIterator
implements IntIterator {
    private final ReverseEWAHIterator ewahIter;
    private final int sizeInBits;
    private final Buffer buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ReverseIntIterator(ReverseEWAHIterator ewahIter, int sizeInBits) {
        this.ewahIter = ewahIter;
        this.sizeInBits = sizeInBits;
        this.buffer = ewahIter.buffer();
        this.runningLength = sizeInBits - 1;
        this.hasNext = this.moveToPreviousRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position--;
        } else {
            long t = this.word & -this.word;
            answer = this.literalPosition - Long.bitCount(t - 1L);
            this.word ^= t;
        }
        this.hasNext = this.moveToPreviousRLW();
        return answer;
    }

    private boolean moveToPreviousRLW() {
        while (!this.literalHasNext() && !this.runningHasNext()) {
            if (!this.ewahIter.hasPrevious()) {
                return false;
            }
            this.setRLW(this.ewahIter.previous());
        }
        return true;
    }

    private void setRLW(RunningLengthWord rlw) {
        int usedBitsInLast;
        this.wordLength = rlw.getNumberOfLiteralWords();
        this.wordPosition = this.ewahIter.position();
        this.position = this.runningLength;
        this.runningLength = (int)((long)this.runningLength - 64L * (rlw.getRunningLength() + (long)this.wordLength));
        if (this.position == this.sizeInBits - 1 && (usedBitsInLast = this.sizeInBits % 64) > 0) {
            this.runningLength += 64 - usedBitsInLast;
        }
        this.runningBit = rlw.getRunningBit();
    }

    private boolean runningHasNext() {
        return this.runningBit && this.runningLength < this.position;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordLength > 0) {
            this.word = Long.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
            int usedBits = 64;
            if (this.position == this.sizeInBits - 1 && (usedBits = this.sizeInBits % 64) > 0) {
                this.word >>>= 64 - usedBits;
            }
            this.literalPosition = this.position;
            this.position -= usedBits;
        }
        return this.word != 0L;
    }
}

