/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.ReverseEWAHIterator32;
import com.googlecode.javaewah32.RunningLengthWord32;

final class ReverseIntIterator32
implements IntIterator {
    private final ReverseEWAHIterator32 ewahIter;
    private final int sizeInBits;
    private final Buffer32 buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ReverseIntIterator32(ReverseEWAHIterator32 ewahIter, int sizeInBits) {
        this.ewahIter = ewahIter;
        this.sizeInBits = sizeInBits;
        this.buffer = ewahIter.buffer();
        this.runningLength = sizeInBits - 1;
        this.hasNext = this.moveToPreviousRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position--;
        } else {
            int t = this.word & -this.word;
            answer = this.literalPosition - Integer.bitCount(t - 1);
            this.word ^= t;
        }
        this.hasNext = this.moveToPreviousRLW();
        return answer;
    }

    private boolean moveToPreviousRLW() {
        while (!this.literalHasNext() && !this.runningHasNext()) {
            if (!this.ewahIter.hasPrevious()) {
                return false;
            }
            this.setRLW(this.ewahIter.previous());
        }
        return true;
    }

    private void setRLW(RunningLengthWord32 rlw) {
        int usedBitsInLast;
        this.wordLength = rlw.getNumberOfLiteralWords();
        this.wordPosition = this.ewahIter.position();
        this.position = this.runningLength;
        this.runningLength -= 32 * (rlw.getRunningLength() + this.wordLength);
        if (this.position == this.sizeInBits - 1 && (usedBitsInLast = this.sizeInBits % 32) > 0) {
            this.runningLength += 32 - usedBitsInLast;
        }
        this.runningBit = rlw.getRunningBit();
    }

    private boolean runningHasNext() {
        return this.runningBit && this.runningLength < this.position;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordLength > 0) {
            this.word = Integer.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
            int usedBits = 32;
            if (this.position == this.sizeInBits - 1 && (usedBits = this.sizeInBits % 32) > 0) {
                this.word >>>= 32 - usedBits;
            }
            this.literalPosition = this.position;
            this.position -= usedBits;
        }
        return this.word != 0;
    }
}

