/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;

public final class BitCounter
implements BitmapStorage {
    private int oneBits;

    @Override
    public void addWord(long newData) {
        this.oneBits += Long.bitCount(newData);
    }

    @Override
    public void addStreamOfLiteralWords(long[] data, int start, int number) {
        for (int i = start; i < start + number; ++i) {
            this.addWord(data[i]);
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (v) {
            this.oneBits = (int)((long)this.oneBits + number * 64L);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(long[] data, int start, int number) {
        for (int i = start; i < start + number; ++i) {
            this.addWord(data[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void clear() {
        this.oneBits = 0;
    }

    public int getCount() {
        return this.oneBits;
    }

    @Override
    public void setSizeInBitsWithinLastWord(int bits) {
    }
}

