/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.RunningLengthWord;

public final class BufferedRunningLengthWord
implements Cloneable {
    public int literalwordoffset = 0;
    public int NumberOfLiteralWords;
    public boolean RunningBit;
    public long RunningLength;

    public BufferedRunningLengthWord(long a) {
        this.NumberOfLiteralWords = (int)(a >>> 33);
        this.RunningBit = (a & 1L) != 0L;
        this.RunningLength = (int)(a >>> 1 & 0xFFFFFFFFL);
    }

    public BufferedRunningLengthWord(RunningLengthWord rlw) {
        this(rlw.array[rlw.position]);
    }

    public void discardFirstWords(long x) {
        if (this.RunningLength >= x) {
            this.RunningLength -= x;
            return;
        }
        this.RunningLength = 0L;
        this.literalwordoffset = (int)((long)this.literalwordoffset + (x -= this.RunningLength));
        this.NumberOfLiteralWords = (int)((long)this.NumberOfLiteralWords - x);
    }

    public int getNumberOfLiteralWords() {
        return this.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.RunningBit;
    }

    public long getRunningLength() {
        return this.RunningLength;
    }

    public void reset(long a) {
        this.NumberOfLiteralWords = (int)(a >>> 33);
        this.RunningBit = (a & 1L) != 0L;
        this.RunningLength = (int)(a >>> 1 & 0xFFFFFFFFL);
        this.literalwordoffset = 0;
    }

    public void reset(RunningLengthWord rlw) {
        this.reset(rlw.array[rlw.position]);
    }

    public void setNumberOfLiteralWords(int number) {
        this.NumberOfLiteralWords = number;
    }

    public void setRunningBit(boolean b) {
        this.RunningBit = b;
    }

    public void setRunningLength(long number) {
        this.RunningLength = number;
    }

    public long size() {
        return this.RunningLength + (long)this.NumberOfLiteralWords;
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public BufferedRunningLengthWord clone() throws CloneNotSupportedException {
        BufferedRunningLengthWord answer = (BufferedRunningLengthWord)super.clone();
        answer.literalwordoffset = this.literalwordoffset;
        answer.NumberOfLiteralWords = this.NumberOfLiteralWords;
        answer.RunningBit = this.RunningBit;
        answer.RunningLength = this.RunningLength;
        return answer;
    }
}

