/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah32.BitCounter32;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.IntIteratorImpl32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.NonEmptyVirtualStorage32;
import com.googlecode.javaewah32.RunningLengthWord32;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EWAHCompressedBitmap32
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage32,
LogicalElement<EWAHCompressedBitmap32> {
    int actualsizeinwords = 1;
    int[] buffer = null;
    RunningLengthWord32 rlw = null;
    int sizeinbits = 0;
    static final int defaultbuffersize = 4;
    public static final boolean usetrailingzeros = true;
    public static final int wordinbits = 32;

    public EWAHCompressedBitmap32() {
        this.buffer = new int[4];
        this.rlw = new RunningLengthWord32(this.buffer, 0);
    }

    public EWAHCompressedBitmap32(int buffersize) {
        this.buffer = new int[buffersize];
        this.rlw = new RunningLengthWord32(this.buffer, 0);
    }

    @Override
    public void add(int newdata) {
        this.add(newdata, 32);
    }

    public void add(int newdata, int bitsthatmatter) {
        this.sizeinbits += bitsthatmatter;
        if (newdata == 0) {
            this.addEmptyWord(false);
        } else if (newdata == -1) {
            this.addEmptyWord(true);
        } else {
            this.addLiteralWord(newdata);
        }
    }

    private int addEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        int runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 65535) {
            this.rlw.setRunningLength(runlen + 1);
            return 0;
        }
        this.push_back(0);
        this.rlw.position = this.actualsizeinwords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1);
        return 1;
    }

    private int addLiteralWord(int newdata) {
        int numbersofar = this.rlw.getNumberOfLiteralWords();
        if (numbersofar >= Short.MAX_VALUE) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            this.rlw.setNumberOfLiteralWords(1);
            this.push_back(newdata);
            return 2;
        }
        this.rlw.setNumberOfLiteralWords(numbersofar + 1);
        this.push_back(newdata);
        return 1;
    }

    @Override
    public void addStreamOfLiteralWords(int[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Short.MAX_VALUE - NumberOfLiteralWords ? number : Short.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 32;
        if (leftovernumber > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfLiteralWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, int number) {
        if (number == 0) {
            return;
        }
        this.sizeinbits += number * 32;
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        int runlen = this.rlw.getRunningLength();
        int whatwecanadd = number < 65535 - runlen ? number : 65535 - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 65535) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(65535);
            number -= 65535;
        }
        if (number > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(int[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Short.MAX_VALUE - NumberOfLiteralWords ? number : Short.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.negative_push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 32;
        if (leftovernumber > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfLiteralWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    @Override
    public EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.and(a, container);
        return container;
    }

    private void and(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.dischargeAsEmpty(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.and(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap32 andNot(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andNot(a, container);
        return container;
    }

    private void andNot(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        IteratingBufferedRunningLengthWord32 remaining;
        EWAHIterator32 i = this.getEWAHIterator();
        EWAHIterator32 j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index;
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & ~rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        } else {
            remaining.dischargeAsEmpty(container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andNot(a, counter);
        return counter.getCount();
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter += 32 * localrlw.getRunningLength();
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Integer.bitCount(i.buffer()[i.literalWords() + j]);
            }
        }
        return counter;
    }

    public void clear() {
        this.sizeinbits = 0;
        this.actualsizeinwords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap32 clone = (EWAHCompressedBitmap32)super.clone();
        clone.buffer = (int[])this.buffer.clone();
        clone.actualsizeinwords = this.actualsizeinwords;
        clone.sizeinbits = this.sizeinbits;
        return clone;
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeinbits = in.readInt();
        this.actualsizeinwords = in.readInt();
        if (this.buffer.length < this.actualsizeinwords) {
            this.buffer = new int[this.actualsizeinwords];
        }
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            this.buffer[k] = in.readInt();
        }
        this.rlw = new RunningLengthWord32(this.buffer, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap32) {
            try {
                this.xor((EWAHCompressedBitmap32)o, new NonEmptyVirtualStorage32());
                return true;
            }
            catch (NonEmptyVirtualStorage32.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, int number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        int runlen = this.rlw.getRunningLength();
        int whatwecanadd = number < 65535 - runlen ? number : 65535 - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 65535) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(65535);
            number -= 65535;
        }
        if (number > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    protected EWAHIterator32 getEWAHIterator() {
        return new EWAHIterator32(this.buffer, this.actualsizeinwords);
    }

    public List<Integer> getPositions() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        v.add(new Integer(pos++));
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (int data = i.buffer()[i.literalWords() + j]; data != 0; data ^= 1 << ntz) {
                    ntz = Integer.numberOfTrailingZeros(data);
                    v.add(new Integer(ntz + pos));
                }
                pos += 32;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeinbits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                karprabin += 31 * karprabin + i.rlw.getRunningLength();
            }
            for (int k = 0; k < i.rlw.getNumberOfLiteralWords(); ++k) {
                karprabin += 31 * karprabin + this.buffer[k + i.literalWords()];
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap32 a) {
        NonEmptyVirtualStorage32 nevs = new NonEmptyVirtualStorage32();
        try {
            this.and(a, nevs);
        }
        catch (NonEmptyVirtualStorage32.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl32(new EWAHIterator32(this.buffer, this.actualsizeinwords));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap32.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return new Integer(this.under.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    private void negative_push_back(int[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        for (int k = 0; k < number; ++k) {
            this.buffer[this.actualsizeinwords + k] = ~data[start + k];
        }
        this.actualsizeinwords += number;
    }

    @Override
    public void not() {
        RunningLengthWord32 rlw1;
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.literalWords() + j] = ~i.buffer()[i.literalWords() + j];
            }
        } while (i.hasNext());
        int usedbitsinlast = this.sizeinbits % 32;
        if (usedbitsinlast == 0) {
            return;
        }
        if (rlw1.getNumberOfLiteralWords() == 0) {
            if (rlw1.getRunningLength() > 0 && rlw1.getRunningBit()) {
                rlw1.setRunningLength(rlw1.getRunningLength() - 1);
                this.addLiteralWord(-1 >>> 32 - usedbitsinlast);
            }
            return;
        }
        int[] nArray = i.buffer();
        int n = i.literalWords() + rlw1.getNumberOfLiteralWords() - 1;
        nArray[n] = nArray[n] & -1 >>> 32 - usedbitsinlast;
    }

    public int oldaddStreamOfEmptyWords(boolean v, int number) {
        if (number == 0) {
            return 0;
        }
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        int runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0) {
            this.rlw.setRunningBit(v);
        }
        int wordsadded = 0;
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 65535) {
            int whatwecanadd = number < 65535 - runlen ? number : 65535 - runlen;
            this.rlw.setRunningLength(runlen + whatwecanadd);
            this.sizeinbits += whatwecanadd * 32;
            if (number - whatwecanadd > 0) {
                this.addStreamOfEmptyWords(v, number - whatwecanadd);
            }
        } else {
            this.push_back(0);
            ++wordsadded;
            this.rlw.position = this.actualsizeinwords - 1;
            int whatwecanadd = number < 65535 ? number : 65535;
            this.rlw.setRunningBit(v);
            this.rlw.setRunningLength(whatwecanadd);
            this.sizeinbits += whatwecanadd * 32;
            if (number - whatwecanadd > 0) {
                this.addStreamOfEmptyWords(v, number - whatwecanadd);
            }
        }
        return wordsadded;
    }

    public EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.or(a, container);
        return container;
    }

    private void or(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.or(a, counter);
        return counter.getCount();
    }

    private void push_back(int data) {
        if (this.actualsizeinwords == this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        this.buffer[this.actualsizeinwords++] = data;
    }

    private void push_back(int[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        System.arraycopy(data, start, this.buffer, this.actualsizeinwords, number);
        this.actualsizeinwords += number;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    private boolean reserve(int size) {
        if (size > this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[size];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
            return true;
        }
        return false;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeinbits);
        out.writeInt(this.actualsizeinwords);
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            out.writeInt(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean set(int i) {
        if (i > 0x7FFFFFDF || i < 0) {
            throw new IndexOutOfBoundsException("Set values should be between 0 and 2147483615");
        }
        if (i < this.sizeinbits) {
            return false;
        }
        int dist = (i + 32) / 32 - (this.sizeinbits + 32 - 1) / 32;
        this.sizeinbits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.addLiteralWord(1 << i % 32);
            return true;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
            this.addLiteralWord(1 << i % 32);
            return true;
        }
        int n = this.actualsizeinwords - 1;
        this.buffer[n] = this.buffer[n] | 1 << i % 32;
        if (this.buffer[this.actualsizeinwords - 1] == -1) {
            this.buffer[this.actualsizeinwords - 1] = 0;
            --this.actualsizeinwords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.addEmptyWord(true);
        }
        return true;
    }

    @Override
    public void setSizeInBits(int size) {
        this.sizeinbits = size;
    }

    public boolean setSizeInBits(int size, boolean defaultvalue) {
        if (size < this.sizeinbits) {
            return false;
        }
        if (defaultvalue) {
            while (this.sizeinbits % 32 != 0 && this.sizeinbits < size) {
                this.set(this.sizeinbits);
            }
        }
        if (!defaultvalue) {
            EWAHCompressedBitmap32.extendEmptyBits(this, this.sizeinbits, size);
        } else {
            int leftover = size % 32;
            this.addStreamOfEmptyWords(defaultvalue, size / 32 - this.sizeinbits / 32);
            int newdata = (1 << leftover) - 1;
            this.addLiteralWord(newdata);
        }
        this.sizeinbits = size;
        return true;
    }

    @Override
    public int sizeInBits() {
        return this.sizeinbits;
    }

    @Override
    public int sizeInBytes() {
        return this.actualsizeinwords * 4;
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        ans[inanspos++] = pos++;
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int data = i.buffer()[i.literalWords() + j];
                while (data != 0) {
                    int ntz = Integer.numberOfTrailingZeros(data);
                    data = (int)((long)data ^ 1L << ntz);
                    ans[inanspos++] = ntz + pos;
                }
                pos += 32;
            }
        }
        return ans;
    }

    public String toDebugString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int data = i.buffer()[i.literalWords() + j];
                ans = ans + "\t" + data + "\n";
            }
        }
        return ans;
    }

    public String toString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
        }
        return ans;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.xor(a, container);
        return container;
    }

    private void xor(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index;
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.xor(a, counter);
        return counter.getCount();
    }

    /*
     * Unable to fully structure code
     */
    private static void and(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].and(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeinbits < b.sizeinbits ? -1 : (a.sizeinbits == b.sizeinbits ? 0 : 1);
            }
        });
        maxSize = sortedBitmaps[sortedBitmaps.length - 1].sizeinbits;
        rlws = new IteratingBufferedRunningLengthWord32[bitmaps.length];
        for (i = 0; i < sortedBitmaps.length; ++i) {
            iterator = sortedBitmaps[i].getEWAHIterator();
            if (!iterator.hasNext()) {
                if (maxSize > 0) {
                    EWAHCompressedBitmap32.extendEmptyBits(container, 0, maxSize);
                }
                container.setSizeInBits(maxSize);
                return;
            }
            rlws[i] = new IteratingBufferedRunningLengthWord32(iterator);
        }
        block1: while (true) {
            maxZeroRl = 0;
            minOneRl = 0x7FFFFFFF;
            minSize = 0x7FFFFFFF;
            numEmptyRl = 0;
            if (rlws[0].size() == 0) break;
            for (IteratingBufferedRunningLengthWord32 rlw : rlws) {
                size = rlw.size();
                minSize = Math.min(minSize, size);
                if (!rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxZeroRl = Math.max(maxZeroRl, rl);
                    minOneRl = 0;
                    if (rl != 0 || size <= 0) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minOneRl = Math.min(minOneRl, rl);
                if (rl != 0 || size <= 0) continue;
                ++numEmptyRl;
            }
            if (maxZeroRl > 0) {
                container.addStreamOfEmptyWords(false, maxZeroRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(maxZeroRl);
                    ++i$;
                }
            }
            if (minOneRl > 0) {
                container.addStreamOfEmptyWords(true, minOneRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(minOneRl);
                    ++i$;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFF;
                for (IteratingBufferedRunningLengthWord32 rlw : rlws) {
                    rl = rlw.getRunningLength();
                    if (rl == 0) {
                        if (!EWAHCompressedBitmap32.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeLiteralWords(wordsToWrite, container);
                }
                index += wordsToWrite;
            }
            while (index < minSize) {
                word = -1;
                for (IteratingBufferedRunningLengthWord32 rlw : rlws) {
                    if (rlw.getRunningLength() > index) continue;
                    word &= rlw.getLiteralWordAt(index - rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            arr$ = rlws;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ >= len$) ** break;
                rlw = arr$[i$];
                rlw.discardFirstWords(minSize);
                ++i$;
            }
            break;
        }
        EWAHCompressedBitmap32.extendEmptyBits(container, sortedBitmaps[0].sizeinbits, maxSize);
        container.setSizeInBits(maxSize);
    }

    public static EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.and((BitmapStorage32)container, bitmaps);
        return container;
    }

    public static int andCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.and(counter, bitmaps);
        return counter.getCount();
    }

    public static EWAHCompressedBitmap32 bitmapOf(int ... setbits) {
        EWAHCompressedBitmap32 a = new EWAHCompressedBitmap32();
        for (int k : setbits) {
            a.set(k);
        }
        return a;
    }

    private static void extendEmptyBits(BitmapStorage32 storage, int currentSize, int newSize) {
        int currentLeftover = currentSize % 32;
        int finalLeftover = newSize % 32;
        storage.addStreamOfEmptyWords(false, newSize / 32 - currentSize / 32 + (finalLeftover != 0 ? 1 : 0) + (currentLeftover != 0 ? -1 : 0));
    }

    /*
     * Unable to fully structure code
     */
    private static void or(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].or(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeinbits < b.sizeinbits ? 1 : (a.sizeinbits == b.sizeinbits ? 0 : -1);
            }
        });
        rlws = new IteratingBufferedRunningLengthWord32[bitmaps.length];
        maxAvailablePos = 0;
        for (EWAHCompressedBitmap32 bitmap : sortedBitmaps) {
            iterator = bitmap.getEWAHIterator();
            if (!iterator.hasNext()) continue;
            rlws[maxAvailablePos++] = new IteratingBufferedRunningLengthWord32(iterator);
        }
        if (maxAvailablePos == 0) {
            container.setSizeInBits(0);
            return;
        }
        maxSize = sortedBitmaps[0].sizeinbits;
        block1: while (true) {
            maxOneRl = 0;
            minZeroRl = 0x7FFFFFFF;
            minSize = 0x7FFFFFFF;
            numEmptyRl = 0;
            for (i = 0; i < maxAvailablePos; ++i) {
                rlw = rlws[i];
                size = rlw.size();
                if (size == 0) {
                    maxAvailablePos = i;
                    break;
                }
                minSize = Math.min(minSize, size);
                if (rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxOneRl = Math.max(maxOneRl, rl);
                    minZeroRl = 0;
                    if (rl != 0 || size <= 0) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minZeroRl = Math.min(minZeroRl, rl);
                if (rl != 0 || size <= 0) continue;
                ++numEmptyRl;
            }
            if (maxAvailablePos == 0) break;
            if (maxAvailablePos == 1) {
                rlws[0].discharge(container);
                break;
            }
            if (maxOneRl > 0) {
                container.addStreamOfEmptyWords(true, maxOneRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(maxOneRl);
                    ++i;
                }
            }
            if (minZeroRl > 0) {
                container.addStreamOfEmptyWords(false, minZeroRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(minZeroRl);
                    ++i;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFF;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    rl = rlw.getRunningLength();
                    if (rl == 0) {
                        if (!EWAHCompressedBitmap32.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeLiteralWords(wordsToWrite, container);
                }
                index += wordsToWrite;
            }
            while (index < minSize) {
                word = 0;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    if (rlw.getRunningLength() > index) continue;
                    word |= rlw.getLiteralWordAt(index - rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            i = 0;
            while (true) {
                if (i < maxAvailablePos) ** break;
                continue block1;
                rlw = rlws[i];
                rlw.discardFirstWords(minSize);
                ++i;
            }
            break;
        }
        container.setSizeInBits(maxSize);
    }

    public static EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.or((BitmapStorage32)container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.or(counter, bitmaps);
        return counter.getCount();
    }
}

