/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.BufferedRunningLengthWord;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;

public final class IteratingBufferedRunningLengthWord {
    private BufferedRunningLengthWord brlw;
    private long[] buffer;
    private int literalWordStartPosition;
    private EWAHIterator iterator;

    public IteratingBufferedRunningLengthWord(EWAHIterator iterator) {
        this.iterator = iterator;
        this.brlw = new BufferedRunningLengthWord(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        this.buffer = this.iterator.buffer();
    }

    public IteratingBufferedRunningLengthWord(EWAHCompressedBitmap bitmap) {
        this(EWAHIterator.getEWAHIterator(bitmap));
    }

    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.brlw.RunningLength > x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0L;
            long toDiscard = (x -= this.brlw.RunningLength) > (long)this.brlw.NumberOfLiteralWords ? (long)this.brlw.NumberOfLiteralWords : x;
            this.literalWordStartPosition = (int)((long)this.literalWordStartPosition + toDiscard);
            this.brlw.NumberOfLiteralWords = (int)((long)this.brlw.NumberOfLiteralWords - toDiscard);
            if ((x -= toDiscard) <= 0L && this.brlw.size() != 0L) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        }
    }

    public long discharge(BitmapStorage container, long max) {
        long index;
        int pd;
        for (index = 0L; index < max && this.size() > 0L; index += (long)pd) {
            long pl = this.getRunningLength();
            if (index + pl > max) {
                pl = max - index;
            }
            container.addStreamOfEmptyWords(this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index += pl) > max) {
                pd = (int)(max - index);
            }
            this.writeLiteralWords(pd, container);
            this.discardFirstWords(pl + (long)pd);
        }
        return index;
    }

    public long dischargeNegated(BitmapStorage container, long max) {
        long index;
        int pd;
        for (index = 0L; index < max && this.size() > 0L; index += (long)pd) {
            long pl = this.getRunningLength();
            if (index + pl > max) {
                pl = max - index;
            }
            container.addStreamOfEmptyWords(!this.getRunningBit(), pl);
            this.discardFirstWords(pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index += pl) > max) {
                pd = (int)(max - index);
            }
            this.writeNegatedLiteralWords(pd, container);
            this.discardFirstWords(pd);
        }
        return index;
    }

    public void dischargeAsEmpty(BitmapStorage container) {
        while (this.size() > 0L) {
            container.addStreamOfEmptyWords(false, this.size());
            this.discardFirstWords(this.size());
        }
    }

    public void discharge(BitmapStorage container) {
        this.brlw.literalwordoffset = this.literalWordStartPosition - this.iterator.literalWords();
        IteratingBufferedRunningLengthWord.discharge(this.brlw, this.iterator, container);
    }

    public long getLiteralWordAt(int index) {
        return this.buffer[this.literalWordStartPosition + index];
    }

    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    public long getRunningLength() {
        return this.brlw.RunningLength;
    }

    public long size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int numWords, BitmapStorage container) {
        container.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    public void writeNegatedLiteralWords(int numWords, BitmapStorage container) {
        container.addStreamOfNegatedLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    private static void discharge(BufferedRunningLengthWord initialWord, EWAHIterator iterator, BitmapStorage container) {
        BufferedRunningLengthWord runningLengthWord = initialWord;
        while (true) {
            long runningLength = runningLengthWord.getRunningLength();
            container.addStreamOfEmptyWords(runningLengthWord.getRunningBit(), runningLength);
            container.addStreamOfLiteralWords(iterator.buffer(), iterator.literalWords() + runningLengthWord.literalwordoffset, runningLengthWord.getNumberOfLiteralWords());
            if (!iterator.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord(iterator.next());
        }
    }
}

