/*
 * Decompiled with CFR 0.152.
 */
package javaewah32;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javaewah.IntIterator;
import javaewah32.BitCounter32;
import javaewah32.BitmapStorage32;
import javaewah32.BufferedRunningLengthWord32;
import javaewah32.EWAHIterator32;
import javaewah32.IteratingBufferedRunningLengthWord32;
import javaewah32.NonEmptyVirtualStorage32;
import javaewah32.RunningLengthWord32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EWAHCompressedBitmap32
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage32 {
    static final int defaultbuffersize = 4;
    int[] buffer = null;
    int actualsizeinwords = 1;
    int sizeinbits = 0;
    RunningLengthWord32 rlw = null;
    public static final int wordinbits = 32;
    public static final boolean usetrailingzeros = true;

    public EWAHCompressedBitmap32() {
        this.buffer = new int[4];
        this.rlw = new RunningLengthWord32(this.buffer, 0);
    }

    public EWAHCompressedBitmap32(int buffersize) {
        this.buffer = new int[buffersize];
        this.rlw = new RunningLengthWord32(this.buffer, 0);
    }

    private EWAHIterator32 getEWAHIterator() {
        return new EWAHIterator32(this.buffer, this.actualsizeinwords);
    }

    public EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.xor(a, container);
        return container;
    }

    private void xor(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
        }
        BufferedRunningLengthWord32 rlwi = new BufferedRunningLengthWord32(i.next());
        BufferedRunningLengthWord32 rlwj = new BufferedRunningLengthWord32(j.next());
        while (true) {
            int nbre_dirty_prey;
            int k;
            int[] buf;
            int dw_predator;
            int tobediscarded;
            int preyrl;
            int predatorrl;
            BufferedRunningLengthWord32 predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord32 bufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                predatorrl = predator.getRunningLength();
                tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                container.addStreamOfDirtyWords(i_is_prey ? j.buffer() : i.buffer(), dw_predator, preyrl - tobediscarded);
                predator.discardFirstWords(preyrl);
                prey.discardFirstWords(preyrl);
            } else {
                predatorrl = predator.getRunningLength();
                tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(!predator.getRunningBit(), tobediscarded);
                dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                buf = i_is_prey ? j.buffer() : i.buffer();
                for (k = 0; k < preyrl - tobediscarded; ++k) {
                    container.add(~buf[k + dw_predator]);
                }
                predator.discardFirstWords(preyrl);
                prey.discardFirstWords(preyrl);
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0) {
                int dw_prey;
                if (!predator.getRunningBit()) {
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    container.addStreamOfDirtyWords(i_is_prey ? i.buffer() : j.buffer(), dw_prey, tobediscarded);
                } else {
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    buf = i_is_prey ? i.buffer() : j.buffer();
                    for (k = 0; k < tobediscarded; ++k) {
                        container.add(~buf[k + dw_prey]);
                    }
                }
            }
            if ((nbre_dirty_prey = prey.getNumberOfLiteralWords()) > 0) {
                for (int k2 = 0; k2 < nbre_dirty_prey; ++k2) {
                    if (i_is_prey) {
                        container.add(i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k2] ^ j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k2]);
                        continue;
                    }
                    container.add(i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k2] ^ j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k2]);
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap32.discharge(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap32.discharge(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.and(a, container);
        return container;
    }

    private void and(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
        }
        BufferedRunningLengthWord32 rlwi = new BufferedRunningLengthWord32(i.next());
        BufferedRunningLengthWord32 rlwj = new BufferedRunningLengthWord32(j.next());
        while (true) {
            int nbre_dirty_prey;
            int tobediscarded;
            int predatorrl;
            BufferedRunningLengthWord32 predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord32 bufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                container.addStreamOfEmptyWords(false, prey.RunningLength);
                predator.discardFirstWords(prey.RunningLength);
                prey.RunningLength = 0;
            } else {
                int preyrl;
                predatorrl = predator.getRunningLength();
                tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                int dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                container.addStreamOfDirtyWords(i_is_prey ? j.buffer() : i.buffer(), dw_predator, preyrl - tobediscarded);
                predator.discardFirstWords(preyrl);
                prey.RunningLength = 0;
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0) {
                if (!predator.getRunningBit()) {
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    container.addStreamOfEmptyWords(false, tobediscarded);
                } else {
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    int tobediscarded2 = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    container.addStreamOfDirtyWords(i_is_prey ? i.buffer() : j.buffer(), dw_prey, tobediscarded2);
                    predator.discardFirstWords(tobediscarded2);
                    prey.discardFirstWords(tobediscarded2);
                }
            }
            if ((nbre_dirty_prey = prey.getNumberOfLiteralWords()) > 0) {
                for (int k = 0; k < nbre_dirty_prey; ++k) {
                    if (i_is_prey) {
                        container.add(i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k] & j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k]);
                        continue;
                    }
                    container.add(i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k] & j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k]);
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap32.dischargeAsEmpty(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap32.dischargeAsEmpty(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public static EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.and((BitmapStorage32)container, bitmaps);
        return container;
    }

    public static int andCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.and(counter, bitmaps);
        return counter.getCount();
    }

    /*
     * Unable to fully structure code
     */
    private static void and(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].and(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeinbits < b.sizeinbits ? -1 : (a.sizeinbits == b.sizeinbits ? 0 : 1);
            }
        });
        maxSize = sortedBitmaps[sortedBitmaps.length - 1].sizeinbits;
        rlws = new IteratingBufferedRunningLengthWord32[bitmaps.length];
        for (i = 0; i < sortedBitmaps.length; ++i) {
            iterator = sortedBitmaps[i].getEWAHIterator();
            if (!iterator.hasNext()) {
                if (maxSize > 0) {
                    EWAHCompressedBitmap32.extendEmptyBits(container, 0, maxSize);
                }
                container.setSizeInBits(maxSize);
                return;
            }
            rlws[i] = new IteratingBufferedRunningLengthWord32(iterator);
        }
        block1: while (true) {
            maxZeroRl = 0;
            minOneRl = 0x7FFFFFFF;
            minSize = 0x7FFFFFFF;
            numEmptyRl = 0;
            if (rlws[0].size() == 0) break;
            for (IteratingBufferedRunningLengthWord32 rlw : rlws) {
                size = rlw.size();
                minSize = Math.min(minSize, size);
                if (!rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxZeroRl = Math.max(maxZeroRl, rl);
                    minOneRl = 0;
                    if (rl != 0 || size <= 0) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minOneRl = Math.min(minOneRl, rl);
                if (rl != 0 || size <= 0) continue;
                ++numEmptyRl;
            }
            if (maxZeroRl > 0) {
                container.addStreamOfEmptyWords(false, maxZeroRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(maxZeroRl);
                    ++i$;
                }
            }
            if (minOneRl > 0) {
                container.addStreamOfEmptyWords(true, minOneRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(minOneRl);
                    ++i$;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFF;
                for (IteratingBufferedRunningLengthWord32 rlw : rlws) {
                    rl = rlw.getRunningLength();
                    if (rl == 0) {
                        if (!EWAHCompressedBitmap32.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeDirtyWords(wordsToWrite, container);
                }
                index += wordsToWrite;
            }
            while (index < minSize) {
                word = -1;
                for (IteratingBufferedRunningLengthWord32 rlw : rlws) {
                    if (rlw.getRunningLength() > index) continue;
                    word &= rlw.getDirtyWordAt(index - rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            arr$ = rlws;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ >= len$) ** break;
                rlw = arr$[i$];
                rlw.discardFirstWords(minSize);
                ++i$;
            }
            break;
        }
        EWAHCompressedBitmap32.extendEmptyBits(container, sortedBitmaps[0].sizeinbits, maxSize);
        container.setSizeInBits(maxSize);
    }

    public boolean intersects(EWAHCompressedBitmap32 a) {
        NonEmptyVirtualStorage32 nevs = new NonEmptyVirtualStorage32();
        try {
            this.and(a, nevs);
        }
        catch (NonEmptyVirtualStorage32.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public EWAHCompressedBitmap32 andNot(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andNot(a, container);
        return container;
    }

    private void andNot(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        BufferedRunningLengthWord32 rlwi;
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
        }
        rlwi.setRunningBit(!(rlwi = new BufferedRunningLengthWord32(i.next())).getRunningBit());
        BufferedRunningLengthWord32 rlwj = new BufferedRunningLengthWord32(j.next());
        while (true) {
            int nbre_dirty_prey;
            int tobediscarded;
            int predatorrl;
            BufferedRunningLengthWord32 predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord32 bufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                container.addStreamOfEmptyWords(false, prey.RunningLength);
                predator.discardFirstWords(prey.RunningLength);
                prey.RunningLength = 0;
            } else {
                int preyrl;
                predatorrl = predator.getRunningLength();
                tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                int dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                if (i_is_prey) {
                    container.addStreamOfDirtyWords(j.buffer(), dw_predator, preyrl - tobediscarded);
                } else {
                    container.addStreamOfNegatedDirtyWords(i.buffer(), dw_predator, preyrl - tobediscarded);
                }
                predator.discardFirstWords(preyrl);
                prey.RunningLength = 0;
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0) {
                if (!predator.getRunningBit()) {
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    container.addStreamOfEmptyWords(false, tobediscarded);
                } else {
                    int tobediscarded2;
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    int n = tobediscarded2 = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    if (i_is_prey) {
                        container.addStreamOfNegatedDirtyWords(i.buffer(), dw_prey, tobediscarded2);
                    } else {
                        container.addStreamOfDirtyWords(j.buffer(), dw_prey, tobediscarded2);
                    }
                    predator.discardFirstWords(tobediscarded2);
                    prey.discardFirstWords(tobediscarded2);
                }
            }
            if ((nbre_dirty_prey = prey.getNumberOfLiteralWords()) > 0) {
                for (int k = 0; k < nbre_dirty_prey; ++k) {
                    if (i_is_prey) {
                        container.add(~i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k] & j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k]);
                        continue;
                    }
                    container.add(~i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k] & j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k]);
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                rlwi.setRunningBit(!rlwi.getRunningBit());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap32.dischargeAsEmpty(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap32.discharge(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public void not() {
        RunningLengthWord32 rlw1;
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.dirtyWords() + j] = ~i.buffer()[i.dirtyWords() + j];
            }
        } while (i.hasNext());
        if (rlw1.getNumberOfLiteralWords() == 0) {
            return;
        }
        int usedbitsinlast = this.sizeinbits % 32;
        if (usedbitsinlast == 0) {
            return;
        }
        int[] nArray = i.buffer();
        int n = i.dirtyWords() + rlw1.getNumberOfLiteralWords() - 1;
        nArray[n] = nArray[n] & -1 >>> 32 - usedbitsinlast;
    }

    public EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.or(a, container);
        return container;
    }

    public int orCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.or(a, counter);
        return counter.getCount();
    }

    public int andCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.and(a, counter);
        return counter.getCount();
    }

    public int andNotCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andNot(a, counter);
        return counter.getCount();
    }

    public int xorCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.xor(a, counter);
        return counter.getCount();
    }

    private void or(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
            return;
        }
        BufferedRunningLengthWord32 rlwi = new BufferedRunningLengthWord32(i.next());
        BufferedRunningLengthWord32 rlwj = new BufferedRunningLengthWord32(j.next());
        while (true) {
            int nbre_dirty_prey;
            int tobediscarded;
            int predatorrl;
            BufferedRunningLengthWord32 predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord32 bufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                int preyrl;
                predatorrl = predator.getRunningLength();
                tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                int dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                container.addStreamOfDirtyWords(i_is_prey ? j.buffer() : i.buffer(), dw_predator, preyrl - tobediscarded);
                predator.discardFirstWords(preyrl);
                prey.discardFirstWords(preyrl);
                prey.RunningLength = 0;
            } else {
                container.addStreamOfEmptyWords(true, prey.RunningLength);
                predator.discardFirstWords(prey.RunningLength);
                prey.RunningLength = 0;
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0) {
                if (!predator.getRunningBit()) {
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    container.addStreamOfDirtyWords(i_is_prey ? i.buffer() : j.buffer(), dw_prey, tobediscarded);
                } else {
                    nbre_dirty_prey = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= nbre_dirty_prey ? nbre_dirty_prey : predatorrl;
                    container.addStreamOfEmptyWords(true, tobediscarded);
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                }
            }
            if ((nbre_dirty_prey = prey.getNumberOfLiteralWords()) > 0) {
                for (int k = 0; k < nbre_dirty_prey; ++k) {
                    if (i_is_prey) {
                        container.add(i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k] | j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k]);
                        continue;
                    }
                    container.add(i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k] | j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k]);
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap32.discharge(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap32.discharge(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public static EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.or((BitmapStorage32)container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.or(counter, bitmaps);
        return counter.getCount();
    }

    /*
     * Unable to fully structure code
     */
    private static void or(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].or(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeinbits < b.sizeinbits ? 1 : (a.sizeinbits == b.sizeinbits ? 0 : -1);
            }
        });
        rlws = new IteratingBufferedRunningLengthWord32[bitmaps.length];
        maxAvailablePos = 0;
        for (EWAHCompressedBitmap32 bitmap : sortedBitmaps) {
            iterator = bitmap.getEWAHIterator();
            if (!iterator.hasNext()) continue;
            rlws[maxAvailablePos++] = new IteratingBufferedRunningLengthWord32(iterator);
        }
        if (maxAvailablePos == 0) {
            container.setSizeInBits(0);
            return;
        }
        maxSize = sortedBitmaps[0].sizeinbits;
        block1: while (true) {
            maxOneRl = 0;
            minZeroRl = 0x7FFFFFFF;
            minSize = 0x7FFFFFFF;
            numEmptyRl = 0;
            for (i = 0; i < maxAvailablePos; ++i) {
                rlw = rlws[i];
                size = rlw.size();
                if (size == 0) {
                    maxAvailablePos = i;
                    break;
                }
                minSize = Math.min(minSize, size);
                if (rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxOneRl = Math.max(maxOneRl, rl);
                    minZeroRl = 0;
                    if (rl != 0 || size <= 0) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minZeroRl = Math.min(minZeroRl, rl);
                if (rl != 0 || size <= 0) continue;
                ++numEmptyRl;
            }
            if (maxAvailablePos == 0) break;
            if (maxAvailablePos == 1) {
                rlws[0].discharge(container);
                break;
            }
            if (maxOneRl > 0) {
                container.addStreamOfEmptyWords(true, maxOneRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(maxOneRl);
                    ++i;
                }
            }
            if (minZeroRl > 0) {
                container.addStreamOfEmptyWords(false, minZeroRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(minZeroRl);
                    ++i;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFF;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    rl = rlw.getRunningLength();
                    if (rl == 0) {
                        if (!EWAHCompressedBitmap32.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeDirtyWords(wordsToWrite, container);
                }
                index += wordsToWrite;
            }
            while (index < minSize) {
                word = 0;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    if (rlw.getRunningLength() > index) continue;
                    word |= rlw.getDirtyWordAt(index - rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            i = 0;
            while (true) {
                if (i < maxAvailablePos) ** break;
                continue block1;
                rlw = rlws[i];
                rlw.discardFirstWords(minSize);
                ++i;
            }
            break;
        }
        container.setSizeInBits(maxSize);
    }

    protected static void discharge(BufferedRunningLengthWord32 initialWord, EWAHIterator32 iterator, BitmapStorage32 container) {
        BufferedRunningLengthWord32 runningLengthWord = initialWord;
        while (true) {
            int runningLength = runningLengthWord.getRunningLength();
            container.addStreamOfEmptyWords(runningLengthWord.getRunningBit(), runningLength);
            container.addStreamOfDirtyWords(iterator.buffer(), iterator.dirtyWords() + runningLengthWord.dirtywordoffset, runningLengthWord.getNumberOfLiteralWords());
            if (!iterator.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord32(iterator.next());
        }
    }

    private static void dischargeAsEmpty(BufferedRunningLengthWord32 initialWord, EWAHIterator32 iterator, BitmapStorage32 container) {
        BufferedRunningLengthWord32 runningLengthWord = initialWord;
        while (true) {
            int runningLength = runningLengthWord.getRunningLength();
            container.addStreamOfEmptyWords(false, runningLength + runningLengthWord.getNumberOfLiteralWords());
            if (!iterator.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord32(iterator.next());
        }
    }

    public boolean set(int i) {
        if (i > 0x7FFFFFDF || i < 0) {
            throw new IndexOutOfBoundsException("Set values should be between 0 and 2147483615");
        }
        if (i < this.sizeinbits) {
            return false;
        }
        int dist = (i + 32) / 32 - (this.sizeinbits + 32 - 1) / 32;
        this.sizeinbits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.addLiteralWord(1 << i % 32);
            return true;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
            this.addLiteralWord(1 << i % 32);
            return true;
        }
        int n = this.actualsizeinwords - 1;
        this.buffer[n] = this.buffer[n] | 1 << i % 32;
        if (this.buffer[this.actualsizeinwords - 1] == -1) {
            this.buffer[this.actualsizeinwords - 1] = 0;
            --this.actualsizeinwords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.addEmptyWord(true);
        }
        return true;
    }

    @Override
    public void add(int newdata) {
        this.add(newdata, 32);
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, int number) {
        if (number == 0) {
            return;
        }
        this.sizeinbits += number * 32;
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        int runlen = this.rlw.getRunningLength();
        int whatwecanadd = number < 65535 - runlen ? number : 65535 - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 65535) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(65535);
            number -= 65535;
        }
        if (number > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    private void fastaddStreamOfEmptyWords(boolean v, int number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        int runlen = this.rlw.getRunningLength();
        int whatwecanadd = number < 65535 - runlen ? number : 65535 - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 65535) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(65535);
            number -= 65535;
        }
        if (number > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    public int oldaddStreamOfEmptyWords(boolean v, int number) {
        if (number == 0) {
            return 0;
        }
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        int runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0) {
            this.rlw.setRunningBit(v);
        }
        int wordsadded = 0;
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 65535) {
            int whatwecanadd = number < 65535 - runlen ? number : 65535 - runlen;
            this.rlw.setRunningLength(runlen + whatwecanadd);
            this.sizeinbits += whatwecanadd * 32;
            if (number - whatwecanadd > 0) {
                this.addStreamOfEmptyWords(v, number - whatwecanadd);
            }
        } else {
            this.push_back(0);
            ++wordsadded;
            this.rlw.position = this.actualsizeinwords - 1;
            int whatwecanadd = number < 65535 ? number : 65535;
            this.rlw.setRunningBit(v);
            this.rlw.setRunningLength(whatwecanadd);
            this.sizeinbits += whatwecanadd * 32;
            if (number - whatwecanadd > 0) {
                this.addStreamOfEmptyWords(v, number - whatwecanadd);
            }
        }
        return wordsadded;
    }

    @Override
    public void addStreamOfNegatedDirtyWords(int[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Short.MAX_VALUE - NumberOfLiteralWords ? number : Short.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.negative_push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 32;
        if (leftovernumber > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfDirtyWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    @Override
    public void addStreamOfDirtyWords(int[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Short.MAX_VALUE - NumberOfLiteralWords ? number : Short.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 32;
        if (leftovernumber > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfDirtyWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    public void add(int newdata, int bitsthatmatter) {
        this.sizeinbits += bitsthatmatter;
        if (newdata == 0) {
            this.addEmptyWord(false);
        } else if (newdata == -1) {
            this.addEmptyWord(true);
        } else {
            this.addLiteralWord(newdata);
        }
    }

    public int sizeInBits() {
        return this.sizeinbits;
    }

    @Override
    public void setSizeInBits(int size) {
        this.sizeinbits = size;
    }

    public boolean setSizeInBits(int size, boolean defaultvalue) {
        if (size < this.sizeinbits) {
            return false;
        }
        if (defaultvalue) {
            while (this.sizeinbits % 32 != 0 && this.sizeinbits < size) {
                this.set(this.sizeinbits);
            }
        }
        if (!defaultvalue) {
            EWAHCompressedBitmap32.extendEmptyBits(this, this.sizeinbits, size);
        } else {
            int leftover = size % 32;
            this.addStreamOfEmptyWords(defaultvalue, size / 32 - this.sizeinbits / 32);
            int newdata = (1 << leftover) + ((1 << leftover) - 1);
            this.addLiteralWord(newdata);
        }
        this.sizeinbits = size;
        return true;
    }

    private static void extendEmptyBits(BitmapStorage32 storage, int currentSize, int newSize) {
        int currentLeftover = currentSize % 32;
        int finalLeftover = newSize % 32;
        storage.addStreamOfEmptyWords(false, newSize / 32 - currentSize / 32 + (finalLeftover != 0 ? 1 : 0) + (currentLeftover != 0 ? -1 : 0));
    }

    public int sizeInBytes() {
        return this.actualsizeinwords * 4;
    }

    private boolean reserve(int size) {
        if (size > this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[size];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
            return true;
        }
        return false;
    }

    private void push_back(int data) {
        if (this.actualsizeinwords == this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        this.buffer[this.actualsizeinwords++] = data;
    }

    private void push_back(int[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        System.arraycopy(data, start, this.buffer, this.actualsizeinwords, number);
        this.actualsizeinwords += number;
    }

    private void negative_push_back(int[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        for (int k = 0; k < number; ++k) {
            this.buffer[this.actualsizeinwords + k] = ~data[start + k];
        }
        this.actualsizeinwords += number;
    }

    private int addEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        int runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 65535) {
            this.rlw.setRunningLength(runlen + 1);
            return 0;
        }
        this.push_back(0);
        this.rlw.position = this.actualsizeinwords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1);
        return 1;
    }

    private int addLiteralWord(int newdata) {
        int numbersofar = this.rlw.getNumberOfLiteralWords();
        if (numbersofar >= Short.MAX_VALUE) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            this.rlw.setNumberOfLiteralWords(1);
            this.push_back(newdata);
            return 2;
        }
        this.rlw.setNumberOfLiteralWords(numbersofar + 1);
        this.push_back(newdata);
        return 1;
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter += 32 * localrlw.getRunningLength();
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Integer.bitCount(i.buffer()[i.dirtyWords() + j]);
            }
        }
        return counter;
    }

    public String toString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
        }
        return ans;
    }

    public String toDebugString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int data = i.buffer()[i.dirtyWords() + j];
                ans = ans + "\t" + data + "\n";
            }
        }
        return ans;
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        ans[inanspos++] = pos++;
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int data = i.buffer()[i.dirtyWords() + j];
                while (data != 0) {
                    int ntz = Integer.numberOfTrailingZeros(data);
                    data = (int)((long)data ^ 1L << ntz);
                    ans[inanspos++] = ntz + pos;
                }
                pos += 32;
            }
        }
        return ans;
    }

    public IntIterator intIterator() {
        final EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        return new IntIterator(){
            int pos = 0;
            RunningLengthWord32 localrlw = null;
            static final int initcapacity = 512;
            int[] localbuffer = new int[512];
            int localbuffersize = 0;
            int bufferpos = 0;
            boolean status = this.queryStatus();

            public boolean hasNext() {
                return this.status;
            }

            public boolean queryStatus() {
                while (this.localbuffersize == 0) {
                    if (!this.loadNextRLE()) {
                        return false;
                    }
                    this.loadBuffer();
                }
                return true;
            }

            private boolean loadNextRLE() {
                if (i.hasNext()) {
                    this.localrlw = i.next();
                    return true;
                }
                return false;
            }

            private void add(int val) {
                ++this.localbuffersize;
                if (this.localbuffersize > this.localbuffer.length) {
                    int[] oldbuffer = this.localbuffer;
                    this.localbuffer = new int[this.localbuffer.length * 2];
                    System.arraycopy(oldbuffer, 0, this.localbuffer, 0, oldbuffer.length);
                }
                this.localbuffer[this.localbuffersize - 1] = val;
            }

            private void loadBuffer() {
                int j;
                this.bufferpos = 0;
                this.localbuffersize = 0;
                if (this.localrlw.getRunningBit()) {
                    for (j = 0; j < this.localrlw.getRunningLength(); ++j) {
                        for (int c = 0; c < 32; ++c) {
                            this.add(this.pos++);
                        }
                    }
                } else {
                    this.pos += 32 * this.localrlw.getRunningLength();
                }
                for (j = 0; j < this.localrlw.getNumberOfLiteralWords(); ++j) {
                    int data = i.buffer()[i.dirtyWords() + j];
                    while (data != 0) {
                        int ntz = Integer.numberOfTrailingZeros(data);
                        data = (int)((long)data ^ 1L << ntz);
                        this.add(ntz + this.pos);
                    }
                    this.pos += 32;
                }
            }

            public int next() {
                int answer = this.localbuffer[this.bufferpos++];
                if (this.localbuffersize == this.bufferpos) {
                    this.localbuffersize = 0;
                    this.status = this.queryStatus();
                }
                return answer;
            }
        };
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap32.this.intIterator();
            }

            @Override
            public Integer next() {
                return new Integer(this.under.next());
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    public List<Integer> getPositions() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator32 i = new EWAHIterator32(this.buffer, this.actualsizeinwords);
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        v.add(new Integer(pos++));
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (int data = i.buffer()[i.dirtyWords() + j]; data != 0; data ^= 1 << ntz) {
                    ntz = Integer.numberOfTrailingZeros(data);
                    v.add(new Integer(ntz + pos));
                }
                pos += 32;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeinbits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap32) {
            EWAHCompressedBitmap32 other = (EWAHCompressedBitmap32)o;
            if (this.sizeinbits == other.sizeinbits && this.actualsizeinwords == other.actualsizeinwords && this.rlw.position == other.rlw.position) {
                for (int k = 0; k < this.actualsizeinwords; ++k) {
                    if (this.buffer[k] == other.buffer[k]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            karprabin += 31 * karprabin + (this.buffer[k] & 0);
            karprabin += 31 * karprabin + (this.buffer[k] >>> 32);
        }
        return this.sizeinbits ^ karprabin;
    }

    public Object clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap32 clone = (EWAHCompressedBitmap32)super.clone();
        clone.buffer = (int[])this.buffer.clone();
        clone.actualsizeinwords = this.actualsizeinwords;
        clone.sizeinbits = this.sizeinbits;
        return clone;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeinbits = in.readInt();
        this.actualsizeinwords = in.readInt();
        if (this.buffer.length < this.actualsizeinwords) {
            this.buffer = new int[this.actualsizeinwords];
        }
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            this.buffer[k] = in.readInt();
        }
        this.rlw = new RunningLengthWord32(this.buffer, in.readInt());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeinbits);
        out.writeInt(this.actualsizeinwords);
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            out.writeInt(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public void clear() {
        this.sizeinbits = 0;
        this.actualsizeinwords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0;
    }
}

