/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.search;

import java.io.Serializable;

public class Sort
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String property;
    protected boolean desc = false;
    protected boolean ignoreCase = false;
    protected boolean customExpression = false;

    public Sort() {
    }

    public Sort(String property, boolean desc, boolean ignoreCase) {
        this.property = property;
        this.desc = desc;
        this.ignoreCase = ignoreCase;
    }

    public Sort(String property, boolean desc) {
        this.property = property;
        this.desc = desc;
    }

    public Sort(String property) {
        this.property = property;
    }

    public Sort(boolean isCustomExpression, String property, boolean desc) {
        this.customExpression = isCustomExpression;
        this.property = property;
        this.desc = desc;
    }

    public Sort(boolean isCustomExpression, String property) {
        this.customExpression = isCustomExpression;
        this.property = property;
    }

    public static Sort asc(String property) {
        return new Sort(property);
    }

    public static Sort asc(String property, boolean ignoreCase) {
        return new Sort(property, ignoreCase);
    }

    public static Sort desc(String property) {
        return new Sort(property, true);
    }

    public static Sort desc(String property, boolean ignoreCase) {
        return new Sort(property, true, ignoreCase);
    }

    public static Sort customExpressionAsc(String expression) {
        return new Sort(true, expression);
    }

    public static Sort customExpressionDesc(String expression) {
        return new Sort(true, expression, true);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isDesc() {
        return this.desc;
    }

    public void setDesc(boolean desc) {
        this.desc = desc;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isCustomExpression() {
        return this.customExpression;
    }

    public void setCustomExpression(boolean customExpression) {
        this.customExpression = customExpression;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customExpression ? 1231 : 1237);
        result = 31 * result + (this.desc ? 1231 : 1237);
        result = 31 * result + (this.ignoreCase ? 1231 : 1237);
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (this.customExpression != other.customExpression) {
            return false;
        }
        if (this.desc != other.desc) {
            return false;
        }
        if (this.ignoreCase != other.ignoreCase) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.customExpression) {
            sb.append("CUSTOM: ");
        }
        if (this.property == null) {
            sb.append("null");
        } else {
            sb.append("`");
            sb.append(this.property);
            sb.append("`");
        }
        sb.append(this.desc ? " desc" : " asc");
        if (this.ignoreCase && !this.customExpression) {
            sb.append(" (ignore case)");
        }
        return sb.toString();
    }
}

