/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.dao.jpa;

import com.googlecode.genericdao.search.ExampleOptions;
import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.MetadataUtil;
import com.googlecode.genericdao.search.SearchResult;
import com.googlecode.genericdao.search.jpa.JPASearchProcessor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

public class JPABaseDAO {
    private JPASearchProcessor searchProcessor;
    private EntityManager entityManager;

    public void setSearchProcessor(JPASearchProcessor searchProcessor) {
        this.searchProcessor = searchProcessor;
    }

    protected JPASearchProcessor getSearchProcessor() {
        return this.searchProcessor;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected EntityManager em() {
        return this.entityManager;
    }

    protected MetadataUtil getMetadataUtil() {
        return this.searchProcessor.getMetadataUtil();
    }

    protected void _persist(Object ... entities) {
        for (Object entity : entities) {
            if (entity == null) continue;
            this.em().persist(entity);
        }
    }

    protected boolean _removeById(Class<?> type, Serializable id) {
        Query query;
        if (id != null && (query = this.em().createQuery("select _it_.id from " + this.getMetadataUtil().get(type).getEntityName() + " _it_ where _it_.id = ?1").setParameter(1, (Object)id)).getResultList().size() != 0) {
            this.em().remove(this.em().getReference(type, (Object)id));
            return true;
        }
        return false;
    }

    protected void _removeByIds(Class<?> type, Serializable ... ids) {
        for (Serializable id : this.pullByIds("select _it_.id", type, ids)) {
            this.em().remove(this.em().getReference(type, (Object)id));
        }
    }

    protected boolean _removeEntity(Object entity) {
        if (entity != null) {
            if (this.em().contains(entity)) {
                this.em().remove(entity);
                return true;
            }
            Serializable id = this.getMetadataUtil().getId(entity);
            return this._removeById(entity.getClass(), id);
        }
        return false;
    }

    protected void _removeEntities(Object ... entities) {
        for (Object entity : entities) {
            this._removeEntity(entity);
        }
    }

    protected <T> T _find(Class<T> type, Serializable id) {
        return (T)this.em().find(type, (Object)id);
    }

    protected <T> T[] _find(Class<T> type, Serializable ... ids) {
        Object[] retList = (Object[])Array.newInstance(type, ids.length);
        for (Object entity : this.pullByIds("select _it_", type, ids)) {
            Serializable id = this.getMetadataUtil().getId(entity);
            for (int i = 0; i < ids.length; ++i) {
                if (!id.equals(ids[i])) continue;
                retList[i] = entity;
            }
        }
        return retList;
    }

    protected <T> T _getReference(Class<T> type, Serializable id) {
        return (T)this.em().getReference(type, (Object)id);
    }

    protected <T> T[] _getReferences(Class<T> type, Serializable ... ids) {
        Object[] retList = (Object[])Array.newInstance(type, ids.length);
        for (int i = 0; i < ids.length; ++i) {
            retList[i] = this._getReference(type, ids[i]);
        }
        return retList;
    }

    protected <T> List<T> _all(Class<T> type) {
        return this.em().createQuery("select _it_ from " + this.getMetadataUtil().get(type).getEntityName() + " _it_").getResultList();
    }

    protected <T> T _merge(T entity) {
        return (T)this.em().merge(entity);
    }

    protected <T> T[] _merge(Class<T> arrayType, T ... entities) {
        Object[] retList = (Object[])Array.newInstance(arrayType, entities.length);
        for (int i = 0; i < entities.length; ++i) {
            retList[i] = this._merge(entities[i]);
        }
        return retList;
    }

    protected <T> T _persistOrMerge(T entity) {
        if (entity == null) {
            return null;
        }
        if (this.em().contains(entity)) {
            return entity;
        }
        Serializable id = this.getMetadataUtil().getId(entity);
        if (!this.validId(id)) {
            this._persist(entity);
            return entity;
        }
        Object prev = this.em().find(entity.getClass(), (Object)id);
        if (prev == null) {
            this._persist(entity);
            return entity;
        }
        return this._merge(entity);
    }

    protected <T> T[] _persistOrMerge(Class<T> arrayType, T ... entities) {
        Object[] retList = (Object[])Array.newInstance(arrayType, entities.length);
        for (int i = 0; i < entities.length; ++i) {
            retList[i] = this._persistOrMerge(entities[i]);
        }
        return retList;
    }

    protected List _search(ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().search(this.em(), search);
    }

    protected List _search(Class<?> searchClass, ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().search(this.em(), searchClass, search);
    }

    protected int _count(ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().count(this.em(), search);
    }

    protected int _count(Class<?> searchClass, ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().count(this.em(), searchClass, search);
    }

    protected int _count(Class<?> type) {
        return ((Number)this.em().createQuery("select count(_it_) from " + this.getMetadataUtil().get(type).getEntityName() + " _it_").getSingleResult()).intValue();
    }

    protected SearchResult _searchAndCount(ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().searchAndCount(this.em(), search);
    }

    protected SearchResult _searchAndCount(Class<?> searchClass, ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().searchAndCount(this.em(), searchClass, search);
    }

    protected Object _searchUnique(ISearch search) throws NonUniqueResultException, NoResultException {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().searchUnique(this.em(), search);
    }

    protected Object _searchUnique(Class<?> searchClass, ISearch search) throws NonUniqueResultException, NoResultException {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().searchUnique(this.em(), searchClass, search);
    }

    protected boolean _contains(Object o) {
        return this.em().contains(o);
    }

    protected void _flush() {
        this.em().flush();
    }

    protected void _refresh(Object ... entities) {
        for (Object entity : entities) {
            if (entity == null) continue;
            this.em().refresh(entity);
        }
    }

    protected boolean _exists(Object entity) {
        if (entity == null) {
            return false;
        }
        if (this.em().contains(entity)) {
            return true;
        }
        return this._exists(entity.getClass(), this.getMetadataUtil().getId(entity));
    }

    protected boolean _exists(Class<?> type, Serializable id) {
        if (type == null) {
            throw new NullPointerException("Type is null.");
        }
        if (!this.validId(id)) {
            return false;
        }
        Query query = this.em().createQuery("select _it_.id from " + this.getMetadataUtil().get(type).getEntityName() + " _it_ where _it_.id = :id");
        query.setParameter("id", (Object)id);
        return query.getResultList().size() == 1;
    }

    protected boolean[] _exists(Class<?> type, Serializable ... ids) {
        if (type == null) {
            throw new NullPointerException("Type is null.");
        }
        boolean[] ret = new boolean[ids.length];
        for (Serializable id : this.pullByIds("select _it_.id", type, ids)) {
            for (int i = 0; i < ids.length; ++i) {
                if (!id.equals(ids[i])) continue;
                ret[i] = true;
            }
        }
        return ret;
    }

    protected Filter _getFilterFromExample(Object example) {
        return this.searchProcessor.getFilterFromExample(example);
    }

    protected Filter _getFilterFromExample(Object example, ExampleOptions options) {
        return this.searchProcessor.getFilterFromExample(example, options);
    }

    private List<?> pullByIds(String select, Class<?> type, Serializable[] ids) {
        LinkedList<Serializable> nonNulls = new LinkedList<Serializable>();
        StringBuilder sb = new StringBuilder(select);
        sb.append(" from ");
        sb.append(this.getMetadataUtil().get(type).getEntityName());
        sb.append(" _it_ where ");
        for (Serializable id : ids) {
            if (id == null) continue;
            if (nonNulls.size() == 0) {
                sb.append("_it_.id = ?1");
            } else {
                sb.append(" or _it_.id = ?").append(nonNulls.size() + 1);
            }
            nonNulls.add(id);
        }
        if (nonNulls.size() == 0) {
            return new ArrayList(0);
        }
        Query query = this.em().createQuery(sb.toString());
        int idx = 1;
        for (Serializable id : nonNulls) {
            query.setParameter(idx++, (Object)id);
        }
        return query.getResultList();
    }

    private boolean validId(Serializable id) {
        if (id == null) {
            return false;
        }
        if (id instanceof Number && ((Number)id).equals(0)) {
            return false;
        }
        return !(id instanceof String) || !"".equals(id);
    }
}

