/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.dao;

import com.googlecode.genericdao.dao.DAODispatcherException;
import com.googlecode.genericdao.dao.DAOUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDAODispatcher {
    protected Map<String, Object> specificDAOs;

    public void setSpecificDAOs(Map<String, Object> specificDAOs) {
        this.specificDAOs = specificDAOs;
    }

    protected Object getSpecificDAO(String className) {
        return this.specificDAOs == null ? null : this.specificDAOs.get(className);
    }

    protected Object callMethod(Object specificDAO, String methodName, Object ... args) {
        try {
            return DAOUtil.callMethod(specificDAO, methodName, args);
        }
        catch (IllegalArgumentException e) {
            throw new DAODispatcherException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DAODispatcherException(e);
        }
        catch (IllegalAccessException e) {
            throw new DAODispatcherException(e);
        }
        catch (InvocationTargetException e) {
            throw new DAODispatcherException(e);
        }
    }

    protected Object callMethod(Object specificDAO, String methodName, Class<?>[] paramTypes, Object ... args) {
        try {
            return DAOUtil.callMethod(specificDAO, methodName, paramTypes, args);
        }
        catch (IllegalArgumentException e) {
            throw new DAODispatcherException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DAODispatcherException(e);
        }
        catch (IllegalAccessException e) {
            throw new DAODispatcherException(e);
        }
        catch (InvocationTargetException e) {
            throw new DAODispatcherException(e);
        }
    }

    protected static Class<?> getTypeFromArray(Object[] array) {
        if (array == null) {
            return null;
        }
        if (!array.getClass().getComponentType().equals(Object.class)) {
            return array.getClass().getComponentType();
        }
        Class<?> klass = null;
        for (Object o : array) {
            if (o == null || klass != null && !o.getClass().isAssignableFrom(klass)) continue;
            klass = o.getClass();
        }
        return klass;
    }

    protected static Class<?> getUniformArrayType(Object[] array) {
        if (array == null) {
            return null;
        }
        Class<?> klass = null;
        for (Object o : array) {
            if (o == null) continue;
            if (klass == null) {
                klass = o.getClass();
                continue;
            }
            if (klass.equals(o.getClass())) continue;
            return Object.class;
        }
        return klass;
    }
}

