/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class CovarianceRandomDraw {
    private DenseMatrix64F A;
    private Random rand;
    private DenseMatrix64F r;

    public CovarianceRandomDraw(Random rand, DenseMatrix64F cov) {
        this.r = new DenseMatrix64F(cov.numRows, 1);
        CholeskyDecompositionInner choleky = new CholeskyDecompositionInner(true);
        choleky.decompose(cov);
        this.A = choleky.getT();
        this.rand = rand;
    }

    public void next(DenseMatrix64F x) {
        for (int i = 0; i < this.r.numRows; ++i) {
            this.r.set(i, 0, this.rand.nextGaussian());
        }
        CommonOps.multAdd(this.A, this.r, x);
    }

    public double computeLikelihoodP() {
        double ret = 1.0;
        for (int i = 0; i < this.r.numRows; ++i) {
            double a = this.r.get(i, 0);
            ret *= Math.exp(-a * a / 2.0);
        }
        return ret;
    }
}

