/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.gj;

import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.alg.dense.linsol.gj.GaussJordan;
import org.ejml.data.DenseMatrix64F;

public class GaussJordanNoPivot
extends LinearSolverAbstract {
    @Override
    public boolean setA(DenseMatrix64F A) {
        this._setA(A);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    @Override
    public void invert(DenseMatrix64F A) {
        GaussJordan.checkArgumentSquare(A, "A");
        if (A != this.A) {
            A.set(this.A);
        }
        int dimen = A.numCols;
        for (int i = 0; i < dimen; ++i) {
            double valA = A.get(i, i);
            if (valA == 0.0) {
                throw new IllegalArgumentException("This algorithm only works if all the diagonal elements are not zero");
            }
            A.set(i * dimen + i, 1.0);
            for (int x = 0; x < dimen; ++x) {
                A.div(i * dimen + x, valA);
            }
            for (int j = 0; j < dimen; ++j) {
                if (i == j) continue;
                double val = A.get(j, i);
                A.set(j * dimen + i, 0.0);
                for (int x = 0; x < dimen; ++x) {
                    A.minus(j * dimen + x, val * A.get(i * dimen + x));
                }
            }
        }
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        GaussJordan.checkArgumentSquare(this.A, "A");
        if (this.A.getNumCols() != B.getNumRows()) {
            throw new IllegalArgumentException("Dimensions of A and B are not compatible.");
        }
        X.set(B);
        int dimen = this.A.numCols;
        for (int i = 0; i < dimen; ++i) {
            int x;
            double valA = this.A.get(i, i);
            if (valA == 0.0) {
                throw new IllegalArgumentException("This algorithm only works if all the diagonal elements are not zero");
            }
            this.A.set(i * dimen + i, 1.0);
            for (x = 0; x < dimen; ++x) {
                this.A.div(i * dimen + x, valA);
            }
            for (x = 0; x < B.numCols; ++x) {
                X.div(i * X.numCols + x, valA);
            }
            for (int j = 0; j < dimen; ++j) {
                int x2;
                if (i == j) continue;
                double val = this.A.get(j, i);
                this.A.set(j * dimen + i, 0.0);
                for (x2 = 0; x2 < dimen; ++x2) {
                    this.A.minus(j * dimen + x2, val * this.A.unsafe_get(i, x2));
                }
                for (x2 = 0; x2 < X.numCols; ++x2) {
                    X.minus(j * X.numCols + x2, val * X.get(i * X.numCols + x2));
                }
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

