/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.blaisemath.graph.view;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.googlecode.blaisemath.graph.layout.GraphLayoutManager;
import com.googlecode.blaisemath.graph.view.VisualGraph;
import com.googlecode.blaisemath.graphics.DelegatingPrimitiveGraphic;
import com.googlecode.blaisemath.graphics.Graphic;
import com.googlecode.blaisemath.graphics.impl.DelegatingNodeLinkGraphic;
import com.googlecode.blaisemath.graphics.swing.JGraphicComponent;
import com.googlecode.blaisemath.graphics.swing.JGraphics;
import com.googlecode.blaisemath.graphics.swing.PanAndZoomHandler;
import com.googlecode.blaisemath.style.ObjectStyler;
import com.googlecode.blaisemath.util.swing.ContextMenuInitializer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GraphComponent
extends JGraphicComponent {
    private static final Logger LOG = Logger.getLogger(GraphComponent.class.getName());
    public static final String MENU_KEY_GRAPH = "graph";
    public static final String MENU_KEY_EDGE = "edge";
    public static final String MENU_KEY_NODE = "node";
    private static final Supplier<DelegatingNodeLinkGraphic<Object, EndpointPair<Object>, Graphics2D>> SWING_GRAPH_SUPPLIER = () -> {
        DelegatingNodeLinkGraphic res = JGraphics.nodeLink();
        res.getNodeStyler().setStyle(VisualGraph.DEFAULT_NODE_STYLE);
        return res;
    };
    protected final VisualGraph<Graphics2D> adapter;

    public GraphComponent() {
        this(new GraphLayoutManager());
    }

    public GraphComponent(Graph graph) {
        this(GraphLayoutManager.create((Graph)graph));
    }

    public GraphComponent(GraphLayoutManager gm) {
        this.adapter = new VisualGraph(gm, SWING_GRAPH_SUPPLIER);
        this.addGraphic((Graphic)this.adapter.getViewGraph());
        this.setPreferredSize(new Dimension(400, 400));
        this.setSelectionEnabled(true);
        PanAndZoomHandler.install((JGraphicComponent)this);
        this.addHierarchyListener(e -> {
            if (e.getChangeFlags() == 1L) {
                this.setLayoutTaskActive(false);
            }
        });
    }

    public VisualGraph getAdapter() {
        return this.adapter;
    }

    public ObjectStyler<EndpointPair<Object>> getEdgeStyler() {
        return this.adapter.getEdgeStyler();
    }

    public void setEdgeStyler(ObjectStyler<EndpointPair<Object>> edgeStyler) {
        this.adapter.setEdgeStyler(edgeStyler);
    }

    public ObjectStyler<Object> getNodeStyler() {
        return this.adapter.getNodeStyler();
    }

    public void setNodeStyler(ObjectStyler<Object> nodeStyler) {
        this.adapter.setNodeStyler(nodeStyler);
    }

    public GraphLayoutManager getLayoutManager() {
        return this.adapter.getLayoutManager();
    }

    public void setLayoutManager(GraphLayoutManager gm) {
        this.adapter.setLayoutManager(gm);
    }

    public Graph getGraph() {
        return this.adapter.getGraph();
    }

    public void setGraph(Graph graph) {
        this.adapter.setGraph(graph);
    }

    public boolean isLayoutTaskActive() {
        return this.getLayoutManager().isLayoutTaskActive();
    }

    public void setLayoutTaskActive(boolean val) {
        this.getLayoutManager().setLayoutTaskActive(val);
    }

    public Predicate<Object> getNodeLabelFilter() {
        return this.getNodeStyler().getLabelFilter();
    }

    public void setNodeLabelFilter(Predicate<Object> nodeLabelFilter) {
        Predicate old = this.getNodeStyler().getLabelFilter();
        if (old != nodeLabelFilter) {
            this.getNodeStyler().setLabelFilter(nodeLabelFilter);
            this.repaint();
        }
    }

    public Function<?, String> getNodeLabelDelegate() {
        return this.adapter.getNodeStyler().getLabelDelegate();
    }

    public void setNodeLabelDelegate(Function<Object, String> labeler) {
        Function old = this.getNodeStyler().getLabelDelegate();
        if (old != labeler) {
            this.getNodeStyler().setLabelDelegate(labeler);
            this.repaint();
        }
    }

    public Set getSelectedNodes() {
        return this.getSelectionModel().getSelection().stream().filter(s -> s instanceof DelegatingPrimitiveGraphic).map(s -> ((DelegatingPrimitiveGraphic)s).getSourceObject()).collect(Collectors.toSet());
    }

    public void setSelectedNodes(Collection nodes) {
        Set newSelection = this.adapter.getViewGraph().getPointGraphic().getGraphics().stream().filter(g -> nodes.contains(((DelegatingPrimitiveGraphic)g).getSourceObject())).collect(Collectors.toSet());
        this.selector.getSelectionModel().setSelection(newSelection);
    }

    public void addContextMenuInitializer(String key, ContextMenuInitializer init) {
        DelegatingNodeLinkGraphic win = this.adapter.getViewGraph();
        if (MENU_KEY_GRAPH.equalsIgnoreCase(key)) {
            this.getGraphicRoot().addContextMenuInitializer(init);
        } else if (MENU_KEY_NODE.equalsIgnoreCase(key)) {
            win.getPointGraphic().addContextMenuInitializer(init);
        } else if (MENU_KEY_EDGE.equalsIgnoreCase(key)) {
            win.getEdgeGraphic().addContextMenuInitializer(init);
        } else {
            LOG.log(Level.WARNING, "Unsupported context menu key: {0}", key);
        }
    }

    public void removeContextMenuInitializer(String key, ContextMenuInitializer init) {
        DelegatingNodeLinkGraphic win = this.adapter.getViewGraph();
        if (MENU_KEY_GRAPH.equals(key)) {
            this.getGraphicRoot().removeContextMenuInitializer(init);
        } else if (MENU_KEY_NODE.equals(key)) {
            win.getPointGraphic().removeContextMenuInitializer(init);
        } else if (MENU_KEY_EDGE.equals(key)) {
            win.getEdgeGraphic().removeContextMenuInitializer(init);
        } else {
            LOG.log(Level.WARNING, "Unsupported context menu key: {0}", key);
        }
    }
}

