/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.blaisemath.graph.view;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.google.common.graph.EndpointPair;
import com.googlecode.blaisemath.style.AttributeSet;
import java.awt.Color;
import java.util.Map;

public class WeightedEdgeStyler<E extends EndpointPair>
implements Function<E, AttributeSet> {
    private static final float HUE_RANGE = 0.1f;
    protected final AttributeSet parent;
    protected Map<E, Double> weights;
    protected double maxWeight;

    public WeightedEdgeStyler(AttributeSet parent, Map<E, Double> weights) {
        this.parent = parent;
        this.weights = weights;
        this.maxWeight = weights.isEmpty() ? 1.0 : (Double)Ordering.natural().max(weights.values());
    }

    public Map<E, Double> getWeights() {
        return this.weights;
    }

    public void setWeights(Map<E, Double> weights) {
        if (this.weights != weights) {
            this.weights = weights;
            this.maxWeight = weights.isEmpty() ? 1.0 : (Double)Ordering.natural().max(weights.values());
        }
    }

    public AttributeSet apply(E o) {
        Double wt = this.weights.get(o);
        this.maxWeight = Math.max(this.maxWeight, Math.abs(wt));
        boolean positive = wt >= 0.0;
        double relativeWeight = Math.abs(wt) / this.maxWeight;
        Color stroke = this.parent.getColor("stroke");
        Color c = positive ? WeightedEdgeStyler.positiveColor(stroke, relativeWeight) : WeightedEdgeStyler.negativeColor(stroke, relativeWeight);
        return AttributeSet.withParent((AttributeSet)this.parent).and("stroke", (Object)c).and("stroke-width", (Object)Float.valueOf((float)(2.0 * relativeWeight)));
    }

    private static Color positiveColor(Color c, double weight) {
        double wt = Math.min(1.0, Math.max(0.0, weight));
        int alpha = 100 + (int)(155.0 * wt);
        if (c == null) {
            return new Color(25 - (int)(25.0 * wt), 205 + (int)(50.0 * wt), 100 - (int)(50.0 * wt), alpha);
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[0] = (float)((double)hsb[0] + (double)0.1f * wt);
        hsb[1] = (float)((double)hsb[1] * (0.5 + 0.5 * wt));
        return WeightedEdgeStyler.hsbColor(hsb, alpha);
    }

    private static Color negativeColor(Color c, double weight) {
        double wt = Math.min(1.0, Math.max(0.0, weight));
        int alpha = 100 + (int)(155.0 * wt);
        if (c == null) {
            return new Color(205 + (int)(50.0 * wt), 0, 100 - (int)(50.0 * wt), alpha);
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[0] = (float)((double)hsb[0] - (double)0.2f * wt);
        hsb[1] = (float)((double)hsb[1] * (0.5 + 0.5 * wt));
        return WeightedEdgeStyler.hsbColor(hsb, alpha);
    }

    private static Color hsbColor(float[] hsb, int alpha) {
        Color col = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        return new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha);
    }
}

