/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeUtils {
    static final Map<Class<?>, Class<?>> AUTOBOX_MAP;
    static final Map<Class<?>, Object> DEFAULT_PRIMITIVE_VALUES;
    static final Set<Class<?>> VALUE_TYPES;

    public static Class<?> ensureBaseType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(TypeUtils.ensureBaseType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.ensureBaseType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.ensureBaseType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            WildcardType wild = (WildcardType)type;
            return TypeUtils.ensureBaseType(wild.getUpperBounds()[0]);
        }
        throw new RuntimeException("Cannot handle " + type.getClass().getName());
    }

    public static Object getDefaultPrimitiveValue(Class<?> clazz) {
        assert (clazz.isPrimitive()) : "Expecting primitive type";
        return DEFAULT_PRIMITIVE_VALUES.get(clazz);
    }

    public static Type[] getParameterization(Class<?> intf, Type ... types) {
        for (Type type : types) {
            if (type == null) continue;
            if (type instanceof ParameterizedType) {
                ParameterizedType param = (ParameterizedType)type;
                Type[] actualTypeArguments = param.getActualTypeArguments();
                Class<?> base = TypeUtils.ensureBaseType(param.getRawType());
                TypeVariable<Class<?>>[] typeParameters = base.getTypeParameters();
                HashMap map = new HashMap();
                int j = typeParameters.length;
                for (int i = 0; i < j; ++i) {
                    map.put(typeParameters[i], actualTypeArguments[i]);
                }
                TypeVariable<Class<?>>[] lookFor = intf.equals(base) ? intf.getTypeParameters() : TypeUtils.getParameterization(intf, base.getGenericInterfaces());
                ArrayList<Type> toReturn = new ArrayList<Type>();
                int j2 = lookFor.length;
                for (int i = 0; i < j2; ++i) {
                    Type found = (Type)map.get(lookFor[i]);
                    if (found == null) continue;
                    toReturn.add(found);
                }
                return toReturn.toArray(new Type[toReturn.size()]);
            }
            if (!(type instanceof Class)) continue;
            Class clazz = (Class)type;
            if (intf.equals(clazz)) {
                return intf.getTypeParameters();
            }
            Type[] found = TypeUtils.getParameterization(intf, clazz.getGenericSuperclass());
            if (found != null) {
                return found;
            }
            found = TypeUtils.getParameterization(intf, clazz.getGenericInterfaces());
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static Type getSingleParameterization(Class<?> intf, Type ... types) {
        Type[] found = TypeUtils.getParameterization(intf, types);
        return found == null ? null : found[0];
    }

    public static boolean isValueType(Class<?> clazz) {
        if (clazz.isPrimitive() || VALUE_TYPES.contains(clazz)) {
            return true;
        }
        for (Class<?> c : VALUE_TYPES) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static <V> Class<V> maybeAutobox(Class<V> domainType) {
        Class<?> autoBoxType = AUTOBOX_MAP.get(domainType);
        return autoBoxType == null ? domainType : autoBoxType;
    }

    private TypeUtils() {
    }

    static {
        VALUE_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Class.class, Date.class, Enum.class, Number.class, String.class, Void.class)));
        HashMap<Class<Object>, Comparable<Boolean>> temp = new HashMap<Class<Object>, Comparable<Boolean>>();
        temp.put(Boolean.TYPE, Boolean.valueOf(false));
        temp.put(Byte.TYPE, Byte.valueOf((byte)0));
        temp.put(Character.TYPE, Character.valueOf('\u0000'));
        temp.put(Double.TYPE, Double.valueOf(0.0));
        temp.put(Float.TYPE, Float.valueOf(0.0f));
        temp.put(Integer.TYPE, Integer.valueOf(0));
        temp.put(Long.TYPE, Long.valueOf(0L));
        temp.put(Short.TYPE, Short.valueOf((short)0));
        temp.put(Void.TYPE, null);
        DEFAULT_PRIMITIVE_VALUES = Collections.unmodifiableMap(temp);
        HashMap<Class<Object>, Class<Void>> autoBoxMap = new HashMap<Class<Object>, Class<Void>>();
        autoBoxMap.put(Boolean.TYPE, Boolean.class);
        autoBoxMap.put(Byte.TYPE, Byte.class);
        autoBoxMap.put(Character.TYPE, Character.class);
        autoBoxMap.put(Double.TYPE, Double.class);
        autoBoxMap.put(Float.TYPE, Float.class);
        autoBoxMap.put(Integer.TYPE, Integer.class);
        autoBoxMap.put(Long.TYPE, Long.class);
        autoBoxMap.put(Short.TYPE, Short.class);
        autoBoxMap.put(Void.TYPE, Void.class);
        AUTOBOX_MAP = Collections.unmodifiableMap(autoBoxMap);
    }
}

