/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;

public class StackTraceCreator {
    public static final int LINE_NUMBER_UNKNOWN = -1;
    private static final String ANONYMOUS = "anonymous";

    private static int parseInt(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void createStackTrace(JavaScriptException e) {
        if (!GWT.isScript()) {
            throw new RuntimeException("StackTraceCreator should only be called in Production Mode");
        }
        ((Collector)GWT.create(Collector.class)).createStackTrace(e);
    }

    public static void fillInStackTrace(Throwable t) {
        if (!GWT.isScript()) {
            throw new RuntimeException("StackTraceCreator should only be called in Production Mode");
        }
        ((Collector)GWT.create(Collector.class)).fillInStackTrace(t);
    }

    public static String getProperties(JavaScriptObject e) {
        if (!GWT.isScript()) {
            throw new RuntimeException("StackTraceCreator should only be called in Production Mode");
        }
        return ((Collector)GWT.create(Collector.class)).getProperties(e);
    }

    static JsArrayString createStackTrace() {
        if (!GWT.isScript()) {
            throw new RuntimeException("StackTraceCreator should only be called in Production Mode");
        }
        return ((Collector)GWT.create(Collector.class)).collect();
    }

    static String extractNameFromToString(String fnToString) {
        int start;
        String toReturn = "";
        fnToString = fnToString.trim();
        int index = fnToString.indexOf("(");
        int n = start = fnToString.startsWith("function") ? 8 : 0;
        if (index == -1) {
            index = fnToString.indexOf(64);
            int n2 = start = fnToString.startsWith("function ") ? 9 : 0;
        }
        if (index != -1) {
            toReturn = fnToString.substring(start, index).trim();
        }
        return toReturn.length() > 0 ? toReturn : ANONYMOUS;
    }

    private static JsArrayString splice(JsArrayString jsArrayString, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    static class CollectorNull
    extends Collector {
        CollectorNull() {
        }

        @Override
        public JsArrayString collect() {
            return (JsArrayString)JsArrayString.createArray().cast();
        }

        @Override
        public void createStackTrace(JavaScriptException e) {
        }

        @Override
        public void fillInStackTrace(Throwable t) {
        }
    }

    static class CollectorOpera
    extends CollectorMoz {
        CollectorOpera() {
        }

        @Override
        protected String extractName(String fnToString) {
            return fnToString.length() == 0 ? StackTraceCreator.ANONYMOUS : fnToString;
        }

        @Override
        protected JsArrayString getStack(JavaScriptObject e) {
            JsArrayString toReturn = this.getMessage(e);
            assert (toReturn.length() % 2 == 0) : "Expecting an even number of lines";
            int i = 0;
            int j = toReturn.length();
            for (int i2 = 0; i2 < j; i2 += 2) {
                int idx = toReturn.get(i2).lastIndexOf("function ");
                if (idx == -1) {
                    toReturn.set(i, "");
                } else {
                    toReturn.set(i, toReturn.get(i2).substring(idx + 9).trim());
                }
                ++i;
            }
            this.setLength(toReturn, i);
            return toReturn;
        }

        @Override
        protected int toSplice() {
            return 3;
        }

        private JsArrayString getMessage(JavaScriptObject javaScriptObject) {
            throw new RuntimeException("Cannot call native method");
        }

        private void setLength(JsArrayString jsArrayString, int n) {
            throw new RuntimeException("Cannot call native method");
        }
    }

    static class CollectorChromeNoSourceMap
    extends CollectorChrome {
        CollectorChromeNoSourceMap() {
        }

        @Override
        protected int replaceIfNoSourceMap(int line) {
            return -1;
        }
    }

    static class CollectorChrome
    extends CollectorMoz {
        CollectorChrome() {
        }

        private static void increaseChromeStackTraceLimit() {
            throw new RuntimeException("Cannot call native method");
        }

        @Override
        public JsArrayString collect() {
            JsArrayString res = super.collect();
            if (res.length() == 0) {
                res = StackTraceCreator.splice(new Collector().collect(), 1);
            }
            return res;
        }

        @Override
        public void createStackTrace(JavaScriptException e) {
            JsArrayString stack = this.inferFrom(e.getThrown());
            this.parseStackTrace(e, stack);
        }

        @Override
        public void fillInStackTrace(Throwable t) {
            JsArrayString stack = StackTraceCreator.createStackTrace();
            this.parseStackTrace(t, stack);
        }

        @Override
        public JsArrayString inferFrom(Object e) {
            JsArrayString stack = super.inferFrom(e);
            if (stack.length() == 0) {
                return new Collector().inferFrom(e);
            }
            if (stack.get(0).startsWith("anonymous@@")) {
                stack = StackTraceCreator.splice(stack, 1);
            }
            return stack;
        }

        @Override
        protected String extractName(String fnToString) {
            int index;
            String extractedName = StackTraceCreator.ANONYMOUS;
            String location = "";
            if (fnToString.length() == 0) {
                return extractedName;
            }
            String toReturn = fnToString.trim();
            if (toReturn.startsWith("at ")) {
                toReturn = toReturn.substring(3);
            }
            if ((index = toReturn.indexOf("[")) != -1) {
                toReturn = toReturn.substring(0, index).trim() + toReturn.substring(toReturn.indexOf("]", index) + 1).trim();
            }
            if ((index = toReturn.indexOf("(")) == -1) {
                index = toReturn.indexOf("@");
                if (index == -1) {
                    location = toReturn;
                    toReturn = "";
                } else {
                    location = toReturn.substring(index + 1).trim();
                    toReturn = toReturn.substring(0, index).trim();
                }
            } else {
                int closeParen = toReturn.indexOf(")", index);
                location = toReturn.substring(index + 1, closeParen);
                toReturn = toReturn.substring(0, index).trim();
            }
            index = toReturn.indexOf(46);
            if (index != -1) {
                toReturn = toReturn.substring(index + 1);
            }
            return (toReturn.length() > 0 ? toReturn : StackTraceCreator.ANONYMOUS) + "@@" + location;
        }

        protected int replaceIfNoSourceMap(int line) {
            return line;
        }

        @Override
        protected int toSplice() {
            return 3;
        }

        private void parseStackTrace(Throwable e, JsArrayString stack) {
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            int j = stackTrace.length;
            for (int i = 0; i < j; ++i) {
                String[] stackElements = stack.get(i).split("@@");
                int line = -1;
                int col = -1;
                String fileName = "Unknown";
                if (stackElements.length == 2 && stackElements[1] != null) {
                    String location = stackElements[1];
                    int lastColon = location.lastIndexOf(58);
                    int endFileUrl = location.lastIndexOf(58, lastColon - 1);
                    fileName = location.substring(0, endFileUrl);
                    if (lastColon != -1 && endFileUrl != -1) {
                        line = StackTraceCreator.parseInt(location.substring(endFileUrl + 1, lastColon));
                        col = StackTraceCreator.parseInt(location.substring(lastColon + 1));
                    }
                }
                stackTrace[i] = new StackTraceElement("Unknown", stackElements[0], fileName + "@" + col, this.replaceIfNoSourceMap(line < 0 ? -1 : line));
            }
            e.setStackTrace(stackTrace);
        }

        static {
            CollectorChrome.increaseChromeStackTraceLimit();
        }
    }

    static class CollectorMoz
    extends Collector {
        CollectorMoz() {
        }

        @Override
        public JsArrayString collect() {
            return StackTraceCreator.splice(this.inferFrom(this.makeException()), this.toSplice());
        }

        @Override
        public JsArrayString inferFrom(Object e) {
            JavaScriptObject jso = e instanceof JavaScriptObject ? (JavaScriptObject)e : null;
            JsArrayString stack = this.getStack(jso);
            int j = stack.length();
            for (int i = 0; i < j; ++i) {
                stack.set(i, this.extractName(stack.get(i)));
            }
            return stack;
        }

        protected JsArrayString getStack(JavaScriptObject javaScriptObject) {
            throw new RuntimeException("Cannot call native method");
        }

        protected int toSplice() {
            return 2;
        }
    }

    static class CollectorEmulated
    extends Collector {
        CollectorEmulated() {
        }

        @Override
        public JsArrayString collect() {
            JsArrayString toReturn = (JsArrayString)JsArrayString.createArray().cast();
            JsArray<JavaScriptObject> stack = this.getStack();
            int j = this.getStackDepth();
            for (int i = 0; i < j; ++i) {
                String name = stack.get(i) == null ? StackTraceCreator.ANONYMOUS : this.extractName(stack.get(i).toString());
                toReturn.set(j - i - 1, name);
            }
            return toReturn;
        }

        @Override
        public void createStackTrace(JavaScriptException e) {
        }

        @Override
        public void fillInStackTrace(Throwable t) {
            JsArrayString stack = this.collect();
            JsArrayString locations = this.getLocation();
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            int j = stackTrace.length;
            for (int i = 0; i < j; ++i) {
                String location = locations.get(j - i - 1);
                String fileName = null;
                int lineNumber = -1;
                if (location != null) {
                    int idx = location.indexOf(58);
                    if (idx != -1) {
                        fileName = location.substring(0, idx);
                        lineNumber = Integer.parseInt(location.substring(idx + 1));
                    } else {
                        lineNumber = Integer.parseInt(location);
                    }
                }
                stackTrace[i] = new StackTraceElement("Unknown", stack.get(i), fileName, lineNumber);
            }
            t.setStackTrace(stackTrace);
        }

        @Override
        public String getProperties(JavaScriptObject e) {
            return "";
        }

        @Override
        public JsArrayString inferFrom(Object e) {
            throw new RuntimeException("Should not reach here");
        }

        private JsArrayString getLocation() {
            throw new RuntimeException("Cannot call native method");
        }

        private JsArray<JavaScriptObject> getStack() {
            throw new RuntimeException("Cannot call native method");
        }

        private int getStackDepth() {
            throw new RuntimeException("Cannot call native method");
        }
    }

    static class Collector {
        Collector() {
        }

        public JsArrayString collect() {
            throw new RuntimeException("Cannot call native method");
        }

        public void createStackTrace(JavaScriptException e) {
            JsArrayString stack = this.inferFrom(e.getThrown());
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            int j = stackTrace.length;
            for (int i = 0; i < j; ++i) {
                stackTrace[i] = new StackTraceElement("Unknown", stack.get(i), null, -1);
            }
            e.setStackTrace(stackTrace);
        }

        public void fillInStackTrace(Throwable t) {
            JsArrayString stack = StackTraceCreator.createStackTrace();
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            int j = stackTrace.length;
            for (int i = 0; i < j; ++i) {
                stackTrace[i] = new StackTraceElement("Unknown", stack.get(i), null, -1);
            }
            t.setStackTrace(stackTrace);
        }

        public String getProperties(JavaScriptObject javaScriptObject) {
            throw new RuntimeException("Cannot call native method");
        }

        public JsArrayString inferFrom(Object e) {
            return (JsArrayString)JavaScriptObject.createArray().cast();
        }

        protected String extractName(String fnToString) {
            return StackTraceCreator.extractNameFromToString(fnToString);
        }

        protected JavaScriptObject makeException() {
            throw new RuntimeException("Cannot call native method");
        }
    }
}

