/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

public class SensorReadingStats {
    private static final String TAG = SensorReadingStats.class.getSimpleName();
    private int sampleBufSize;
    private int numAxes;
    private float[][] sampleBuf;
    private int writePos;
    private int samplesAdded;

    public SensorReadingStats(int n2, int n3) {
        this.sampleBufSize = n2;
        this.numAxes = n3;
        if (n2 <= 0) {
            throw new IllegalArgumentException("sampleBufSize is invalid.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("numAxes is invalid.");
        }
        this.sampleBuf = new float[n2][n3];
    }

    public void addSample(float[] fArray) {
        if (fArray.length < this.numAxes) {
            throw new IllegalArgumentException("values.length is less than # of axes.");
        }
        this.writePos = (this.writePos + 1) % this.sampleBufSize;
        for (int i2 = 0; i2 < this.numAxes; ++i2) {
            this.sampleBuf[this.writePos][i2] = fArray[i2];
        }
        ++this.samplesAdded;
    }

    public void reset() {
        this.samplesAdded = 0;
        this.writePos = 0;
    }

    public boolean statsAvailable() {
        return this.samplesAdded >= this.sampleBufSize;
    }

    public float getAverage(int n2) {
        if (!this.statsAvailable()) {
            throw new IllegalStateException("Average not available. Not enough samples.");
        }
        if (n2 < 0 || n2 >= this.numAxes) {
            int n3 = this.numAxes - 1;
            throw new IllegalStateException(new StringBuilder(38).append("axis must be between 0 and ").append(n3).toString());
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.sampleBufSize; ++i2) {
            f2 += this.sampleBuf[i2][n2];
        }
        return f2 / (float)this.sampleBufSize;
    }

    public float getMaxAbsoluteDeviation(int n2) {
        if (n2 < 0 || n2 >= this.numAxes) {
            int n3 = this.numAxes - 1;
            throw new IllegalStateException(new StringBuilder(38).append("axis must be between 0 and ").append(n3).toString());
        }
        float f2 = this.getAverage(n2);
        float f3 = 0.0f;
        for (int i2 = 0; i2 < this.sampleBufSize; ++i2) {
            f3 = Math.max(Math.abs(this.sampleBuf[i2][n2] - f2), f3);
        }
        return f3;
    }

    public float getMaxAbsoluteDeviation() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.numAxes; ++i2) {
            f2 = Math.max(f2, this.getMaxAbsoluteDeviation(i2));
        }
        return f2;
    }
}

