/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.vr.vrcore.controller.api.ControllerBatteryEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerPositionEvent;
import com.google.vr.vrcore.controller.api.ControllerTrackingStatusEvent;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;

public final class ControllerEventPacket2
extends ControllerEventPacket {
    private static ArrayDeque<ControllerEventPacket2> pool = new ArrayDeque();
    private static Object poolLock = new Object();
    private int positionEventCount;
    private ControllerPositionEvent[] positionEvents = new ControllerPositionEvent[16];
    private boolean hasBatteryEvent;
    private ControllerBatteryEvent batteryEvent = new ControllerBatteryEvent();
    private long timestampMillis;
    private int trackingStatusEventCount;
    private final ControllerTrackingStatusEvent[] trackingStatusEvents = new ControllerTrackingStatusEvent[16];
    public static final Parcelable.Creator<ControllerEventPacket2> CREATOR = new Parcelable.Creator<ControllerEventPacket2>(){

        public ControllerEventPacket2 createFromParcel(Parcel parcel) {
            ControllerEventPacket2 controllerEventPacket2 = ControllerEventPacket2.obtain();
            controllerEventPacket2.readFromParcel(parcel);
            return controllerEventPacket2;
        }

        public ControllerEventPacket2[] newArray(int n2) {
            return new ControllerEventPacket2[n2];
        }
    };

    public ControllerEventPacket2() {
        for (int i2 = 0; i2 < 16; ++i2) {
            this.positionEvents[i2] = new ControllerPositionEvent();
            this.trackingStatusEvents[i2] = new ControllerTrackingStatusEvent();
        }
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.positionEventCount = 0;
        this.trackingStatusEventCount = 0;
        this.hasBatteryEvent = false;
        this.timestampMillis = 0L;
    }

    @Override
    public final void setEventsControllerIndex(int n2) {
        super.setEventsControllerIndex(n2);
        ControllerEventPacket2.setControllerIndex(n2, this.positionEventCount, this.positionEvents);
        this.batteryEvent.controllerId = n2;
        ControllerEventPacket2.setControllerIndex(n2, this.trackingStatusEventCount, this.trackingStatusEvents);
    }

    public final long getTimestampMillis() {
        return this.timestampMillis;
    }

    public final int getPositionEventCount() {
        return this.positionEventCount;
    }

    public final int getTrackingStatusEventCount() {
        return this.trackingStatusEventCount;
    }

    public final boolean hasBatteryEvent() {
        return this.hasBatteryEvent;
    }

    public final ControllerPositionEvent getPositionEvent(int n2) {
        if (n2 < 0 || n2 >= this.positionEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.positionEvents[n2];
    }

    public final ControllerTrackingStatusEvent getTrackingStatusEvent(int n2) {
        if (n2 < 0 || n2 >= this.trackingStatusEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.trackingStatusEvents[n2];
    }

    public final ControllerBatteryEvent getBatteryEvent() {
        if (!this.hasBatteryEvent) {
            throw new IllegalStateException("ControllerEventPacket doesn't have a battery event.");
        }
        return this.batteryEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerEventPacket2 obtain() {
        Object object = poolLock;
        synchronized (object) {
            return pool.isEmpty() ? new ControllerEventPacket2() : pool.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recycle() {
        this.clear();
        Object object = poolLock;
        synchronized (object) {
            if (!pool.contains(this)) {
                pool.add(this);
            }
            return;
        }
    }

    @Override
    public final int describeContents() {
        return 0;
    }

    @Override
    protected final int calculateParcelByteLength() {
        int n2;
        int n3 = super.calculateParcelByteLength();
        n3 += 4;
        n3 += 4;
        for (n2 = 0; n2 < this.positionEventCount; ++n2) {
            n3 += this.positionEvents[n2].getByteSize();
        }
        n3 += 4;
        if (this.hasBatteryEvent) {
            n3 += this.batteryEvent.getByteSize();
        }
        n3 += 8;
        n3 += 4;
        for (n2 = 0; n2 < this.trackingStatusEventCount; ++n2) {
            n3 += this.trackingStatusEvents[n2].getByteSize();
        }
        return n3;
    }

    @Override
    public final void writeToParcel(Parcel parcel, int n2) {
        int n3;
        int n4 = parcel.dataPosition();
        int n5 = this.calculateParcelByteLength();
        parcel.writeInt(n5);
        super.writeToParcel(parcel, n2);
        parcel.writeInt(this.positionEventCount);
        for (n3 = 0; n3 < this.positionEventCount; ++n3) {
            this.positionEvents[n3].writeToParcel(parcel, n2);
        }
        parcel.writeInt(this.hasBatteryEvent ? 1 : 0);
        if (this.hasBatteryEvent) {
            this.batteryEvent.writeToParcel(parcel, n2);
        }
        parcel.writeLong(this.timestampMillis);
        parcel.writeInt(this.trackingStatusEventCount);
        for (n3 = 0; n3 < this.trackingStatusEventCount; ++n3) {
            this.trackingStatusEvents[n3].writeToParcel(parcel, n2);
        }
        if (parcel.dataPosition() - n4 != n5) {
            throw new IllegalStateException("Parcelable implemented incorrectly, getByteSize() must return the correct size for each ControllerEvent subclass.");
        }
    }

    @Override
    public final void readFromParcel(Parcel parcel) {
        int n2;
        int n3 = parcel.dataPosition();
        int n4 = parcel.readInt();
        int n5 = n3 + n4;
        super.readFromParcel(parcel);
        if (parcel.dataPosition() < n5) {
            this.positionEventCount = parcel.readInt();
            this.checkIsValidEventCount(this.positionEventCount);
            for (n2 = 0; n2 < this.positionEventCount; ++n2) {
                this.positionEvents[n2].readFromParcel(parcel);
            }
        }
        if (parcel.dataPosition() < n5) {
            boolean bl2 = this.hasBatteryEvent = 0 != parcel.readInt();
            if (this.hasBatteryEvent) {
                this.batteryEvent.readFromParcel(parcel);
            }
        }
        if (parcel.dataPosition() < n5) {
            this.timestampMillis = parcel.readLong();
        }
        if (parcel.dataPosition() < n5) {
            this.trackingStatusEventCount = parcel.readInt();
            this.checkIsValidEventCount(this.trackingStatusEventCount);
            for (n2 = 0; n2 < this.trackingStatusEventCount; ++n2) {
                this.trackingStatusEvents[n2].readFromParcel(parcel);
            }
        }
        parcel.setDataPosition(n5);
    }

    public static long getSystemTimeMillis() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }
}

