/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.vr.vrcore.controller.api.ControllerAccelEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerEvent;
import com.google.vr.vrcore.controller.api.ControllerGyroEvent;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;
import java.util.ArrayDeque;

@Deprecated
public class ControllerEventPacket
implements Parcelable {
    private static ArrayDeque<ControllerEventPacket> pool = new ArrayDeque();
    private static Object poolLock = new Object();
    private int accelEventCount;
    private ControllerAccelEvent[] accelEvents = new ControllerAccelEvent[16];
    private int buttonEventCount;
    private ControllerButtonEvent[] buttonEvents = new ControllerButtonEvent[16];
    private int gyroEventCount;
    private ControllerGyroEvent[] gyroEvents = new ControllerGyroEvent[16];
    private int orientationEventCount;
    private ControllerOrientationEvent[] orientationEvents = new ControllerOrientationEvent[16];
    private int touchEventCount;
    private ControllerTouchEvent[] touchEvents = new ControllerTouchEvent[16];
    public static final Parcelable.Creator<ControllerEventPacket> CREATOR = new Parcelable.Creator<ControllerEventPacket>(){

        public ControllerEventPacket createFromParcel(Parcel parcel) {
            ControllerEventPacket controllerEventPacket = ControllerEventPacket.obtain();
            controllerEventPacket.readFromParcel(parcel);
            return controllerEventPacket;
        }

        public ControllerEventPacket[] newArray(int n2) {
            return new ControllerEventPacket[n2];
        }
    };

    public ControllerEventPacket() {
        for (int i2 = 0; i2 < 16; ++i2) {
            this.accelEvents[i2] = new ControllerAccelEvent();
            this.buttonEvents[i2] = new ControllerButtonEvent();
            this.gyroEvents[i2] = new ControllerGyroEvent();
            this.orientationEvents[i2] = new ControllerOrientationEvent();
            this.touchEvents[i2] = new ControllerTouchEvent();
        }
        this.clear();
    }

    public void clear() {
        this.accelEventCount = 0;
        this.buttonEventCount = 0;
        this.gyroEventCount = 0;
        this.orientationEventCount = 0;
        this.touchEventCount = 0;
    }

    public void setEventsControllerIndex(int n2) {
        ControllerEventPacket.setControllerIndex(n2, this.accelEventCount, this.accelEvents);
        ControllerEventPacket.setControllerIndex(n2, this.buttonEventCount, this.buttonEvents);
        ControllerEventPacket.setControllerIndex(n2, this.gyroEventCount, this.gyroEvents);
        ControllerEventPacket.setControllerIndex(n2, this.orientationEventCount, this.orientationEvents);
        ControllerEventPacket.setControllerIndex(n2, this.touchEventCount, this.touchEvents);
    }

    public int getAccelEventCount() {
        return this.accelEventCount;
    }

    public int getButtonEventCount() {
        return this.buttonEventCount;
    }

    public int getGyroEventCount() {
        return this.gyroEventCount;
    }

    public int getOrientationEventCount() {
        return this.orientationEventCount;
    }

    public int getTouchEventCount() {
        return this.touchEventCount;
    }

    public ControllerAccelEvent getAccelEvent(int n2) {
        if (n2 < 0 || n2 >= this.accelEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.accelEvents[n2];
    }

    public ControllerButtonEvent getButtonEvent(int n2) {
        if (n2 < 0 || n2 >= this.buttonEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.buttonEvents[n2];
    }

    public ControllerGyroEvent getGyroEvent(int n2) {
        if (n2 < 0 || n2 >= this.gyroEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.gyroEvents[n2];
    }

    public ControllerOrientationEvent getOrientationEvent(int n2) {
        if (n2 < 0 || n2 >= this.orientationEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.orientationEvents[n2];
    }

    public ControllerTouchEvent getTouchEvent(int n2) {
        if (n2 < 0 || n2 >= this.touchEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.touchEvents[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerEventPacket obtain() {
        Object object = poolLock;
        synchronized (object) {
            return pool.isEmpty() ? new ControllerEventPacket() : pool.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.clear();
        Object object = poolLock;
        synchronized (object) {
            if (!pool.contains(this)) {
                pool.add(this);
            }
            return;
        }
    }

    public int describeContents() {
        return 0;
    }

    protected int calculateParcelByteLength() {
        int n2;
        int n3 = 4;
        n3 += 20;
        for (n2 = 0; n2 < this.accelEventCount; ++n2) {
            n3 += this.accelEvents[n2].getByteSize();
        }
        for (n2 = 0; n2 < this.buttonEventCount; ++n2) {
            n3 += this.buttonEvents[n2].getByteSize();
        }
        for (n2 = 0; n2 < this.gyroEventCount; ++n2) {
            n3 += this.gyroEvents[n2].getByteSize();
        }
        for (n2 = 0; n2 < this.orientationEventCount; ++n2) {
            n3 += this.orientationEvents[n2].getByteSize();
        }
        for (n2 = 0; n2 < this.touchEventCount; ++n2) {
            n3 += this.touchEvents[n2].getByteSize();
        }
        return n3;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        int n3;
        parcel.writeInt(1);
        parcel.writeInt(this.accelEventCount);
        for (n3 = 0; n3 < this.accelEventCount; ++n3) {
            this.accelEvents[n3].writeToParcel(parcel, n2);
        }
        parcel.writeInt(this.buttonEventCount);
        for (n3 = 0; n3 < this.buttonEventCount; ++n3) {
            this.buttonEvents[n3].writeToParcel(parcel, n2);
        }
        parcel.writeInt(this.gyroEventCount);
        for (n3 = 0; n3 < this.gyroEventCount; ++n3) {
            this.gyroEvents[n3].writeToParcel(parcel, n2);
        }
        parcel.writeInt(this.orientationEventCount);
        for (n3 = 0; n3 < this.orientationEventCount; ++n3) {
            this.orientationEvents[n3].writeToParcel(parcel, n2);
        }
        parcel.writeInt(this.touchEventCount);
        for (n3 = 0; n3 < this.touchEventCount; ++n3) {
            this.touchEvents[n3].writeToParcel(parcel, n2);
        }
    }

    public void readFromParcel(Parcel parcel) {
        int n2;
        parcel.readInt();
        this.accelEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.accelEventCount);
        for (n2 = 0; n2 < this.accelEventCount; ++n2) {
            this.accelEvents[n2].readFromParcel(parcel);
        }
        this.buttonEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.buttonEventCount);
        for (n2 = 0; n2 < this.buttonEventCount; ++n2) {
            this.buttonEvents[n2].readFromParcel(parcel);
        }
        this.gyroEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.gyroEventCount);
        for (n2 = 0; n2 < this.gyroEventCount; ++n2) {
            this.gyroEvents[n2].readFromParcel(parcel);
        }
        this.orientationEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.orientationEventCount);
        for (n2 = 0; n2 < this.orientationEventCount; ++n2) {
            this.orientationEvents[n2].readFromParcel(parcel);
        }
        this.touchEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.touchEventCount);
        for (n2 = 0; n2 < this.touchEventCount; ++n2) {
            this.touchEvents[n2].readFromParcel(parcel);
        }
    }

    protected void checkIsValidEventCount(int n2) {
        if (n2 < 0 || n2 >= 16) {
            throw new IllegalArgumentException(new StringBuilder(32).append("Invalid event count: ").append(n2).toString());
        }
    }

    static void setControllerIndex(int n2, int n3, ControllerEvent[] controllerEventArray) {
        for (int i2 = 0; i2 < n3; ++i2) {
            controllerEventArray[i2].controllerId = n2;
        }
    }
}

