/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.proto.nano;

import com.google.vr.sdk.deps.hl;
import com.google.vr.sdk.deps.hm;
import com.google.vr.sdk.deps.ho;
import com.google.vr.sdk.deps.hs;
import com.google.vr.sdk.deps.hw;
import com.google.vr.sdk.proto.CardboardDevice;
import java.io.IOException;

public class CardboardDevice {

    public static final class DeviceParamsList
    extends ho<DeviceParamsList>
    implements Cloneable {
        public DeviceParams[] params;

        public DeviceParamsList() {
            this.clear();
        }

        public final DeviceParamsList clear() {
            this.params = DeviceParams.emptyArray();
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final DeviceParamsList clone() {
            DeviceParamsList deviceParamsList;
            try {
                deviceParamsList = (DeviceParamsList)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.params != null && this.params.length > 0) {
                deviceParamsList.params = new DeviceParams[this.params.length];
                for (int i2 = 0; i2 < this.params.length; ++i2) {
                    if (this.params[i2] == null) continue;
                    deviceParamsList.params[i2] = this.params[i2].clone();
                }
            }
            return deviceParamsList;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if (this.params != null && this.params.length > 0) {
                for (int i2 = 0; i2 < this.params.length; ++i2) {
                    DeviceParams deviceParams = this.params[i2];
                    if (deviceParams == null) continue;
                    hm2.a(1, deviceParams);
                }
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2 = super.computeSerializedSize();
            if (this.params != null && this.params.length > 0) {
                for (int i2 = 0; i2 < this.params.length; ++i2) {
                    DeviceParams deviceParams = this.params[i2];
                    if (deviceParams == null) continue;
                    n2 += hm.b(1, deviceParams);
                }
            }
            return n2;
        }

        @Override
        public final DeviceParamsList mergeFrom(hl hl2) throws IOException {
            block4: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block4;
                        return this;
                    }
                    case 10: 
                }
                int n3 = hw.a(hl2, 10);
                int n4 = this.params == null ? 0 : this.params.length;
                DeviceParams[] deviceParamsArray = new DeviceParams[n4 + n3];
                if (n4 != 0) {
                    System.arraycopy(this.params, 0, deviceParamsArray, 0, n4);
                }
                while (n4 < deviceParamsArray.length - 1) {
                    deviceParamsArray[n4] = new DeviceParams();
                    hl2.a(deviceParamsArray[n4]);
                    hl2.a();
                    ++n4;
                }
                deviceParamsArray[n4] = new DeviceParams();
                hl2.a(deviceParamsArray[n4]);
                this.params = deviceParamsArray;
            }
        }
    }

    public static final class ScreenAlignmentMarker
    extends ho<ScreenAlignmentMarker>
    implements Cloneable {
        private static volatile ScreenAlignmentMarker[] _emptyArray;
        private int bitField0_;
        private float horizontal_;
        private float vertical_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ScreenAlignmentMarker[] emptyArray() {
            if (_emptyArray == null) {
                Object object = hs.b;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ScreenAlignmentMarker[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final float getHorizontal() {
            return this.horizontal_;
        }

        public final float getVertical() {
            return this.vertical_;
        }

        public ScreenAlignmentMarker() {
            this.clear();
        }

        public final ScreenAlignmentMarker clear() {
            this.bitField0_ = 0;
            this.horizontal_ = 0.0f;
            this.vertical_ = 0.0f;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final ScreenAlignmentMarker clone() {
            ScreenAlignmentMarker screenAlignmentMarker;
            try {
                screenAlignmentMarker = (ScreenAlignmentMarker)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            return screenAlignmentMarker;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                hm2.a(1, this.horizontal_);
            }
            if ((this.bitField0_ & 2) != 0) {
                hm2.a(2, this.vertical_);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2;
            float f2;
            int n3 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                f2 = this.horizontal_;
                n2 = 1;
                n3 += hm.b(1) + 4;
            }
            if ((this.bitField0_ & 2) != 0) {
                f2 = this.vertical_;
                n2 = 2;
                n3 += hm.b(2) + 4;
            }
            return n3;
        }

        @Override
        public final ScreenAlignmentMarker mergeFrom(hl hl2) throws IOException {
            block5: while (true) {
                hl hl3;
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block5;
                        return this;
                    }
                    case 13: {
                        hl3 = hl2;
                        this.horizontal_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 1;
                        continue block5;
                    }
                    case 21: 
                }
                hl3 = hl2;
                this.vertical_ = Float.intBitsToFloat(hl3.g());
                this.bitField0_ |= 2;
            }
        }
    }

    public static final class VignetteParams
    extends ho<VignetteParams>
    implements Cloneable {
        private int bitField0_;
        private Integer condition_;
        private float value_;

        public VignetteParams() {
            this.clear();
        }

        public final VignetteParams clear() {
            this.bitField0_ = 0;
            this.condition_ = CardboardDevice.VignetteParams.VignetteParamsCondition.NO_VIGNETTE_CONDITION == null ? null : Integer.valueOf(CardboardDevice.VignetteParams.VignetteParamsCondition.NO_VIGNETTE_CONDITION.getNumber());
            this.value_ = 0.0f;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final VignetteParams clone() {
            VignetteParams vignetteParams;
            try {
                vignetteParams = (VignetteParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            return vignetteParams;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if ((this.bitField0_ & 1) != 0 && this.condition_ != null) {
                hm2.a(2, this.condition_);
            }
            if ((this.bitField0_ & 2) != 0) {
                hm2.a(3, this.value_);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0 && this.condition_ != null) {
                n2 += hm.b(2, this.condition_);
            }
            if ((this.bitField0_ & 2) != 0) {
                float f2 = this.value_;
                int n3 = 3;
                n2 += hm.b(3) + 4;
            }
            return n2;
        }

        @Override
        public final VignetteParams mergeFrom(hl hl2) throws IOException {
            block8: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block8;
                        return this;
                    }
                    case 16: {
                        this.bitField0_ |= 1;
                        int n3 = hl2.i();
                        int n4 = hl2.b();
                        switch (n4) {
                            case 0: 
                            case 1: {
                                this.condition_ = n4;
                                this.bitField0_ |= 1;
                                continue block8;
                            }
                        }
                        hl2.e(n3);
                        this.storeUnknownField(hl2, n2);
                        continue block8;
                    }
                    case 29: 
                }
                hl hl3 = hl2;
                this.value_ = Float.intBitsToFloat(hl3.g());
                this.bitField0_ |= 2;
            }
        }
    }

    public static final class DaydreamInternalParams
    extends ho<DaydreamInternalParams>
    implements Cloneable {
        private int bitField0_;
        private int version_;
        public ScreenAlignmentMarker[] alignmentMarkers;
        private boolean useRotationalAlignmentCorrection_;
        private boolean sensorOrientationIndependentOfDisplay_;
        public VignetteParams vignetteParams;
        private int distortionMeshResolution_;
        private boolean clipFieldOfViewToDisplay_;
        private boolean clampDistortionToMaximumFieldOfView_;

        public final boolean getUseRotationalAlignmentCorrection() {
            return this.useRotationalAlignmentCorrection_;
        }

        public DaydreamInternalParams() {
            this.clear();
        }

        public final DaydreamInternalParams clear() {
            this.bitField0_ = 0;
            this.version_ = 0;
            this.alignmentMarkers = ScreenAlignmentMarker.emptyArray();
            this.useRotationalAlignmentCorrection_ = false;
            this.sensorOrientationIndependentOfDisplay_ = false;
            this.vignetteParams = null;
            this.distortionMeshResolution_ = 40;
            this.clipFieldOfViewToDisplay_ = true;
            this.clampDistortionToMaximumFieldOfView_ = false;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final DaydreamInternalParams clone() {
            DaydreamInternalParams daydreamInternalParams;
            try {
                daydreamInternalParams = (DaydreamInternalParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.alignmentMarkers != null && this.alignmentMarkers.length > 0) {
                daydreamInternalParams.alignmentMarkers = new ScreenAlignmentMarker[this.alignmentMarkers.length];
                for (int i2 = 0; i2 < this.alignmentMarkers.length; ++i2) {
                    if (this.alignmentMarkers[i2] == null) continue;
                    daydreamInternalParams.alignmentMarkers[i2] = this.alignmentMarkers[i2].clone();
                }
            }
            if (this.vignetteParams != null) {
                daydreamInternalParams.vignetteParams = this.vignetteParams.clone();
            }
            return daydreamInternalParams;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                hm2.a(1, this.version_);
            }
            if (this.alignmentMarkers != null && this.alignmentMarkers.length > 0) {
                for (int i2 = 0; i2 < this.alignmentMarkers.length; ++i2) {
                    ScreenAlignmentMarker screenAlignmentMarker = this.alignmentMarkers[i2];
                    if (screenAlignmentMarker == null) continue;
                    hm2.a(2, screenAlignmentMarker);
                }
            }
            if ((this.bitField0_ & 2) != 0) {
                hm2.a(3, this.useRotationalAlignmentCorrection_);
            }
            if ((this.bitField0_ & 4) != 0) {
                hm2.a(4, this.sensorOrientationIndependentOfDisplay_);
            }
            if (this.vignetteParams != null) {
                hm2.a(5, this.vignetteParams);
            }
            if ((this.bitField0_ & 8) != 0) {
                hm2.a(6, this.distortionMeshResolution_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                hm2.a(7, this.clipFieldOfViewToDisplay_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                hm2.a(8, this.clampDistortionToMaximumFieldOfView_);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2;
            boolean bl2;
            int n3 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n3 += hm.b(1, this.version_);
            }
            if (this.alignmentMarkers != null && this.alignmentMarkers.length > 0) {
                for (int i2 = 0; i2 < this.alignmentMarkers.length; ++i2) {
                    ScreenAlignmentMarker screenAlignmentMarker = this.alignmentMarkers[i2];
                    if (screenAlignmentMarker == null) continue;
                    n3 += hm.b(2, screenAlignmentMarker);
                }
            }
            if ((this.bitField0_ & 2) != 0) {
                bl2 = this.useRotationalAlignmentCorrection_;
                n2 = 3;
                n3 += hm.b(3) + 1;
            }
            if ((this.bitField0_ & 4) != 0) {
                bl2 = this.sensorOrientationIndependentOfDisplay_;
                n2 = 4;
                n3 += hm.b(4) + 1;
            }
            if (this.vignetteParams != null) {
                n3 += hm.b(5, this.vignetteParams);
            }
            if ((this.bitField0_ & 8) != 0) {
                n3 += hm.b(6, this.distortionMeshResolution_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                bl2 = this.clipFieldOfViewToDisplay_;
                n2 = 7;
                n3 += hm.b(7) + 1;
            }
            if ((this.bitField0_ & 0x20) != 0) {
                bl2 = this.clampDistortionToMaximumFieldOfView_;
                n2 = 8;
                n3 += hm.b(8) + 1;
            }
            return n3;
        }

        @Override
        public final DaydreamInternalParams mergeFrom(hl hl2) throws IOException {
            block11: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block11;
                        return this;
                    }
                    case 8: {
                        this.version_ = hl2.b();
                        this.bitField0_ |= 1;
                        continue block11;
                    }
                    case 18: {
                        int n3 = hw.a(hl2, 18);
                        int n4 = this.alignmentMarkers == null ? 0 : this.alignmentMarkers.length;
                        ScreenAlignmentMarker[] screenAlignmentMarkerArray = new ScreenAlignmentMarker[n4 + n3];
                        if (n4 != 0) {
                            System.arraycopy(this.alignmentMarkers, 0, screenAlignmentMarkerArray, 0, n4);
                        }
                        while (n4 < screenAlignmentMarkerArray.length - 1) {
                            screenAlignmentMarkerArray[n4] = new ScreenAlignmentMarker();
                            hl2.a(screenAlignmentMarkerArray[n4]);
                            hl2.a();
                            ++n4;
                        }
                        screenAlignmentMarkerArray[n4] = new ScreenAlignmentMarker();
                        hl2.a(screenAlignmentMarkerArray[n4]);
                        this.alignmentMarkers = screenAlignmentMarkerArray;
                        continue block11;
                    }
                    case 24: {
                        this.useRotationalAlignmentCorrection_ = hl2.c();
                        this.bitField0_ |= 2;
                        continue block11;
                    }
                    case 32: {
                        this.sensorOrientationIndependentOfDisplay_ = hl2.c();
                        this.bitField0_ |= 4;
                        continue block11;
                    }
                    case 42: {
                        if (this.vignetteParams == null) {
                            this.vignetteParams = new VignetteParams();
                        }
                        hl2.a(this.vignetteParams);
                        continue block11;
                    }
                    case 48: {
                        this.distortionMeshResolution_ = hl2.b();
                        this.bitField0_ |= 8;
                        continue block11;
                    }
                    case 56: {
                        this.clipFieldOfViewToDisplay_ = hl2.c();
                        this.bitField0_ |= 0x10;
                        continue block11;
                    }
                    case 64: 
                }
                this.clampDistortionToMaximumFieldOfView_ = hl2.c();
                this.bitField0_ |= 0x20;
            }
        }
    }

    public static final class CardboardInternalParams
    extends ho<CardboardInternalParams>
    implements Cloneable {
        private int bitField0_;
        public int[] eyeOrientations;
        private float screenCenterToLensDistance_;
        private float xPpiOverride_;
        private float yPpiOverride_;
        private String accelerometer_;
        private String gyroscope_;

        public static int checkOrientationTypeOrThrow(int n2) {
            if (n2 >= 0 && n2 <= 7) {
                return n2;
            }
            throw new IllegalArgumentException(new StringBuilder(47).append(n2).append(" is not a valid enum OrientationType").toString());
        }

        public CardboardInternalParams() {
            this.clear();
        }

        public final CardboardInternalParams clear() {
            this.bitField0_ = 0;
            this.eyeOrientations = hw.a;
            this.screenCenterToLensDistance_ = 0.0f;
            this.xPpiOverride_ = 0.0f;
            this.yPpiOverride_ = 0.0f;
            this.accelerometer_ = "";
            this.gyroscope_ = "";
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final CardboardInternalParams clone() {
            CardboardInternalParams cardboardInternalParams;
            try {
                cardboardInternalParams = (CardboardInternalParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.eyeOrientations != null && this.eyeOrientations.length > 0) {
                cardboardInternalParams.eyeOrientations = (int[])this.eyeOrientations.clone();
            }
            return cardboardInternalParams;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            if (this.eyeOrientations != null && this.eyeOrientations.length > 0) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < this.eyeOrientations.length; ++n2) {
                    int n4 = this.eyeOrientations[n2];
                    n3 += hm.a(n4);
                }
                hm2.c(10);
                hm2.c(n3);
                for (n2 = 0; n2 < this.eyeOrientations.length; ++n2) {
                    hm2.c(this.eyeOrientations[n2]);
                }
            }
            if ((this.bitField0_ & 1) != 0) {
                hm2.a(2, this.screenCenterToLensDistance_);
            }
            if ((this.bitField0_ & 2) != 0) {
                hm2.a(3, this.xPpiOverride_);
            }
            if ((this.bitField0_ & 4) != 0) {
                hm2.a(4, this.yPpiOverride_);
            }
            if ((this.bitField0_ & 8) != 0) {
                hm2.a(5, this.accelerometer_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                hm2.a(6, this.gyroscope_);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2;
            float f2;
            int n3 = super.computeSerializedSize();
            if (this.eyeOrientations != null && this.eyeOrientations.length > 0) {
                int n4 = 0;
                for (int i2 = 0; i2 < this.eyeOrientations.length; ++i2) {
                    int n5 = this.eyeOrientations[i2];
                    n4 += hm.a(n5);
                }
                n3 += n4;
                ++n3;
                n3 += hm.d(n4);
            }
            if ((this.bitField0_ & 1) != 0) {
                f2 = this.screenCenterToLensDistance_;
                n2 = 2;
                n3 += hm.b(2) + 4;
            }
            if ((this.bitField0_ & 2) != 0) {
                f2 = this.xPpiOverride_;
                n2 = 3;
                n3 += hm.b(3) + 4;
            }
            if ((this.bitField0_ & 4) != 0) {
                f2 = this.yPpiOverride_;
                n2 = 4;
                n3 += hm.b(4) + 4;
            }
            if ((this.bitField0_ & 8) != 0) {
                n3 += hm.b(5, this.accelerometer_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                n3 += hm.b(6, this.gyroscope_);
            }
            return n3;
        }

        @Override
        public final CardboardInternalParams mergeFrom(hl hl2) throws IOException {
            block16: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block16;
                        return this;
                    }
                    case 8: {
                        int n3;
                        int n4 = hw.a(hl2, 8);
                        int[] nArray = new int[n4];
                        int n5 = 0;
                        for (n3 = 0; n3 < n4; ++n3) {
                            if (n3 != 0) {
                                hl2.a();
                            }
                            int n6 = hl2.i();
                            try {
                                nArray[n5] = CardboardInternalParams.checkOrientationTypeOrThrow(hl2.b());
                                ++n5;
                                continue;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                hl2.e(n6);
                                this.storeUnknownField(hl2, n2);
                            }
                        }
                        if (n5 == 0) continue block16;
                        n3 = this.eyeOrientations == null ? 0 : this.eyeOrientations.length;
                        if (n3 == 0 && n5 == nArray.length) {
                            this.eyeOrientations = nArray;
                            continue block16;
                        }
                        int[] nArray2 = new int[n3 + n5];
                        if (n3 != 0) {
                            System.arraycopy(this.eyeOrientations, 0, nArray2, 0, n3);
                        }
                        System.arraycopy(nArray, 0, nArray2, n3, n5);
                        this.eyeOrientations = nArray2;
                        continue block16;
                    }
                    case 10: {
                        int n4 = hl2.e();
                        int n7 = hl2.c(n4);
                        int n5 = 0;
                        int n3 = hl2.i();
                        while (hl2.h() > 0) {
                            try {
                                CardboardInternalParams.checkOrientationTypeOrThrow(hl2.b());
                                ++n5;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        if (n5 != 0) {
                            hl2.e(n3);
                            int n8 = this.eyeOrientations == null ? 0 : this.eyeOrientations.length;
                            int[] nArray = new int[n8 + n5];
                            if (n8 != 0) {
                                System.arraycopy(this.eyeOrientations, 0, nArray, 0, n8);
                            }
                            while (hl2.h() > 0) {
                                int n9 = hl2.i();
                                try {
                                    nArray[n8] = CardboardInternalParams.checkOrientationTypeOrThrow(hl2.b());
                                    ++n8;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    hl2.e(n9);
                                    this.storeUnknownField(hl2, 8);
                                }
                            }
                            this.eyeOrientations = nArray;
                        }
                        hl2.d(n7);
                        continue block16;
                    }
                    case 21: {
                        hl hl3 = hl2;
                        this.screenCenterToLensDistance_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 1;
                        continue block16;
                    }
                    case 29: {
                        hl hl3 = hl2;
                        this.xPpiOverride_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 2;
                        continue block16;
                    }
                    case 37: {
                        hl hl3 = hl2;
                        this.yPpiOverride_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 4;
                        continue block16;
                    }
                    case 42: {
                        this.accelerometer_ = hl2.d();
                        this.bitField0_ |= 8;
                        continue block16;
                    }
                    case 50: 
                }
                this.gyroscope_ = hl2.d();
                this.bitField0_ |= 0x10;
            }
        }
    }

    public static final class DeviceParams
    extends ho<DeviceParams>
    implements Cloneable {
        private static volatile DeviceParams[] _emptyArray;
        private int bitField0_;
        private String vendor_;
        private String model_;
        private float screenToLensDistance_;
        private float interLensDistance_;
        public float[] leftEyeFieldOfViewAngles;
        private Integer verticalAlignment_;
        private float trayToLensDistance_;
        public float[] distortionCoefficients;
        public float[] greenDistortionCoefficients;
        public float[] blueDistortionCoefficients;
        private boolean hasMagnet_;
        private Integer primaryButton_;
        public CardboardInternalParams internal;
        public DaydreamInternalParams daydreamInternal;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DeviceParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = hs.b;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DeviceParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final String getVendor() {
            return this.vendor_;
        }

        public final DeviceParams setVendor(String string2) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.vendor_ = string2;
            return this;
        }

        public final String getModel() {
            return this.model_;
        }

        public final DeviceParams setModel(String string2) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.model_ = string2;
            return this;
        }

        public final float getScreenToLensDistance() {
            return this.screenToLensDistance_;
        }

        public final DeviceParams setScreenToLensDistance(float f2) {
            this.bitField0_ |= 4;
            this.screenToLensDistance_ = f2;
            return this;
        }

        public final float getInterLensDistance() {
            return this.interLensDistance_;
        }

        public final DeviceParams setInterLensDistance(float f2) {
            this.bitField0_ |= 8;
            this.interLensDistance_ = f2;
            return this;
        }

        public final CardboardDevice.DeviceParams.VerticalAlignmentType getVerticalAlignment() {
            if (this.verticalAlignment_ == null) {
                return CardboardDevice.DeviceParams.VerticalAlignmentType.BOTTOM;
            }
            CardboardDevice.DeviceParams.VerticalAlignmentType verticalAlignmentType = CardboardDevice.DeviceParams.VerticalAlignmentType.forNumber(this.verticalAlignment_);
            return verticalAlignmentType;
        }

        public final DeviceParams setVerticalAlignment(CardboardDevice.DeviceParams.VerticalAlignmentType verticalAlignmentType) {
            this.verticalAlignment_ = verticalAlignmentType == null ? null : Integer.valueOf(verticalAlignmentType.getNumber());
            this.bitField0_ |= 0x10;
            return this;
        }

        public final float getTrayToLensDistance() {
            return this.trayToLensDistance_;
        }

        public final DeviceParams setTrayToLensDistance(float f2) {
            this.bitField0_ |= 0x20;
            this.trayToLensDistance_ = f2;
            return this;
        }

        public final boolean getHasMagnet() {
            return this.hasMagnet_;
        }

        public final DeviceParams setHasMagnet(boolean bl2) {
            this.bitField0_ |= 0x40;
            this.hasMagnet_ = bl2;
            return this;
        }

        public DeviceParams() {
            this.clear();
        }

        public final DeviceParams clear() {
            this.bitField0_ = 0;
            this.vendor_ = "";
            this.model_ = "";
            this.screenToLensDistance_ = 0.0f;
            this.interLensDistance_ = 0.0f;
            this.leftEyeFieldOfViewAngles = hw.b;
            this.verticalAlignment_ = CardboardDevice.DeviceParams.VerticalAlignmentType.BOTTOM == null ? null : Integer.valueOf(CardboardDevice.DeviceParams.VerticalAlignmentType.BOTTOM.getNumber());
            this.trayToLensDistance_ = 0.0f;
            this.distortionCoefficients = hw.b;
            this.greenDistortionCoefficients = hw.b;
            this.blueDistortionCoefficients = hw.b;
            this.hasMagnet_ = false;
            this.primaryButton_ = CardboardDevice.DeviceParams.ButtonType.MAGNET == null ? null : Integer.valueOf(CardboardDevice.DeviceParams.ButtonType.MAGNET.getNumber());
            this.internal = null;
            this.daydreamInternal = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public final DeviceParams clone() {
            DeviceParams deviceParams;
            try {
                deviceParams = (DeviceParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                deviceParams.leftEyeFieldOfViewAngles = (float[])this.leftEyeFieldOfViewAngles.clone();
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                deviceParams.distortionCoefficients = (float[])this.distortionCoefficients.clone();
            }
            if (this.greenDistortionCoefficients != null && this.greenDistortionCoefficients.length > 0) {
                deviceParams.greenDistortionCoefficients = (float[])this.greenDistortionCoefficients.clone();
            }
            if (this.blueDistortionCoefficients != null && this.blueDistortionCoefficients.length > 0) {
                deviceParams.blueDistortionCoefficients = (float[])this.blueDistortionCoefficients.clone();
            }
            if (this.internal != null) {
                deviceParams.internal = this.internal.clone();
            }
            if (this.daydreamInternal != null) {
                deviceParams.daydreamInternal = this.daydreamInternal.clone();
            }
            return deviceParams;
        }

        @Override
        public final void writeTo(hm hm2) throws IOException {
            int n2;
            int n3;
            if ((this.bitField0_ & 1) != 0) {
                hm2.a(1, this.vendor_);
            }
            if ((this.bitField0_ & 2) != 0) {
                hm2.a(2, this.model_);
            }
            if ((this.bitField0_ & 4) != 0) {
                hm2.a(3, this.screenToLensDistance_);
            }
            if ((this.bitField0_ & 8) != 0) {
                hm2.a(4, this.interLensDistance_);
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                n3 = 4 * this.leftEyeFieldOfViewAngles.length;
                hm2.c(42);
                hm2.c(n3);
                for (n2 = 0; n2 < this.leftEyeFieldOfViewAngles.length; ++n2) {
                    hm2.a(this.leftEyeFieldOfViewAngles[n2]);
                }
            }
            if ((this.bitField0_ & 0x20) != 0) {
                hm2.a(6, this.trayToLensDistance_);
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                n3 = 4 * this.distortionCoefficients.length;
                hm2.c(58);
                hm2.c(n3);
                for (n2 = 0; n2 < this.distortionCoefficients.length; ++n2) {
                    hm2.a(this.distortionCoefficients[n2]);
                }
            }
            if (this.greenDistortionCoefficients != null && this.greenDistortionCoefficients.length > 0) {
                n3 = 4 * this.greenDistortionCoefficients.length;
                hm2.c(66);
                hm2.c(n3);
                for (n2 = 0; n2 < this.greenDistortionCoefficients.length; ++n2) {
                    hm2.a(this.greenDistortionCoefficients[n2]);
                }
            }
            if (this.blueDistortionCoefficients != null && this.blueDistortionCoefficients.length > 0) {
                n3 = 4 * this.blueDistortionCoefficients.length;
                hm2.c(74);
                hm2.c(n3);
                for (n2 = 0; n2 < this.blueDistortionCoefficients.length; ++n2) {
                    hm2.a(this.blueDistortionCoefficients[n2]);
                }
            }
            if ((this.bitField0_ & 0x40) != 0) {
                hm2.a(10, this.hasMagnet_);
            }
            if ((this.bitField0_ & 0x10) != 0 && this.verticalAlignment_ != null) {
                hm2.a(11, this.verticalAlignment_);
            }
            if ((this.bitField0_ & 0x80) != 0 && this.primaryButton_ != null) {
                hm2.a(12, this.primaryButton_);
            }
            if (this.internal != null) {
                hm2.a(1729, this.internal);
            }
            if (this.daydreamInternal != null) {
                hm2.a(196883, this.daydreamInternal);
            }
            super.writeTo(hm2);
        }

        @Override
        protected final int computeSerializedSize() {
            int n2;
            int n3;
            float f2;
            int n4 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n4 += hm.b(1, this.vendor_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n4 += hm.b(2, this.model_);
            }
            if ((this.bitField0_ & 4) != 0) {
                f2 = this.screenToLensDistance_;
                n3 = 3;
                n4 += hm.b(3) + 4;
            }
            if ((this.bitField0_ & 8) != 0) {
                f2 = this.interLensDistance_;
                n3 = 4;
                n4 += hm.b(4) + 4;
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                n2 = 4 * this.leftEyeFieldOfViewAngles.length;
                n4 += n2;
                ++n4;
                n4 += hm.d(n2);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                f2 = this.trayToLensDistance_;
                n3 = 6;
                n4 += hm.b(6) + 4;
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                n2 = 4 * this.distortionCoefficients.length;
                n4 += n2;
                ++n4;
                n4 += hm.d(n2);
            }
            if (this.greenDistortionCoefficients != null && this.greenDistortionCoefficients.length > 0) {
                n2 = 4 * this.greenDistortionCoefficients.length;
                n4 += n2;
                ++n4;
                n4 += hm.d(n2);
            }
            if (this.blueDistortionCoefficients != null && this.blueDistortionCoefficients.length > 0) {
                n2 = 4 * this.blueDistortionCoefficients.length;
                n4 += n2;
                ++n4;
                n4 += hm.d(n2);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                boolean bl2 = this.hasMagnet_;
                n3 = 10;
                n4 += hm.b(10) + 1;
            }
            if ((this.bitField0_ & 0x10) != 0 && this.verticalAlignment_ != null) {
                n4 += hm.b(11, this.verticalAlignment_);
            }
            if ((this.bitField0_ & 0x80) != 0 && this.primaryButton_ != null) {
                n4 += hm.b(12, this.primaryButton_);
            }
            if (this.internal != null) {
                n4 += hm.b(1729, this.internal);
            }
            if (this.daydreamInternal != null) {
                n4 += hm.b(196883, this.daydreamInternal);
            }
            return n4;
        }

        @Override
        public final DeviceParams mergeFrom(hl hl2) throws IOException {
            block27: while (true) {
                int n2 = hl2.a();
                switch (n2) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(hl2, n2)) continue block27;
                        return this;
                    }
                    case 10: {
                        this.vendor_ = hl2.d();
                        this.bitField0_ |= 1;
                        continue block27;
                    }
                    case 18: {
                        this.model_ = hl2.d();
                        this.bitField0_ |= 2;
                        continue block27;
                    }
                    case 29: {
                        hl hl3 = hl2;
                        this.screenToLensDistance_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 4;
                        continue block27;
                    }
                    case 37: {
                        hl hl3 = hl2;
                        this.interLensDistance_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 8;
                        continue block27;
                    }
                    case 45: {
                        hl hl3;
                        int n3 = hw.a(hl2, 45);
                        int n4 = this.leftEyeFieldOfViewAngles == null ? 0 : this.leftEyeFieldOfViewAngles.length;
                        float[] fArray = new float[n4 + n3];
                        if (n4 != 0) {
                            System.arraycopy(this.leftEyeFieldOfViewAngles, 0, fArray, 0, n4);
                        }
                        while (n4 < fArray.length - 1) {
                            hl3 = hl2;
                            fArray[n4] = Float.intBitsToFloat(hl3.g());
                            hl2.a();
                            ++n4;
                        }
                        hl3 = hl2;
                        fArray[n4] = Float.intBitsToFloat(hl3.g());
                        this.leftEyeFieldOfViewAngles = fArray;
                        continue block27;
                    }
                    case 42: {
                        hl hl3;
                        int n3 = hl2.e();
                        int n4 = hl2.c(n3);
                        int n5 = n3 / 4;
                        int n6 = this.leftEyeFieldOfViewAngles == null ? 0 : this.leftEyeFieldOfViewAngles.length;
                        float[] fArray = new float[n6 + n5];
                        if (n6 != 0) {
                            System.arraycopy(this.leftEyeFieldOfViewAngles, 0, fArray, 0, n6);
                        }
                        while (n6 < fArray.length) {
                            hl3 = hl2;
                            fArray[n6] = Float.intBitsToFloat(hl3.g());
                            ++n6;
                        }
                        this.leftEyeFieldOfViewAngles = fArray;
                        hl2.d(n4);
                        continue block27;
                    }
                    case 53: {
                        hl hl3 = hl2;
                        this.trayToLensDistance_ = Float.intBitsToFloat(hl3.g());
                        this.bitField0_ |= 0x20;
                        continue block27;
                    }
                    case 61: {
                        hl hl3;
                        int n3 = hw.a(hl2, 61);
                        int n4 = this.distortionCoefficients == null ? 0 : this.distortionCoefficients.length;
                        float[] fArray = new float[n4 + n3];
                        if (n4 != 0) {
                            System.arraycopy(this.distortionCoefficients, 0, fArray, 0, n4);
                        }
                        while (n4 < fArray.length - 1) {
                            hl3 = hl2;
                            fArray[n4] = Float.intBitsToFloat(hl3.g());
                            hl2.a();
                            ++n4;
                        }
                        hl3 = hl2;
                        fArray[n4] = Float.intBitsToFloat(hl3.g());
                        this.distortionCoefficients = fArray;
                        continue block27;
                    }
                    case 58: {
                        hl hl3;
                        int n3 = hl2.e();
                        int n4 = hl2.c(n3);
                        int n7 = n3 / 4;
                        int n6 = this.distortionCoefficients == null ? 0 : this.distortionCoefficients.length;
                        float[] fArray = new float[n6 + n7];
                        if (n6 != 0) {
                            System.arraycopy(this.distortionCoefficients, 0, fArray, 0, n6);
                        }
                        while (n6 < fArray.length) {
                            hl3 = hl2;
                            fArray[n6] = Float.intBitsToFloat(hl3.g());
                            ++n6;
                        }
                        this.distortionCoefficients = fArray;
                        hl2.d(n4);
                        continue block27;
                    }
                    case 69: {
                        hl hl3;
                        int n3 = hw.a(hl2, 69);
                        int n4 = this.greenDistortionCoefficients == null ? 0 : this.greenDistortionCoefficients.length;
                        float[] fArray = new float[n4 + n3];
                        if (n4 != 0) {
                            System.arraycopy(this.greenDistortionCoefficients, 0, fArray, 0, n4);
                        }
                        while (n4 < fArray.length - 1) {
                            hl3 = hl2;
                            fArray[n4] = Float.intBitsToFloat(hl3.g());
                            hl2.a();
                            ++n4;
                        }
                        hl3 = hl2;
                        fArray[n4] = Float.intBitsToFloat(hl3.g());
                        this.greenDistortionCoefficients = fArray;
                        continue block27;
                    }
                    case 66: {
                        hl hl3;
                        int n3 = hl2.e();
                        int n4 = hl2.c(n3);
                        int n8 = n3 / 4;
                        int n6 = this.greenDistortionCoefficients == null ? 0 : this.greenDistortionCoefficients.length;
                        float[] fArray = new float[n6 + n8];
                        if (n6 != 0) {
                            System.arraycopy(this.greenDistortionCoefficients, 0, fArray, 0, n6);
                        }
                        while (n6 < fArray.length) {
                            hl3 = hl2;
                            fArray[n6] = Float.intBitsToFloat(hl3.g());
                            ++n6;
                        }
                        this.greenDistortionCoefficients = fArray;
                        hl2.d(n4);
                        continue block27;
                    }
                    case 77: {
                        hl hl3;
                        int n3 = hw.a(hl2, 77);
                        int n4 = this.blueDistortionCoefficients == null ? 0 : this.blueDistortionCoefficients.length;
                        float[] fArray = new float[n4 + n3];
                        if (n4 != 0) {
                            System.arraycopy(this.blueDistortionCoefficients, 0, fArray, 0, n4);
                        }
                        while (n4 < fArray.length - 1) {
                            hl3 = hl2;
                            fArray[n4] = Float.intBitsToFloat(hl3.g());
                            hl2.a();
                            ++n4;
                        }
                        hl3 = hl2;
                        fArray[n4] = Float.intBitsToFloat(hl3.g());
                        this.blueDistortionCoefficients = fArray;
                        continue block27;
                    }
                    case 74: {
                        hl hl3;
                        int n3 = hl2.e();
                        int n4 = hl2.c(n3);
                        int n9 = n3 / 4;
                        int n6 = this.blueDistortionCoefficients == null ? 0 : this.blueDistortionCoefficients.length;
                        float[] fArray = new float[n6 + n9];
                        if (n6 != 0) {
                            System.arraycopy(this.blueDistortionCoefficients, 0, fArray, 0, n6);
                        }
                        while (n6 < fArray.length) {
                            hl3 = hl2;
                            fArray[n6] = Float.intBitsToFloat(hl3.g());
                            ++n6;
                        }
                        this.blueDistortionCoefficients = fArray;
                        hl2.d(n4);
                        continue block27;
                    }
                    case 80: {
                        this.hasMagnet_ = hl2.c();
                        this.bitField0_ |= 0x40;
                        continue block27;
                    }
                    case 88: {
                        this.bitField0_ |= 0x10;
                        int n3 = hl2.i();
                        int n4 = hl2.b();
                        switch (n4) {
                            case 0: 
                            case 1: 
                            case 2: {
                                this.verticalAlignment_ = n4;
                                this.bitField0_ |= 0x10;
                                continue block27;
                            }
                        }
                        hl2.e(n3);
                        this.storeUnknownField(hl2, n2);
                        continue block27;
                    }
                    case 96: {
                        this.bitField0_ |= 0x80;
                        int n3 = hl2.i();
                        int n4 = hl2.b();
                        switch (n4) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.primaryButton_ = n4;
                                this.bitField0_ |= 0x80;
                                continue block27;
                            }
                        }
                        hl2.e(n3);
                        this.storeUnknownField(hl2, n2);
                        continue block27;
                    }
                    case 13834: {
                        if (this.internal == null) {
                            this.internal = new CardboardInternalParams();
                        }
                        hl2.a(this.internal);
                        continue block27;
                    }
                    case 1575066: 
                }
                if (this.daydreamInternal == null) {
                    this.daydreamInternal = new DaydreamInternalParams();
                }
                hl2.a(this.daydreamInternal);
            }
        }
    }
}

