/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.sdk.controller.Controller;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerServiceBridge;

public class ControllerManager {
    static final String TAG = "ControllerManager";
    private static final boolean DEBUG = false;
    private final ControllerServiceBridge serviceBridge;
    private final EventListener serviceEventListener;
    private int connectionState = 3;

    public ControllerManager(Context context, EventListener eventListener) {
        this.serviceEventListener = eventListener;
        ControllerHolder controllerHolder = new ControllerHolder(new Controller(0));
        this.serviceBridge = new ControllerServiceBridge(context, controllerHolder);
    }

    public void start() {
        this.serviceBridge.doBind();
    }

    public void stop() {
        this.serviceBridge.doUnbind();
    }

    public Controller getController() {
        return this.getController(0);
    }

    public Controller getController(int n2) {
        ControllerHolder controllerHolder = this.getControllerHolder(n2);
        if (controllerHolder == null) {
            try {
                controllerHolder = this.createAndConnectControllerHolder(n2);
            }
            catch (RemoteException remoteException) {
                Log.e((String)TAG, (String)"Exception from service while connecting controller: ", (Throwable)remoteException);
                return null;
            }
        }
        if (controllerHolder == null) {
            return null;
        }
        return controllerHolder.controller;
    }

    public void refreshAllControllers() {
        Log.i((String)TAG, (String)"Refreshing controllers.");
        this.serviceBridge.unregisterListeners();
        this.serviceBridge.clearControllers();
    }

    private ControllerHolder createAndConnectControllerHolder(int n2) throws RemoteException {
        if (this.connectionState != 0) {
            Log.e((String)TAG, (String)new StringBuilder(63).append("Failed to connect controller ").append(n2).append(", service in bad state.").toString());
            return null;
        }
        ControllerHolder controllerHolder = new ControllerHolder(new Controller(n2));
        if (!this.serviceBridge.createAndConnectController(n2, controllerHolder)) {
            Log.e((String)TAG, (String)new StringBuilder(41).append("Failed to connect controller ").append(n2).append(".").toString());
            return null;
        }
        return controllerHolder;
    }

    private ControllerHolder getControllerHolder(int n2) {
        return (ControllerHolder)this.serviceBridge.getControllerCallbacks(n2);
    }

    class ControllerHolder
    implements ControllerServiceBridge.Callbacks {
        public final Controller controller;

        public ControllerHolder(Controller controller) {
            this.controller = controller;
        }

        @Override
        public void onServiceConnected(int n2) {
            if (ControllerManager.this.connectionState != 0) {
                ControllerManager.this.connectionState = 0;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
            }
        }

        @Override
        public void onServiceDisconnected() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceDisconnected");
            if (ControllerManager.this.connectionState != 3) {
                ControllerManager.this.connectionState = 3;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        @Override
        public void onServiceUnavailable() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceUnavailable");
            if (ControllerManager.this.connectionState != 6) {
                ControllerManager.this.connectionState = 6;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        @Override
        public void onServiceFailed() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceFailed");
            if (ControllerManager.this.connectionState != 6) {
                ControllerManager.this.connectionState = 6;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        @Override
        public void onServiceInitFailed(int n2) {
            int n3;
            switch (n2) {
                case 1: {
                    n3 = 1;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 3: {
                    n3 = 5;
                    break;
                }
                default: {
                    n3 = 5;
                }
            }
            if (n3 != ControllerManager.this.connectionState) {
                ControllerManager.this.connectionState = n3;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(n3);
                ControllerManager.this.stop();
            }
        }

        @Override
        public void onControllerStateChanged(int n2, int n3) {
            this.controller.notifyConnectionStateChange(n3);
        }

        @Override
        public void onControllerEventPacket(ControllerEventPacket controllerEventPacket) {
            this.handleEventsBackwardCompatible(controllerEventPacket);
            this.controller.notifyClient();
        }

        @Override
        public void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) {
            this.controller.handleOrientationEvent(controllerOrientationEvent);
            this.controller.notifyClient();
            ControllerManager.this.serviceEventListener.onRecentered();
        }

        @Override
        public void onControllerEventPacket2(ControllerEventPacket2 controllerEventPacket2) {
            int n2;
            this.handleEventsBackwardCompatible(controllerEventPacket2);
            for (n2 = 0; n2 < controllerEventPacket2.getPositionEventCount(); ++n2) {
                this.controller.handlePositionEvent(controllerEventPacket2.getPositionEvent(n2));
            }
            for (n2 = 0; n2 < controllerEventPacket2.getTrackingStatusEventCount(); ++n2) {
                this.controller.handleTrackingStatusEvent(controllerEventPacket2.getTrackingStatusEvent(n2));
            }
            if (controllerEventPacket2.hasBatteryEvent()) {
                this.controller.handleBatteryEvent(controllerEventPacket2.getBatteryEvent());
            }
            this.controller.notifyClient();
        }

        private void handleEventsBackwardCompatible(ControllerEventPacket controllerEventPacket) {
            int n2;
            for (n2 = 0; n2 < controllerEventPacket.getButtonEventCount(); ++n2) {
                this.controller.handleButtonEvent(controllerEventPacket.getButtonEvent(n2));
            }
            for (n2 = 0; n2 < controllerEventPacket.getOrientationEventCount(); ++n2) {
                this.controller.handleOrientationEvent(controllerEventPacket.getOrientationEvent(n2));
            }
            for (n2 = 0; n2 < controllerEventPacket.getTouchEventCount(); ++n2) {
                this.controller.handleTouchEvent(controllerEventPacket.getTouchEvent(n2));
            }
        }
    }

    public static class ApiStatus {
        public static final int OK = 0;
        public static final int ERROR_UNSUPPORTED = 1;
        public static final int ERROR_NOT_AUTHORIZED = 2;
        public static final int ERROR_UNAVAILABLE = 3;
        public static final int ERROR_SERVICE_OBSOLETE = 4;
        public static final int ERROR_CLIENT_OBSOLETE = 5;
        public static final int ERROR_MALFUNCTION = 6;

        private ApiStatus() {
        }

        public static final String toString(int n2) {
            switch (n2) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "ERROR_UNSUPPORTED";
                }
                case 2: {
                    return "ERROR_NOT_AUTHORIZED";
                }
                case 3: {
                    return "ERROR_UNAVAILABLE";
                }
                case 4: {
                    return "ERROR_SERVICE_OBSOLETE";
                }
                case 5: {
                    return "ERROR_CLIENT_OBSOLETE";
                }
                case 6: {
                    return "ERROR_MALFUNCTION";
                }
            }
            return new StringBuilder(58).append("[UNKNOWN CONTROLLER MANAGER CONNECTION STATE: ").append(n2).append("]").toString();
        }
    }

    public static interface EventListener {
        public void onApiStatusChanged(int var1);

        public void onRecentered();
    }
}

