/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import android.graphics.PointF;
import android.opengl.Matrix;
import android.util.Log;
import com.google.vr.sdk.controller.Orientation;
import com.google.vr.vrcore.controller.api.ControllerBatteryEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerPositionEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;
import com.google.vr.vrcore.controller.api.ControllerTrackingStatusEvent;

public class Controller {
    private static final String TAG = "Controller";
    private static final boolean DEBUG = false;
    public long timestamp = 0L;
    public final Orientation orientation = new Orientation();
    public final float[] position = new float[3];
    public int trackingStatusFlags = 0;
    public boolean isTouching;
    public final PointF touch = new PointF();
    public boolean clickButtonState;
    public boolean appButtonState;
    public boolean homeButtonState;
    public boolean triggerButtonState;
    public boolean gripButtonState;
    public boolean volumeUpButtonState;
    public boolean volumeDownButtonState;
    public int batteryLevelBucket;
    public boolean isCharging;
    private final int controllerId;
    private final Object controllerStateLock = new Object();
    private final Controller currentControllerState;
    private EventListener controllerEventListener = new EventListener();
    private final Orientation controllerPoseInSensorSpace = new Orientation();
    private Orientation startFromSensorTransformation = new Orientation();

    Controller(int n2) {
        this(n2, new Controller(-1, null));
    }

    private Controller(int n2, Controller controller) {
        this.controllerId = n2;
        this.currentControllerState = controller;
    }

    public int getControllerId() {
        return this.controllerId;
    }

    public void setEventListener(EventListener eventListener) {
        this.controllerEventListener = eventListener;
    }

    public float[] getTransform(float[] fArray) {
        this.orientation.toAxisAngle(fArray);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.translateM((float[])fArray, (int)0, (float)this.position[0], (float)this.position[1], (float)this.position[2]);
        Matrix.rotateM((float[])fArray, (int)0, (float)f5, (float)f2, (float)f3, (float)f4);
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.controllerStateLock;
        synchronized (object) {
            if (this.timestamp == this.currentControllerState.timestamp) {
                return;
            }
            this.timestamp = this.currentControllerState.timestamp;
            this.orientation.w = this.currentControllerState.orientation.w;
            this.orientation.x = this.currentControllerState.orientation.x;
            this.orientation.y = this.currentControllerState.orientation.y;
            this.orientation.z = this.currentControllerState.orientation.z;
            this.isTouching = this.currentControllerState.isTouching;
            this.touch.x = this.currentControllerState.touch.x;
            this.touch.y = this.currentControllerState.touch.y;
            System.arraycopy(this.currentControllerState.position, 0, this.position, 0, this.position.length);
            this.trackingStatusFlags = this.currentControllerState.trackingStatusFlags;
            this.appButtonState = this.currentControllerState.appButtonState;
            this.homeButtonState = this.currentControllerState.homeButtonState;
            this.clickButtonState = this.currentControllerState.clickButtonState;
            this.triggerButtonState = this.currentControllerState.triggerButtonState;
            this.gripButtonState = this.currentControllerState.gripButtonState;
            this.volumeDownButtonState = this.currentControllerState.volumeDownButtonState;
            this.volumeUpButtonState = this.currentControllerState.volumeUpButtonState;
            this.isCharging = this.currentControllerState.isCharging;
            this.batteryLevelBucket = this.currentControllerState.batteryLevelBucket;
            return;
        }
    }

    void notifyConnectionStateChange(int n2) {
        this.controllerEventListener.onConnectionStateChanged(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTouchEvent(ControllerTouchEvent controllerTouchEvent) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = controllerTouchEvent.timestampNanos;
            this.currentControllerState.touch.x = controllerTouchEvent.x;
            this.currentControllerState.touch.y = controllerTouchEvent.y;
            switch (controllerTouchEvent.action) {
                case 1: 
                case 2: {
                    this.currentControllerState.isTouching = true;
                    break;
                }
                case 0: 
                case 3: 
                case 4: {
                    this.currentControllerState.isTouching = false;
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)String.format(".handleTouchEvent didn't handle %d", controllerTouchEvent.action));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOrientationEvent(ControllerOrientationEvent controllerOrientationEvent) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = controllerOrientationEvent.timestampNanos;
            this.currentControllerState.setOrientationInSensorSpace(controllerOrientationEvent.qx, controllerOrientationEvent.qy, controllerOrientationEvent.qz, controllerOrientationEvent.qw);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleButtonEvent(ControllerButtonEvent controllerButtonEvent) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = controllerButtonEvent.timestampNanos;
            switch (controllerButtonEvent.button) {
                case 3: {
                    this.currentControllerState.appButtonState = controllerButtonEvent.down;
                    break;
                }
                case 1: {
                    this.currentControllerState.clickButtonState = controllerButtonEvent.down;
                    break;
                }
                case 2: {
                    this.currentControllerState.homeButtonState = controllerButtonEvent.down;
                    break;
                }
                case 7: {
                    this.currentControllerState.triggerButtonState = controllerButtonEvent.down;
                    break;
                }
                case 8: {
                    this.currentControllerState.gripButtonState = controllerButtonEvent.down;
                    break;
                }
                case 5: {
                    this.currentControllerState.volumeUpButtonState = controllerButtonEvent.down;
                    break;
                }
                case 6: {
                    this.currentControllerState.volumeDownButtonState = controllerButtonEvent.down;
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)String.format("handleButtonEvent didn't handle %d", controllerButtonEvent.button));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePositionEvent(ControllerPositionEvent controllerPositionEvent) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = controllerPositionEvent.timestampNanos;
            this.currentControllerState.position[0] = controllerPositionEvent.x;
            this.currentControllerState.position[1] = controllerPositionEvent.y;
            this.currentControllerState.position[2] = controllerPositionEvent.z;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTrackingStatusEvent(ControllerTrackingStatusEvent controllerTrackingStatusEvent) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = controllerTrackingStatusEvent.timestampNanos;
            this.currentControllerState.trackingStatusFlags = controllerTrackingStatusEvent.trackingStatusFlags;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBatteryEvent(ControllerBatteryEvent controllerBatteryEvent) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.isCharging = controllerBatteryEvent.charging;
            switch (controllerBatteryEvent.batteryLevelBucket) {
                case 0: {
                    this.currentControllerState.batteryLevelBucket = 0;
                    break;
                }
                case 1: {
                    this.currentControllerState.batteryLevelBucket = 1;
                    break;
                }
                case 2: {
                    this.currentControllerState.batteryLevelBucket = 2;
                    break;
                }
                case 3: {
                    this.currentControllerState.batteryLevelBucket = 3;
                    break;
                }
                case 4: {
                    this.currentControllerState.batteryLevelBucket = 4;
                    break;
                }
                case 5: {
                    this.currentControllerState.batteryLevelBucket = 5;
                    break;
                }
                default: {
                    this.currentControllerState.batteryLevelBucket = 0;
                }
            }
            return;
        }
    }

    void notifyClient() {
        this.controllerEventListener.onUpdate();
    }

    private void setOrientationInSensorSpace(float f2, float f3, float f4, float f5) {
        this.controllerPoseInSensorSpace.set(f2, f3, f4, f5);
        this.orientation.set(this.startFromSensorTransformation);
        this.orientation.multiply(this.controllerPoseInSensorSpace);
    }

    public static class BetaTrackingStatusFlags {
        public static final int UNKNOWN = 1;
        public static final int NOMINAL = 2;
        public static final int OCCLUDED = 4;
        public static final int OUT_OF_FOV = 8;

        public BetaTrackingStatusFlags() {
        }
    }

    public static class BatteryLevels {
        public static final int UNKNOWN = 0;
        public static final int CRITICAL_LOW = 1;
        public static final int LOW = 2;
        public static final int MEDIUM = 3;
        public static final int ALMOST_FULL = 4;
        public static final int FULL = 5;

        public BatteryLevels() {
        }

        public static final String toString(int n2) {
            switch (n2) {
                case 0: {
                    return "UNKNOWN";
                }
                case 1: {
                    return "CRITICAL_LOW";
                }
                case 2: {
                    return "LOW";
                }
                case 3: {
                    return "MEDIUM";
                }
                case 4: {
                    return "ALMOST_FULL";
                }
                case 5: {
                    return "FULL";
                }
            }
            return new StringBuilder(36).append("[UNKNOWN BATTERY LEVEL: ").append(n2).append("]").toString();
        }
    }

    public static class ConnectionStates {
        public static final int DISCONNECTED = 0;
        public static final int SCANNING = 1;
        public static final int CONNECTING = 2;
        public static final int CONNECTED = 3;

        private ConnectionStates() {
        }

        public static final String toString(int n2) {
            switch (n2) {
                case 0: {
                    return "DISCONNECTED";
                }
                case 1: {
                    return "SCANNING";
                }
                case 2: {
                    return "CONNECTING";
                }
                case 3: {
                    return "CONNECTED";
                }
            }
            return new StringBuilder(39).append("[UNKNOWN CONTROLLER STATE: ").append(n2).append("]").toString();
        }
    }

    public static class EventListener {
        public EventListener() {
        }

        public void onConnectionStateChanged(int n2) {
        }

        public void onUpdate() {
        }
    }
}

