/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base.sensors.internal;

public class Vector3d {
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double d2, double d3, double d4) {
        this.set(d2, d3, d4);
    }

    public void set(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public void setComponent(int n2, double d2) {
        if (n2 == 0) {
            this.x = d2;
            return;
        }
        if (n2 == 1) {
            this.y = d2;
            return;
        }
        this.z = d2;
    }

    public void setZero() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public void set(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public void scale(double d2) {
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
    }

    public void normalize() {
        double d2 = this.length();
        if (d2 != 0.0) {
            this.scale(1.0 / d2);
        }
    }

    public static double dot(Vector3d vector3d, Vector3d vector3d2) {
        return vector3d.x * vector3d2.x + vector3d.y * vector3d2.y + vector3d.z * vector3d2.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public boolean sameValues(Vector3d vector3d) {
        return this.x == vector3d.x && this.y == vector3d.y && this.z == vector3d.z;
    }

    public static void add(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        vector3d3.set(vector3d.x + vector3d2.x, vector3d.y + vector3d2.y, vector3d.z + vector3d2.z);
    }

    public static void sub(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        vector3d3.set(vector3d.x - vector3d2.x, vector3d.y - vector3d2.y, vector3d.z - vector3d2.z);
    }

    public static void cross(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        vector3d3.set(vector3d.y * vector3d2.z - vector3d.z * vector3d2.y, vector3d.z * vector3d2.x - vector3d.x * vector3d2.z, vector3d.x * vector3d2.y - vector3d.y * vector3d2.x);
    }

    public static void ortho(Vector3d vector3d, Vector3d vector3d2) {
        int n2 = Vector3d.largestAbsComponent(vector3d) - 1;
        if (n2 < 0) {
            n2 = 2;
        }
        vector3d2.setZero();
        vector3d2.setComponent(n2, 1.0);
        Vector3d.cross(vector3d, vector3d2, vector3d2);
        vector3d2.normalize();
    }

    public String toString() {
        return String.format("%+05f %+05f %+05f", this.x, this.y, this.z);
    }

    public static int largestAbsComponent(Vector3d vector3d) {
        double d2 = Math.abs(vector3d.x);
        double d3 = Math.abs(vector3d.y);
        double d4 = Math.abs(vector3d.z);
        if (d2 > d3) {
            if (d2 > d4) {
                return 0;
            }
            return 2;
        }
        if (d3 > d4) {
            return 1;
        }
        return 2;
    }

    public double maxNorm() {
        return Math.max(Math.abs(this.x), Math.max(Math.abs(this.y), Math.abs(this.z)));
    }
}

