/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base.sensors.internal;

import com.google.vr.sdk.base.sensors.internal.LowPassFilter;
import com.google.vr.sdk.base.sensors.internal.Vector3d;

public class GyroscopeBiasEstimator {
    private static final float ACCEL_LOWPASS_FREQ = 1.0f;
    private static final float GYRO_LOWPASS_FREQ = 10.0f;
    private static final float GYRO_BIAS_LOWPASS_FREQ = 0.15f;
    private static final int NUM_GYRO_BIAS_SAMPLES_THRESHOLD = 30;
    private static final int NUM_GYRO_BIAS_SAMPLES_INITIAL_SMOOTHING = 100;
    private LowPassFilter accelLowPass;
    private LowPassFilter gyroLowPass;
    private LowPassFilter gyroBiasLowPass;
    private static final float ACCEL_DIFF_STATIC_THRESHOLD = 0.5f;
    private static final float GYRO_DIFF_STATIC_THRESHOLD = 0.008f;
    private Vector3d smoothedGyroDiff;
    private Vector3d smoothedAccelDiff;
    private static final float GYRO_FOR_BIAS_THRESHOLD = 0.35f;
    private static final int IS_STATIC_NUM_FRAMES_THRESHOLD = 10;
    private IsStaticCounter isAccelStatic;
    private IsStaticCounter isGyroStatic;

    public GyroscopeBiasEstimator() {
        this.reset();
    }

    public void reset() {
        this.smoothedGyroDiff = new Vector3d();
        this.smoothedAccelDiff = new Vector3d();
        this.accelLowPass = new LowPassFilter(1.0);
        this.gyroLowPass = new LowPassFilter(10.0);
        this.gyroBiasLowPass = new LowPassFilter(0.15f);
        this.isAccelStatic = new IsStaticCounter(10);
        this.isGyroStatic = new IsStaticCounter(10);
    }

    public void processGyroscope(Vector3d vector3d, long l2) {
        this.gyroLowPass.addSample(vector3d, l2);
        Vector3d.sub(vector3d, this.gyroLowPass.getFilteredData(), this.smoothedGyroDiff);
        this.isGyroStatic.appendFrame(this.smoothedGyroDiff.length() < (double)0.008f);
        if (this.isGyroStatic.isRecentlyStatic() && this.isAccelStatic.isRecentlyStatic()) {
            this.updateGyroBias(vector3d, l2);
        }
    }

    public void processAccelerometer(Vector3d vector3d, long l2) {
        this.accelLowPass.addSample(vector3d, l2);
        Vector3d.sub(vector3d, this.accelLowPass.getFilteredData(), this.smoothedAccelDiff);
        this.isAccelStatic.appendFrame(this.smoothedAccelDiff.length() < 0.5);
    }

    public void getGyroBias(Vector3d vector3d) {
        if (this.gyroBiasLowPass.getNumSamples() < 30) {
            vector3d.setZero();
            return;
        }
        vector3d.set(this.gyroBiasLowPass.getFilteredData());
        double d2 = Math.min(1.0, (double)(this.gyroBiasLowPass.getNumSamples() - 30) / 100.0);
        vector3d.scale(d2);
    }

    private void updateGyroBias(Vector3d vector3d, long l2) {
        if (vector3d.length() >= (double)0.35f) {
            return;
        }
        double d2 = Math.max(0.0, 1.0 - vector3d.length() / (double)0.35f);
        d2 *= d2;
        this.gyroBiasLowPass.addWeightedSample(this.gyroLowPass.getFilteredData(), l2, d2);
    }

    static class IsStaticCounter {
        private final int minStaticFrames;
        private int consecutiveIsStatic;

        IsStaticCounter(int n2) {
            this.minStaticFrames = n2;
        }

        void appendFrame(boolean bl2) {
            if (!bl2) {
                this.consecutiveIsStatic = 0;
                return;
            }
            ++this.consecutiveIsStatic;
        }

        boolean isRecentlyStatic() {
            return this.consecutiveIsStatic >= this.minStaticFrames;
        }
    }
}

