/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.opengl.GLES20;
import com.google.vr.cardboard.UsedByNative;

@UsedByNative
public class Viewport {
    public int x;
    public int y;
    public int width;
    public int height;

    public Viewport() {
    }

    @UsedByNative
    public void setViewport(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public void setGLViewport() {
        GLES20.glViewport((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    public void setGLScissor() {
        GLES20.glScissor((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    public void getAsArray(int[] nArray, int n2) {
        if (n2 + 4 > nArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        nArray[n2] = this.x;
        nArray[n2 + 1] = this.y;
        nArray[n2 + 2] = this.width;
        nArray[n2 + 3] = this.height;
    }

    public String toString() {
        int n2 = this.x;
        StringBuilder stringBuilder = new StringBuilder("{\n").append(new StringBuilder(18).append("  x: ").append(n2).append(",\n").toString());
        n2 = this.y;
        StringBuilder stringBuilder2 = stringBuilder.append(new StringBuilder(18).append("  y: ").append(n2).append(",\n").toString());
        n2 = this.width;
        StringBuilder stringBuilder3 = stringBuilder2.append(new StringBuilder(22).append("  width: ").append(n2).append(",\n").toString());
        n2 = this.height;
        return stringBuilder3.append(new StringBuilder(23).append("  height: ").append(n2).append(",\n").toString()).append("}").toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Viewport)) {
            return false;
        }
        Viewport viewport = (Viewport)object;
        return this.x == viewport.x && this.y == viewport.y && this.width == viewport.width && this.height == viewport.height;
    }

    public int hashCode() {
        return Integer.valueOf(this.x).hashCode() ^ Integer.valueOf(this.y).hashCode() ^ Integer.valueOf(this.width).hashCode() ^ Integer.valueOf(this.height).hashCode();
    }
}

