/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.util.DisplayMetrics;
import android.view.Display;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.sdk.proto.nano.Display;

public class ScreenParams {
    private int width;
    private int height;
    private float xMetersPerPixel;
    private float yMetersPerPixel;
    private float borderSizeMeters;

    public ScreenParams(Display display) {
        DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscape(display);
        this.xMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(displayMetrics.xdpi);
        this.yMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(displayMetrics.ydpi);
        this.width = displayMetrics.widthPixels;
        this.height = displayMetrics.heightPixels;
        this.borderSizeMeters = DisplayUtils.getBorderSizeMeters(null);
        if (this.height > this.width) {
            int n2 = this.width;
            this.width = this.height;
            this.height = n2;
            float f2 = this.xMetersPerPixel;
            this.xMetersPerPixel = this.yMetersPerPixel;
            this.yMetersPerPixel = f2;
        }
    }

    public static ScreenParams fromProto(Display display, Display.DisplayParams displayParams) {
        if (displayParams == null) {
            return null;
        }
        ScreenParams screenParams = new ScreenParams(display);
        if (displayParams.hasXPpi()) {
            screenParams.xMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(displayParams.getXPpi());
        }
        if (displayParams.hasYPpi()) {
            screenParams.yMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(displayParams.getYPpi());
        }
        screenParams.borderSizeMeters = DisplayUtils.getBorderSizeMeters(displayParams);
        return screenParams;
    }

    public ScreenParams(ScreenParams screenParams) {
        this.width = screenParams.width;
        this.height = screenParams.height;
        this.xMetersPerPixel = screenParams.xMetersPerPixel;
        this.yMetersPerPixel = screenParams.yMetersPerPixel;
        this.borderSizeMeters = screenParams.borderSizeMeters;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public float getWidthMeters() {
        return (float)this.width * this.xMetersPerPixel;
    }

    public float getHeightMeters() {
        return (float)this.height * this.yMetersPerPixel;
    }

    public void setBorderSizeMeters(float f2) {
        this.borderSizeMeters = f2;
    }

    public float getBorderSizeMeters() {
        return this.borderSizeMeters;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ScreenParams)) {
            return false;
        }
        ScreenParams screenParams = (ScreenParams)object;
        return this.width == screenParams.width && this.height == screenParams.height && this.xMetersPerPixel == screenParams.xMetersPerPixel && this.yMetersPerPixel == screenParams.yMetersPerPixel && this.borderSizeMeters == screenParams.borderSizeMeters;
    }

    public String toString() {
        int n2 = this.width;
        StringBuilder stringBuilder = new StringBuilder("{\n").append(new StringBuilder(22).append("  width: ").append(n2).append(",\n").toString());
        n2 = this.height;
        float f2 = this.xMetersPerPixel;
        StringBuilder stringBuilder2 = stringBuilder.append(new StringBuilder(23).append("  height: ").append(n2).append(",\n").toString()).append(new StringBuilder(39).append("  x_meters_per_pixel: ").append(f2).append(",\n").toString());
        f2 = this.yMetersPerPixel;
        StringBuilder stringBuilder3 = stringBuilder2.append(new StringBuilder(39).append("  y_meters_per_pixel: ").append(f2).append(",\n").toString());
        f2 = this.borderSizeMeters;
        return stringBuilder3.append(new StringBuilder(39).append("  border_size_meters: ").append(f2).append(",\n").toString()).append("}").toString();
    }
}

