/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.opengl.Matrix;
import com.google.vr.cardboard.UsedByNative;

@UsedByNative
public class HeadTransform {
    private static final float GIMBAL_LOCK_EPSILON = 0.01f;
    private final float[] headView = new float[16];

    public HeadTransform() {
        Matrix.setIdentityM((float[])this.headView, (int)0);
    }

    @UsedByNative
    public float[] getHeadView() {
        return this.headView;
    }

    public void getHeadView(float[] fArray, int n2) {
        if (n2 + 16 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        System.arraycopy(this.headView, 0, fArray, n2, 16);
    }

    public void getForwardVector(float[] fArray, int n2) {
        if (n2 + 3 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray[i2 + n2] = -this.headView[2 + (i2 << 2)];
        }
    }

    public void getUpVector(float[] fArray, int n2) {
        if (n2 + 3 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray[i2 + n2] = this.headView[1 + (i2 << 2)];
        }
    }

    public void getRightVector(float[] fArray, int n2) {
        if (n2 + 3 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray[i2 + n2] = this.headView[i2 << 2];
        }
    }

    public void getQuaternion(float[] fArray, int n2) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        if (n2 + 4 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        float[] fArray2 = this.headView;
        float f7 = this.headView[0] + fArray2[5] + fArray2[10];
        if (f6 >= 0.0f) {
            float f8 = (float)Math.sqrt(f7 + 1.0f);
            f5 = 0.5f * f8;
            f8 = 0.5f / f8;
            f4 = (fArray2[9] - fArray2[6]) * f8;
            f3 = (fArray2[2] - fArray2[8]) * f8;
            f2 = (fArray2[4] - fArray2[1]) * f8;
        } else if (fArray2[0] > fArray2[5] && fArray2[0] > fArray2[10]) {
            float f9 = (float)Math.sqrt(1.0f + fArray2[0] - fArray2[5] - fArray2[10]);
            f4 = f9 * 0.5f;
            f9 = 0.5f / f9;
            f3 = (fArray2[4] + fArray2[1]) * f9;
            f2 = (fArray2[2] + fArray2[8]) * f9;
            f5 = (fArray2[9] - fArray2[6]) * f9;
        } else if (fArray2[5] > fArray2[10]) {
            float f10 = (float)Math.sqrt(1.0f + fArray2[5] - fArray2[0] - fArray2[10]);
            f3 = f10 * 0.5f;
            f10 = 0.5f / f10;
            f4 = (fArray2[4] + fArray2[1]) * f10;
            f2 = (fArray2[9] + fArray2[6]) * f10;
            f5 = (fArray2[2] - fArray2[8]) * f10;
        } else {
            float f11 = (float)Math.sqrt(1.0f + fArray2[10] - fArray2[0] - fArray2[5]);
            f2 = f11 * 0.5f;
            f11 = 0.5f / f11;
            f4 = (fArray2[2] + fArray2[8]) * f11;
            f3 = (fArray2[9] + fArray2[6]) * f11;
            f5 = (fArray2[4] - fArray2[1]) * f11;
        }
        fArray[n2] = f4;
        fArray[n2 + 1] = f3;
        fArray[n2 + 2] = f2;
        fArray[n2 + 3] = f5;
    }

    public void getEulerAngles(float[] fArray, int n2) {
        float f2;
        float f3;
        if (n2 + 3 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        float f4 = (float)Math.asin(this.headView[6]);
        if (Math.sqrt(1.0f - this.headView[6] * this.headView[6]) >= (double)0.01f) {
            f3 = (float)Math.atan2(-this.headView[2], this.headView[10]);
            f2 = (float)Math.atan2(-this.headView[4], this.headView[5]);
        } else {
            f3 = 0.0f;
            f2 = (float)Math.atan2(this.headView[1], this.headView[0]);
        }
        fArray[n2] = -f4;
        fArray[n2 + 1] = -f3;
        fArray[n2 + 2] = -f2;
    }

    public void getTranslation(float[] fArray, int n2) {
        if (n2 + 3 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray[i2 + n2] = this.headView[i2 + 12];
        }
    }
}

