/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.util.Base64;
import android.util.Log;
import com.google.vr.cardboard.ConfigUtils;
import com.google.vr.sdk.base.Distortion;
import com.google.vr.sdk.base.FieldOfView;
import com.google.vr.sdk.base.ScreenParams;
import com.google.vr.sdk.deps.hu;
import com.google.vr.sdk.proto.CardboardDevice;
import com.google.vr.sdk.proto.nano.CardboardDevice;

public class GvrViewerParams {
    private static final String TAG = "GvrViewerParams";
    private static final String HTTP_SCHEME = "http";
    private static final String URI_HOST_GOOGLE_SHORT = "g.co";
    private static final String URI_HOST_GOOGLE = "google.com";
    private static final String URI_PATH_CARDBOARD_HOME = "cardboard";
    private static final String URI_PATH_CARDBOARD_CONFIG = "cardboard/cfg";
    private static final String URI_SCHEME_LEGACY_CARDBOARD = "cardboard";
    private static final String URI_HOST_LEGACY_CARDBOARD = "v1.0.0";
    private static final Uri URI_ORIGINAL_CARDBOARD_NFC = new Uri.Builder().scheme("cardboard").authority("v1.0.0").build();
    private static final Uri URI_ORIGINAL_CARDBOARD_QR_CODE = new Uri.Builder().scheme("http").authority("g.co").appendEncodedPath("cardboard").build();
    private static final String DEFAULT_VENDOR = "Google, Inc.";
    private static final String DEFAULT_MODEL = "Default Cardboard";
    private static final String CARDBOARD_V2_2_VENDOR = "Google";
    private static final String CARDBOARD_V2_2_MODEL = "Cardboard";
    private static final float CARDBOARD_V2_2_INTER_LENS_DISTANCE = 0.064f;
    private static final VerticalAlignmentType CARDBOARD_V2_2_VERTICAL_ALIGNMENT = VerticalAlignmentType.BOTTOM;
    private static final float CARDBOARD_V2_2_VERTICAL_DISTANCE_TO_LENS_CENTER = 0.035f;
    private static final float CARDBOARD_V2_2_SCREEN_TO_LENS_DISTANCE = 0.039f;
    private static final String CARDBOARD_V1_VENDOR = "Google, Inc.";
    private static final String CARDBOARD_V1_MODEL = "Cardboard v1";
    private static final float CARDBOARD_V1_INTER_LENS_DISTANCE = 0.06f;
    private static final VerticalAlignmentType CARDBOARD_V1_VERTICAL_ALIGNMENT = VerticalAlignmentType.BOTTOM;
    private static final float CARDBOARD_V1_VERTICAL_DISTANCE_TO_LENS_CENTER = 0.035f;
    private static final float CARDBOARD_V1_SCREEN_TO_LENS_DISTANCE = 0.042f;
    private static final GvrViewerParams DEFAULT_PARAMS = new GvrViewerParams();
    private String vendor;
    private String model;
    private float interLensDistance;
    private VerticalAlignmentType verticalAlignment;
    private float verticalDistanceToLensCenter;
    private float screenToLensDistance;
    private FieldOfView leftEyeMaxFov;
    private boolean hasMagnet;
    private Distortion distortion;
    private CardboardDevice.DeviceParams originalDeviceProto;

    public GvrViewerParams() {
        this.setDefaultValues();
    }

    public GvrViewerParams(GvrViewerParams gvrViewerParams) {
        this.copyFrom(gvrViewerParams);
    }

    public GvrViewerParams(CardboardDevice.DeviceParams deviceParams) {
        this.setDefaultValues();
        if (deviceParams == null) {
            return;
        }
        this.originalDeviceProto = deviceParams.clone();
        this.vendor = deviceParams.getVendor();
        this.model = deviceParams.getModel();
        this.interLensDistance = deviceParams.getInterLensDistance();
        this.verticalAlignment = VerticalAlignmentType.fromProtoValue(deviceParams.getVerticalAlignment());
        this.verticalDistanceToLensCenter = deviceParams.getTrayToLensDistance();
        this.screenToLensDistance = deviceParams.getScreenToLensDistance();
        this.leftEyeMaxFov = FieldOfView.parseFromProtobuf(deviceParams.leftEyeFieldOfViewAngles);
        if (this.leftEyeMaxFov == null) {
            this.leftEyeMaxFov = new FieldOfView();
        }
        this.distortion = Distortion.parseFromProtobuf(deviceParams.distortionCoefficients);
        if (this.distortion == null) {
            this.distortion = new Distortion();
        }
        this.hasMagnet = deviceParams.getHasMagnet();
    }

    public static boolean isOriginalCardboardDeviceUri(Uri uri) {
        return URI_ORIGINAL_CARDBOARD_QR_CODE.equals((Object)uri) || URI_ORIGINAL_CARDBOARD_NFC.getScheme().equals(uri.getScheme()) && URI_ORIGINAL_CARDBOARD_NFC.getAuthority().equals(uri.getAuthority());
    }

    private static boolean isCardboardDeviceUri(Uri uri) {
        return HTTP_SCHEME.equals(uri.getScheme()) && URI_HOST_GOOGLE.equals(uri.getAuthority()) && "/cardboard/cfg".equals(uri.getPath());
    }

    public static boolean isGvrUri(Uri uri) {
        return GvrViewerParams.isOriginalCardboardDeviceUri(uri) || GvrViewerParams.isCardboardDeviceUri(uri);
    }

    public static GvrViewerParams createFromUri(Uri uri) {
        if (uri == null) {
            return null;
        }
        if (GvrViewerParams.isOriginalCardboardDeviceUri(uri)) {
            return GvrViewerParams.cardboardV1ViewerParams();
        }
        if (!GvrViewerParams.isCardboardDeviceUri(uri)) {
            Log.w((String)TAG, (String)String.format("URI \"%s\" not recognized as GVR viewer.", uri));
            return null;
        }
        return new GvrViewerParams(ConfigUtils.readDeviceParamsFromUri(uri));
    }

    public static GvrViewerParams cardboardV1ViewerParams() {
        GvrViewerParams gvrViewerParams = new GvrViewerParams();
        new GvrViewerParams().vendor = "Google, Inc.";
        gvrViewerParams.model = CARDBOARD_V1_MODEL;
        gvrViewerParams.interLensDistance = 0.06f;
        gvrViewerParams.verticalAlignment = CARDBOARD_V1_VERTICAL_ALIGNMENT;
        gvrViewerParams.verticalDistanceToLensCenter = 0.035f;
        gvrViewerParams.screenToLensDistance = 0.042f;
        gvrViewerParams.leftEyeMaxFov = FieldOfView.cardboardV1FieldOfView();
        gvrViewerParams.hasMagnet = true;
        gvrViewerParams.distortion = Distortion.cardboardV1Distortion();
        return gvrViewerParams;
    }

    public static GvrViewerParams cardboardV2ViewerParams() {
        GvrViewerParams gvrViewerParams = new GvrViewerParams();
        gvrViewerParams.setToCardboardV2ViewerParams();
        return gvrViewerParams;
    }

    public static GvrViewerParams createFromNfcContents(NdefMessage ndefMessage) {
        if (ndefMessage == null) {
            Log.w((String)TAG, (String)"Could not get contents from NFC tag.");
            return null;
        }
        for (NdefRecord ndefRecord : ndefMessage.getRecords()) {
            GvrViewerParams gvrViewerParams = GvrViewerParams.createFromUri(ndefRecord.toUri());
            if (gvrViewerParams == null) continue;
            return gvrViewerParams;
        }
        return null;
    }

    byte[] toByteArray() {
        return hu.toByteArray(this.toProtobuf());
    }

    public CardboardDevice.DeviceParams toProtobuf() {
        CardboardDevice.DeviceParams deviceParams = this.originalDeviceProto != null ? this.originalDeviceProto.clone() : new CardboardDevice.DeviceParams();
        deviceParams.setVendor(this.vendor);
        deviceParams.setModel(this.model);
        deviceParams.setInterLensDistance(this.interLensDistance);
        deviceParams.setVerticalAlignment(this.verticalAlignment.toProtoValue());
        if (this.verticalAlignment == VerticalAlignmentType.CENTER) {
            deviceParams.setTrayToLensDistance(0.035f);
        } else {
            deviceParams.setTrayToLensDistance(this.verticalDistanceToLensCenter);
        }
        deviceParams.setScreenToLensDistance(this.screenToLensDistance);
        deviceParams.leftEyeFieldOfViewAngles = this.leftEyeMaxFov.toProtobuf();
        deviceParams.distortionCoefficients = this.distortion.toProtobuf();
        if (this.hasMagnet) {
            deviceParams.setHasMagnet(this.hasMagnet);
        }
        return deviceParams;
    }

    public Uri toUri() {
        byte[] byArray = this.toByteArray();
        int n2 = byArray.length;
        return new Uri.Builder().scheme(HTTP_SCHEME).authority(URI_HOST_GOOGLE).appendEncodedPath(URI_PATH_CARDBOARD_CONFIG).appendQueryParameter("p", Base64.encodeToString((byte[])byArray, (int)0, (int)n2, (int)11)).build();
    }

    public void setVendor(String string2) {
        this.vendor = string2 != null ? string2 : "";
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setModel(String string2) {
        this.model = string2 != null ? string2 : "";
    }

    public String getModel() {
        return this.model;
    }

    public void setInterLensDistance(float f2) {
        this.interLensDistance = f2;
    }

    public float getInterLensDistance() {
        return this.interLensDistance;
    }

    public VerticalAlignmentType getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignmentType verticalAlignmentType) {
        this.verticalAlignment = verticalAlignmentType;
    }

    public void setVerticalDistanceToLensCenter(float f2) {
        this.verticalDistanceToLensCenter = f2;
    }

    public float getVerticalDistanceToLensCenter() {
        return this.verticalDistanceToLensCenter;
    }

    float getYEyeOffsetMeters(ScreenParams screenParams) {
        switch (this.getVerticalAlignment().ordinal()) {
            default: {
                return screenParams.getHeightMeters() / 2.0f;
            }
            case 0: {
                return this.getVerticalDistanceToLensCenter() - screenParams.getBorderSizeMeters();
            }
            case 2: 
        }
        return screenParams.getHeightMeters() - (this.getVerticalDistanceToLensCenter() - screenParams.getBorderSizeMeters());
    }

    public void setScreenToLensDistance(float f2) {
        this.screenToLensDistance = f2;
    }

    public float getScreenToLensDistance() {
        return this.screenToLensDistance;
    }

    public Distortion getDistortion() {
        return this.distortion;
    }

    public FieldOfView getLeftEyeMaxFov() {
        return this.leftEyeMaxFov;
    }

    public boolean getHasMagnet() {
        return this.hasMagnet;
    }

    public void setHasMagnet(boolean bl2) {
        this.hasMagnet = bl2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof GvrViewerParams)) {
            return false;
        }
        GvrViewerParams gvrViewerParams = (GvrViewerParams)object;
        boolean bl2 = this.vendor.equals(gvrViewerParams.vendor) && this.model.equals(gvrViewerParams.model) && this.interLensDistance == gvrViewerParams.interLensDistance && this.verticalAlignment == gvrViewerParams.verticalAlignment && (this.verticalAlignment == VerticalAlignmentType.CENTER || this.verticalDistanceToLensCenter == gvrViewerParams.verticalDistanceToLensCenter) && this.screenToLensDistance == gvrViewerParams.screenToLensDistance && this.leftEyeMaxFov.equals(gvrViewerParams.leftEyeMaxFov) && this.distortion.equals(gvrViewerParams.distortion) && this.hasMagnet == gvrViewerParams.hasMagnet;
        if (!bl2) {
            return false;
        }
        return hu.messageNanoEquals(this.originalDeviceProto, gvrViewerParams.originalDeviceProto);
    }

    public String toString() {
        String string2 = this.vendor;
        StringBuilder stringBuilder = new StringBuilder("{\n").append(new StringBuilder(12 + String.valueOf(string2).length()).append("  vendor: ").append(string2).append(",\n").toString());
        string2 = this.model;
        float f2 = this.interLensDistance;
        String string3 = String.valueOf((Object)this.verticalAlignment);
        float f3 = this.verticalDistanceToLensCenter;
        StringBuilder stringBuilder2 = stringBuilder.append(new StringBuilder(11 + String.valueOf(string2).length()).append("  model: ").append(string2).append(",\n").toString()).append(new StringBuilder(40).append("  inter_lens_distance: ").append(f2).append(",\n").toString()).append(new StringBuilder(24 + String.valueOf(string3).length()).append("  vertical_alignment: ").append(string3).append(",\n").toString()).append(new StringBuilder(53).append("  vertical_distance_to_lens_center: ").append(f3).append(",\n").toString());
        f3 = this.screenToLensDistance;
        String string4 = this.leftEyeMaxFov.toString().replace("\n", "\n  ");
        StringBuilder stringBuilder3 = stringBuilder2.append(new StringBuilder(44).append("  screen_to_lens_distance: ").append(f3).append(",\n").toString()).append(new StringBuilder(22 + String.valueOf(string4).length()).append("  left_eye_max_fov: ").append(string4).append(",\n").toString());
        string4 = this.distortion.toString().replace("\n", "\n  ");
        boolean bl2 = this.hasMagnet;
        return stringBuilder3.append(new StringBuilder(16 + String.valueOf(string4).length()).append("  distortion: ").append(string4).append(",\n").toString()).append(new StringBuilder(17).append("  magnet: ").append(bl2).append(",\n").toString()).append("}\n").toString();
    }

    public boolean isDefault() {
        return DEFAULT_PARAMS.equals(this);
    }

    private void setDefaultValues() {
        this.setToCardboardV2ViewerParams();
        this.vendor = "Google, Inc.";
        this.model = DEFAULT_MODEL;
    }

    private void setToCardboardV2ViewerParams() {
        this.vendor = CARDBOARD_V2_2_VENDOR;
        this.model = CARDBOARD_V2_2_MODEL;
        this.interLensDistance = 0.064f;
        this.verticalAlignment = CARDBOARD_V2_2_VERTICAL_ALIGNMENT;
        this.verticalDistanceToLensCenter = 0.035f;
        this.screenToLensDistance = 0.039f;
        this.leftEyeMaxFov = new FieldOfView();
        this.hasMagnet = false;
        this.distortion = new Distortion();
    }

    private void copyFrom(GvrViewerParams gvrViewerParams) {
        this.vendor = gvrViewerParams.vendor;
        this.model = gvrViewerParams.model;
        this.interLensDistance = gvrViewerParams.interLensDistance;
        this.verticalAlignment = gvrViewerParams.verticalAlignment;
        this.verticalDistanceToLensCenter = gvrViewerParams.verticalDistanceToLensCenter;
        this.screenToLensDistance = gvrViewerParams.screenToLensDistance;
        this.leftEyeMaxFov = new FieldOfView(gvrViewerParams.leftEyeMaxFov);
        this.hasMagnet = gvrViewerParams.hasMagnet;
        this.distortion = new Distortion(gvrViewerParams.distortion);
        this.originalDeviceProto = gvrViewerParams.originalDeviceProto;
    }

    public static enum VerticalAlignmentType {
        BOTTOM(CardboardDevice.DeviceParams.VerticalAlignmentType.BOTTOM),
        CENTER(CardboardDevice.DeviceParams.VerticalAlignmentType.CENTER),
        TOP(CardboardDevice.DeviceParams.VerticalAlignmentType.TOP);

        private final CardboardDevice.DeviceParams.VerticalAlignmentType protoValue;

        private VerticalAlignmentType(CardboardDevice.DeviceParams.VerticalAlignmentType verticalAlignmentType) {
            this.protoValue = verticalAlignmentType;
        }

        final CardboardDevice.DeviceParams.VerticalAlignmentType toProtoValue() {
            return this.protoValue;
        }

        static VerticalAlignmentType fromProtoValue(CardboardDevice.DeviceParams.VerticalAlignmentType verticalAlignmentType) {
            for (VerticalAlignmentType verticalAlignmentType2 : VerticalAlignmentType.values()) {
                if (verticalAlignmentType2.protoValue != verticalAlignmentType) continue;
                return verticalAlignmentType2;
            }
            Log.e((String)GvrViewerParams.TAG, (String)String.format("Unknown alignment type from proto: %d", verticalAlignmentType.getNumber()));
            return BOTTOM;
        }
    }
}

