/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.opengl.Matrix;

public class FieldOfView {
    private static final float CARDBOARD_V2_2_MAX_FOV_LEFT_RIGHT = 60.0f;
    private static final float CARDBOARD_V2_2_MAX_FOV_BOTTOM = 60.0f;
    private static final float CARDBOARD_V2_2_MAX_FOV_TOP = 60.0f;
    private static final float CARDBOARD_V1_MAX_FOV_LEFT_RIGHT = 40.0f;
    private static final float CARDBOARD_V1_MAX_FOV_BOTTOM = 40.0f;
    private static final float CARDBOARD_V1_MAX_FOV_TOP = 40.0f;
    private float left;
    private float right;
    private float bottom;
    private float top;

    public FieldOfView() {
        this.left = 60.0f;
        this.right = 60.0f;
        this.bottom = 60.0f;
        this.top = 60.0f;
    }

    public static FieldOfView cardboardV1FieldOfView() {
        FieldOfView fieldOfView = new FieldOfView();
        fieldOfView.setAngles(40.0f, 40.0f, 40.0f, 40.0f);
        return fieldOfView;
    }

    public FieldOfView(float f2, float f3, float f4, float f5) {
        this.setAngles(f2, f3, f4, f5);
    }

    public FieldOfView(FieldOfView fieldOfView) {
        this.copy(fieldOfView);
    }

    public static FieldOfView parseFromProtobuf(float[] fArray) {
        if (fArray.length != 4) {
            return null;
        }
        return new FieldOfView(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public float[] toProtobuf() {
        return new float[]{this.left, this.right, this.bottom, this.top};
    }

    public void copy(FieldOfView fieldOfView) {
        this.left = fieldOfView.left;
        this.right = fieldOfView.right;
        this.bottom = fieldOfView.bottom;
        this.top = fieldOfView.top;
    }

    public void setAngles(float f2, float f3, float f4, float f5) {
        this.left = f2;
        this.right = f3;
        this.bottom = f4;
        this.top = f5;
    }

    public void setLeft(float f2) {
        this.left = f2;
    }

    public float getLeft() {
        return this.left;
    }

    public void setRight(float f2) {
        this.right = f2;
    }

    public float getRight() {
        return this.right;
    }

    public void setBottom(float f2) {
        this.bottom = f2;
    }

    public float getBottom() {
        return this.bottom;
    }

    public void setTop(float f2) {
        this.top = f2;
    }

    public float getTop() {
        return this.top;
    }

    public void toPerspectiveMatrix(float f2, float f3, float[] fArray, int n2) {
        if (n2 + 16 > fArray.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        float f4 = (float)(-Math.tan(Math.toRadians(this.left))) * f2;
        float f5 = (float)Math.tan(Math.toRadians(this.right)) * f2;
        float f6 = (float)(-Math.tan(Math.toRadians(this.bottom))) * f2;
        float f7 = (float)Math.tan(Math.toRadians(this.top)) * f2;
        Matrix.frustumM((float[])fArray, (int)n2, (float)f4, (float)f5, (float)f6, (float)f7, (float)f2, (float)f3);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FieldOfView)) {
            return false;
        }
        FieldOfView fieldOfView = (FieldOfView)object;
        return this.left == fieldOfView.left && this.right == fieldOfView.right && this.bottom == fieldOfView.bottom && this.top == fieldOfView.top;
    }

    public String toString() {
        float f2 = this.left;
        StringBuilder stringBuilder = new StringBuilder("{\n").append(new StringBuilder(25).append("  left: ").append(f2).append(",\n").toString());
        f2 = this.right;
        StringBuilder stringBuilder2 = stringBuilder.append(new StringBuilder(26).append("  right: ").append(f2).append(",\n").toString());
        f2 = this.bottom;
        StringBuilder stringBuilder3 = stringBuilder2.append(new StringBuilder(27).append("  bottom: ").append(f2).append(",\n").toString());
        f2 = this.top;
        return stringBuilder3.append(new StringBuilder(24).append("  top: ").append(f2).append(",\n").toString()).append("}").toString();
    }
}

