/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import com.google.vr.cardboard.UsedByNative;
import com.google.vr.sdk.base.FieldOfView;
import com.google.vr.sdk.base.Viewport;

@UsedByNative
public class Eye {
    private final int type;
    private final float[] eyeView;
    private final Viewport viewport;
    private final FieldOfView fov;
    private volatile boolean projectionChanged;
    private float[] perspective;
    private float lastZNear;
    private float lastZFar;

    @UsedByNative
    public Eye(int n2) {
        this.type = n2;
        this.eyeView = new float[16];
        this.viewport = new Viewport();
        this.fov = new FieldOfView();
        this.projectionChanged = true;
    }

    public int getType() {
        return this.type;
    }

    @UsedByNative
    public float[] getEyeView() {
        return this.eyeView;
    }

    public float[] getPerspective(float f2, float f3) {
        if (!this.projectionChanged && this.lastZNear == f2 && this.lastZFar == f3) {
            return this.perspective;
        }
        if (this.perspective == null) {
            this.perspective = new float[16];
        }
        this.getFov().toPerspectiveMatrix(f2, f3, this.perspective, 0);
        this.lastZNear = f2;
        this.lastZFar = f3;
        this.projectionChanged = false;
        return this.perspective;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public FieldOfView getFov() {
        return this.fov;
    }

    public void setProjectionChanged() {
        this.projectionChanged = true;
    }

    public boolean getProjectionChanged() {
        return this.projectionChanged;
    }

    @UsedByNative
    private void setValues(int n2, int n3, int n4, int n5, float f2, float f3, float f4, float f5) {
        this.viewport.setViewport(n2, n3, n4, n5);
        this.fov.setAngles(f2, f3, f4, f5);
        this.projectionChanged = true;
    }

    public static abstract class Type {
        public static final int MONOCULAR = 0;
        public static final int LEFT = 1;
        public static final int RIGHT = 2;

        public Type() {
        }
    }
}

