/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import java.util.Arrays;

public class Distortion {
    private static final float[] CARDBOARD_V2_2_COEFFICIENTS = new float[]{0.34f, 0.55f};
    private static final float[] CARDBOARD_V1_COEFFICIENTS = new float[]{0.441f, 0.156f};
    private float[] coefficients;

    public static Distortion cardboardV1Distortion() {
        Distortion distortion = new Distortion();
        new Distortion().coefficients = (float[])CARDBOARD_V1_COEFFICIENTS.clone();
        return distortion;
    }

    public Distortion() {
        this.coefficients = (float[])CARDBOARD_V2_2_COEFFICIENTS.clone();
    }

    public Distortion(Distortion distortion) {
        this.setCoefficients(distortion.coefficients);
    }

    public static Distortion parseFromProtobuf(float[] fArray) {
        Distortion distortion = new Distortion();
        distortion.setCoefficients(fArray);
        return distortion;
    }

    public float[] toProtobuf() {
        return (float[])this.coefficients.clone();
    }

    public void setCoefficients(float[] fArray) {
        this.coefficients = fArray != null ? (float[])fArray.clone() : new float[]{};
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }

    public float distortionFactor(float f2) {
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = f2 * f2;
        float[] fArray = this.coefficients;
        int n2 = this.coefficients.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f6 = fArray[i2];
            f3 += f6 * (f4 *= f5);
        }
        return f3;
    }

    public float distort(float f2) {
        return f2 * this.distortionFactor(f2);
    }

    public float distortInverse(float f2) {
        float f3 = f2 / 0.9f;
        float f4 = f2 * 0.9f;
        float f5 = f2 - this.distort(f3);
        while ((double)Math.abs(f4 - f3) > 1.0E-4) {
            float f6 = f2 - this.distort(f4);
            float f7 = f4 - f6 * ((f4 - f3) / (f6 - f5));
            f3 = f4;
            f4 = f7;
            f5 = f6;
        }
        return f4;
    }

    private static double[] solveLinear(double[][] dArray, double[] dArray2) {
        int n2;
        double d2;
        int n3;
        int n4 = dArray[0].length;
        for (int i2 = 0; i2 < n4 - 1; ++i2) {
            n3 = i2 + 1;
            while (n3 < n4) {
                d2 = dArray[n3][i2] / dArray[i2][i2];
                for (n2 = i2 + 1; n2 < n4; ++n2) {
                    double[] dArray3 = dArray[n3];
                    int n5 = n2;
                    dArray3[n5] = dArray3[n5] - d2 * dArray[i2][n2];
                }
                int n6 = n3++;
                dArray2[n6] = dArray2[n6] - d2 * dArray2[i2];
            }
        }
        double[] dArray4 = new double[n4];
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            d2 = dArray2[n3];
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                d2 -= dArray[n3][n2] * dArray4[n2];
            }
            dArray4[n3] = d2 / dArray[n3][n3];
        }
        return dArray4;
    }

    private static double[] solveLeastSquares(double[][] dArray, double[] dArray2) {
        int n2;
        double d2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        double[][] dArray3 = new double[n5][n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            for (n3 = 0; n3 < n5; ++n3) {
                d2 = 0.0;
                for (n2 = 0; n2 < n4; ++n2) {
                    d2 += dArray[n2][n3] * dArray[n2][i2];
                }
                dArray3[n3][i2] = d2;
            }
        }
        double[] dArray4 = new double[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            d2 = 0.0;
            for (n2 = 0; n2 < n4; ++n2) {
                d2 += dArray[n2][n3] * dArray2[n2];
            }
            dArray4[n3] = d2;
        }
        return Distortion.solveLinear(dArray3, dArray4);
    }

    public Distortion getApproximateInverseDistortion(float f2, int n2) {
        double[][] dArray = new double[100][n2];
        double[] dArray2 = new double[100];
        for (int i2 = 0; i2 < 100; ++i2) {
            double d2;
            float f3 = f2 * (float)(i2 + 1) / 100.0f;
            double d3 = d2 = (double)this.distort(f3);
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i2][i3] = d3 *= d2 * d2;
            }
            dArray2[i2] = (double)f3 - d2;
        }
        double[] dArray3 = Distortion.solveLeastSquares(dArray, dArray2);
        float[] fArray = new float[dArray3.length];
        for (int i4 = 0; i4 < dArray3.length; ++i4) {
            fArray[i4] = (float)dArray3[i4];
        }
        Distortion distortion = new Distortion();
        distortion.setCoefficients(fArray);
        return distortion;
    }

    @Deprecated
    public Distortion getApproximateInverseDistortion(float f2) {
        return this.getApproximateInverseDistortion(f2, 2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Distortion)) {
            return false;
        }
        Distortion distortion = (Distortion)object;
        return Arrays.equals(this.coefficients, distortion.coefficients);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{\n").append("  coefficients: [");
        for (int i2 = 0; i2 < this.coefficients.length; ++i2) {
            stringBuilder.append(Float.toString(this.coefficients[i2]));
            if (i2 >= this.coefficients.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("],\n}");
        return stringBuilder.toString();
    }
}

