/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.audio;

import android.content.Context;

public class GvrAudioEngine {
    public static final int INVALID_ID = -1;
    private static UnsatisfiedLinkError nativeLibraryLoadException;
    private final long vrAudioSystemRef;

    public GvrAudioEngine(Context context, int n2) {
        if (nativeLibraryLoadException != null) {
            throw nativeLibraryLoadException;
        }
        this.vrAudioSystemRef = this.nativeInitialize(this.getClass().getClassLoader(), context.getApplicationContext(), n2);
    }

    private native long nativeInitialize(ClassLoader var1, Context var2, int var3);

    protected void finalize() throws Throwable {
        try {
            this.nativeRelease(this.vrAudioSystemRef);
            return;
        }
        finally {
            super.finalize();
        }
    }

    private native void nativeRelease(long var1);

    public void update() {
        this.nativeUpdate(this.vrAudioSystemRef);
    }

    private native void nativeUpdate(long var1);

    public void pause() {
        this.nativePause(this.vrAudioSystemRef);
    }

    private native void nativePause(long var1);

    public void resume() {
        this.nativeResume(this.vrAudioSystemRef);
    }

    private native void nativeResume(long var1);

    public boolean preloadSoundFile(String string) {
        return this.nativePreloadSoundFile(this.vrAudioSystemRef, string);
    }

    private native boolean nativePreloadSoundFile(long var1, String var3);

    public void unloadSoundFile(String string) {
        this.nativeUnloadSoundFile(this.vrAudioSystemRef, string);
    }

    private native void nativeUnloadSoundFile(long var1, String var3);

    public int createSoundObject(String string) {
        return this.nativeCreateSoundObject(this.vrAudioSystemRef, string);
    }

    private native int nativeCreateSoundObject(long var1, String var3);

    public int createSoundfield(String string) {
        return this.nativeCreateSoundfield(this.vrAudioSystemRef, string);
    }

    private native int nativeCreateSoundfield(long var1, String var3);

    public int createStereoSound(String string) {
        return this.nativeCreateStereoSound(this.vrAudioSystemRef, string);
    }

    private native int nativeCreateStereoSound(long var1, String var3);

    public void playSound(int n2, boolean bl2) {
        this.nativePlaySound(this.vrAudioSystemRef, n2, bl2);
    }

    private native void nativePlaySound(long var1, int var3, boolean var4);

    public void pauseSound(int n2) {
        this.nativePauseSound(this.vrAudioSystemRef, n2);
    }

    private native void nativePauseSound(long var1, int var3);

    public void resumeSound(int n2) {
        this.nativeResumeSound(this.vrAudioSystemRef, n2);
    }

    private native void nativeResumeSound(long var1, int var3);

    public void stopSound(int n2) {
        this.nativeStopSound(this.vrAudioSystemRef, n2);
    }

    private native void nativeStopSound(long var1, int var3);

    public boolean isSoundPlaying(int n2) {
        return this.nativeIsSoundPlaying(this.vrAudioSystemRef, n2);
    }

    private native boolean nativeIsSoundPlaying(long var1, int var3);

    public boolean isSourceIdValid(int n2) {
        return this.nativeIsSourceIdValid(this.vrAudioSystemRef, n2);
    }

    private native boolean nativeIsSourceIdValid(long var1, int var3);

    public void setSoundObjectPosition(int n2, float f2, float f3, float f4) {
        this.nativeSetSoundObjectPosition(this.vrAudioSystemRef, n2, f2, f3, f4);
    }

    private native void nativeSetSoundObjectPosition(long var1, int var3, float var4, float var5, float var6);

    public void setSoundObjectDistanceRolloffModel(int n2, int n3, float f2, float f3) {
        this.nativeSetSoundObjectDistanceRolloffModel(this.vrAudioSystemRef, n2, n3, f2, f3);
    }

    private native void nativeSetSoundObjectDistanceRolloffModel(long var1, int var3, int var4, float var5, float var6);

    public void setSoundfieldRotation(int n2, float f2, float f3, float f4, float f5) {
        this.nativeSetSoundfieldRotation(this.vrAudioSystemRef, n2, f2, f3, f4, f5);
    }

    private native void nativeSetSoundfieldRotation(long var1, int var3, float var4, float var5, float var6, float var7);

    public void setSoundVolume(int n2, float f2) {
        this.nativeSetSoundVolume(this.vrAudioSystemRef, n2, f2);
    }

    private native void nativeSetSoundVolume(long var1, int var3, float var4);

    public void setHeadPosition(float f2, float f3, float f4) {
        this.nativeSetHeadPosition(this.vrAudioSystemRef, f2, f3, f4);
    }

    private native void nativeSetHeadPosition(long var1, float var3, float var4, float var5);

    public void setHeadRotation(float f2, float f3, float f4, float f5) {
        this.nativeSetHeadRotation(this.vrAudioSystemRef, f2, f3, f4, f5);
    }

    private native void nativeSetHeadRotation(long var1, float var3, float var4, float var5, float var6);

    public void enableRoom(boolean bl2) {
        this.nativeEnableRoom(this.vrAudioSystemRef, bl2);
    }

    private native void nativeEnableRoom(long var1, boolean var3);

    public void setRoomProperties(float f2, float f3, float f4, int n2, int n3, int n4) {
        this.nativeSetRoomProperties(this.vrAudioSystemRef, f2, f3, f4, n2, n3, n4);
    }

    private native void nativeSetRoomProperties(long var1, float var3, float var4, float var5, int var6, int var7, int var8);

    public void setRoomReverbAdjustments(float f2, float f3, float f4) {
        this.nativeSetRoomReverbAdjustments(this.vrAudioSystemRef, f2, f3, f4);
    }

    private native void nativeSetRoomReverbAdjustments(long var1, float var3, float var4, float var5);

    public void enableSpeakerStereoMode(boolean bl2) {
        this.nativeEnableStereoSpeakerMode(this.vrAudioSystemRef, bl2);
    }

    private native void nativeEnableStereoSpeakerMode(long var1, boolean var3);

    static {
        try {
            nativeLibraryLoadException = null;
            System.loadLibrary("gvr_audio");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            UnsatisfiedLinkError unsatisfiedLinkError2 = unsatisfiedLinkError;
            nativeLibraryLoadException = unsatisfiedLinkError;
        }
    }

    public static abstract class DistanceRolloffModel {
        public static final int LOGARITHMIC = 0;
        public static final int LINEAR = 1;
        public static final int NONE = 2;

        public DistanceRolloffModel() {
        }
    }

    public static abstract class MaterialName {
        public static final int TRANSPARENT = 0;
        public static final int ACOUSTIC_CEILING_TILES = 1;
        public static final int BRICK_BARE = 2;
        public static final int BRICK_PAINTED = 3;
        public static final int CONCRETE_BLOCK_COARSE = 4;
        public static final int CONCRETE_BLOCK_PAINTED = 5;
        public static final int CURTAIN_HEAVY = 6;
        public static final int FIBER_GLASS_INSULATION = 7;
        public static final int GLASS_THIN = 8;
        public static final int GLASS_THICK = 9;
        public static final int GRASS = 10;
        public static final int LINOLEUM_ON_CONCRETE = 11;
        public static final int MARBLE = 12;
        public static final int METAL = 13;
        public static final int PARQUET_ON_CONCRETE = 14;
        public static final int PLASTER_ROUGH = 15;
        public static final int PLASTER_SMOOTH = 16;
        public static final int PLYWOOD_PANEL = 17;
        public static final int POLISHED_CONCRETE_OR_TILE = 18;
        public static final int SHEET_ROCK = 19;
        public static final int WATER_OR_ICE_SURFACE = 20;
        public static final int WOOD_CEILING = 21;
        public static final int WOOD_PANEL = 22;

        public MaterialName() {
        }
    }

    public static abstract class RenderingMode {
        public static final int STEREO_PANNING = 0;
        public static final int BINAURAL_LOW_QUALITY = 1;
        public static final int BINAURAL_HIGH_QUALITY = 2;

        public RenderingMode() {
        }
    }
}

