/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.UiLayer;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;
import com.google.vr.ndk.base.GvrUiLayoutImpl$$Lambda$0;
import com.google.vr.ndk.base.GvrUiLayoutImpl$$Lambda$1;
import com.google.vr.ndk.base.GvrUiLayoutImpl$$Lambda$2;
import com.google.vr.vrcore.library.api.IGvrUiLayout;
import com.google.vr.vrcore.library.api.IObjectWrapper;
import com.google.vr.vrcore.library.api.ObjectWrapper;

class GvrUiLayoutImpl
extends IGvrUiLayout.Stub {
    private static final String TAG = "GvrUiLayoutImpl";
    private static final boolean DEBUG = false;
    static final long FADE_TRANSITION_VIEW_DELAY_MILLIS = 100L;
    static final float MIN_FADE_ALPHA = 0.2f;
    private ObjectAnimator uiLayerDimmingAnimation;
    private final Runnable delayDimmingUiLayerAfterVisibleRunnable = new GvrUiLayoutImpl$$Lambda$0(this);
    private final Runnable beginDimmingUiLayerRunnable = new GvrUiLayoutImpl$$Lambda$1(this);
    private static final float DAYDREAM_ALIGNMENT_MARKER_SCALE = 0.35f;
    private final UiLayer uiLayer;
    private final CloseButtonListenerWrapper closeButtonListener;
    private boolean daydreamModeEnabled = false;

    GvrUiLayoutImpl(Context context, Runnable runnable) {
        this(context, runnable, new DaydreamUtilsWrapper());
    }

    GvrUiLayoutImpl(Context context, Runnable runnable, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        this.closeButtonListener = new CloseButtonListenerWrapper(context, runnable, daydreamUtilsWrapper);
        this.uiLayer = new UiLayer(context);
        this.uiLayer.setBackButtonListener(this.closeButtonListener);
    }

    @Override
    public void setEnabled(boolean bl2) {
        this.uiLayer.setEnabled(bl2);
    }

    @Override
    public IObjectWrapper getRootView() {
        return ObjectWrapper.wrap(this.uiLayer.getView());
    }

    @Override
    public boolean isEnabled() {
        return this.uiLayer.isEnabled();
    }

    @Override
    public void setCloseButtonListener(IObjectWrapper iObjectWrapper) {
        Runnable runnable = iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null;
        this.closeButtonListener.setClientCloseButtonListener(runnable);
    }

    @Override
    public void setTransitionViewEnabled(boolean bl2) {
        this.uiLayer.setTransitionViewEnabled(bl2 && !this.daydreamModeEnabled);
    }

    @Override
    public void setTransitionViewListener(IObjectWrapper iObjectWrapper) {
        this.uiLayer.setTransitionViewListener(iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null);
    }

    @Override
    public void setSettingsButtonEnabled(boolean bl2) {
        this.uiLayer.setSettingsButtonEnabled(bl2);
    }

    @Override
    public void setSettingsButtonListener(IObjectWrapper iObjectWrapper) {
        this.uiLayer.setSettingsButtonListener(iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null);
    }

    @Override
    public void setViewerName(String string2) {
        this.uiLayer.setViewerName(string2);
    }

    UiLayer getUiLayer() {
        return this.uiLayer;
    }

    ViewGroup getRoot() {
        return this.uiLayer.getView();
    }

    void invokeCloseButtonListener() {
        this.closeButtonListener.run();
    }

    void setDaydreamModeEnabled(boolean bl2) {
        if (this.daydreamModeEnabled == bl2) {
            return;
        }
        this.daydreamModeEnabled = bl2;
        if (bl2) {
            this.uiLayer.setAlignmentMarkerScale(0.35f);
            this.uiLayer.setTransitionViewEnabled(false);
            return;
        }
        this.uiLayer.setAlignmentMarkerScale(1.0f);
    }

    boolean isDaydreamModeEnabled() {
        return this.daydreamModeEnabled;
    }

    private void delayDimmingUiLayer(long l2) {
        this.cancelDimmingUiLayer();
        this.getRoot().postDelayed(this.beginDimmingUiLayerRunnable, l2);
    }

    void delayDimmingUiLayerAfterVisible() {
        this.delayDimmingUiLayer(2500L);
    }

    private void beginDimmingUiLayer() {
        this.cancelDimmingUiLayer();
        if (this.uiLayer.isTransitionViewVisible()) {
            this.getRoot().postDelayed(this.delayDimmingUiLayerAfterVisibleRunnable, 100L);
            return;
        }
        this.uiLayerDimmingAnimation = ObjectAnimator.ofFloat((Object)this.uiLayer.getView(), (Property)View.ALPHA, (float[])new float[]{1.0f, 0.2f});
        this.uiLayerDimmingAnimation.setDuration(500L);
        this.uiLayerDimmingAnimation.start();
        this.setDimmedUiTouchOverride();
    }

    private void setDimmedUiTouchOverride() {
        this.uiLayer.setButtonClickCallbackOverride(new GvrUiLayoutImpl$$Lambda$2(this));
    }

    void cancelDimmingUiLayer() {
        this.getRoot().removeCallbacks(this.beginDimmingUiLayerRunnable);
        if (this.uiLayerDimmingAnimation != null) {
            this.uiLayerDimmingAnimation.cancel();
            this.uiLayerDimmingAnimation = null;
        }
        this.uiLayer.getView().setAlpha(1.0f);
        this.uiLayer.setButtonClickCallbackOverride(null);
    }

    private static Runnable createDefaultCloseButtonListener(final Context context, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        final Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.setFlags(0x10000000);
        final Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return new Runnable(){

                @Override
                public void run() {
                    context.startActivity(intent);
                }
            };
        }
        if (daydreamUtilsWrapper.isDaydreamActivity(activity)) {
            return new Runnable(){

                @Override
                public void run() {
                    activity.startActivity(intent);
                    activity.finish();
                }
            };
        }
        return new Runnable(){

            @Override
            public void run() {
                activity.onBackPressed();
            }
        };
    }

    final /* synthetic */ void lambda$setDimmedUiTouchOverride$0$GvrUiLayoutImpl() {
        this.delayDimmingUiLayer(5000L);
    }

    final /* synthetic */ void bridge$lambda$0$GvrUiLayoutImpl() {
        this.beginDimmingUiLayer();
    }

    static class CloseButtonListenerWrapper
    implements Runnable {
        private final Context context;
        private final Runnable defaultCloseButtonListener;
        private final Runnable passiveCloseButtonListener;
        private Runnable activeCloseButtonListener;
        private boolean invokingCloseButton = false;

        CloseButtonListenerWrapper(Context context, Runnable runnable, DaydreamUtilsWrapper daydreamUtilsWrapper) {
            this.context = context;
            this.passiveCloseButtonListener = runnable;
            this.activeCloseButtonListener = this.defaultCloseButtonListener = GvrUiLayoutImpl.createDefaultCloseButtonListener(context, daydreamUtilsWrapper);
        }

        @Override
        public void run() {
            if (this.invokingCloseButton) {
                Log.w((String)GvrUiLayoutImpl.TAG, (String)"GVR close behavior invoked recursively.");
                Activity activity = ContextUtils.getActivity(this.context);
                if (activity != null) {
                    activity.finish();
                }
                return;
            }
            Log.d((String)GvrUiLayoutImpl.TAG, (String)"GVR close behavior invoked.");
            this.invokingCloseButton = true;
            try {
                if (this.passiveCloseButtonListener != null) {
                    this.passiveCloseButtonListener.run();
                }
                if (this.activeCloseButtonListener != null) {
                    this.activeCloseButtonListener.run();
                }
                return;
            }
            finally {
                this.invokingCloseButton = false;
            }
        }

        public void setClientCloseButtonListener(Runnable runnable) {
            this.activeCloseButtonListener = runnable != null ? runnable : this.defaultCloseButtonListener;
        }
    }
}

