/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.util.Log;
import com.google.vr.ndk.base.DaydreamCompatibility;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import java.util.List;

public class DaydreamUtils {
    private static final String TAG = "DaydreamUtils";
    static final String INTENT_CATEGORY_DAYDREAM = "com.google.intent.category.DAYDREAM";
    static final String INTENT_CATEGORY_CARDBOARD = "com.google.intent.category.CARDBOARD";
    static final String INTENT_CATEGORY_DAYDREAM_CONTROLLER_OPTIONAL = "com.google.intent.category.DAYDREAM_CONTROLLER_OPTIONAL";
    private static boolean sDaydreamPhoneOverrideForTesting;

    public static boolean isDaydreamPhone(Context context) {
        if (sDaydreamPhoneOverrideForTesting) {
            return true;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        return context.getPackageManager().hasSystemFeature("android.hardware.vr.high_performance");
    }

    public static boolean isDaydreamViewer(CardboardDevice.DeviceParams deviceParams) {
        return deviceParams != null && deviceParams.daydreamInternal != null;
    }

    public static DaydreamCompatibility getComponentDaydreamCompatibility(Context context, ComponentName componentName) {
        return DaydreamUtils.getComponentDaydreamCompatibility(context.getPackageManager(), componentName);
    }

    public static void setIsDaydreamPhoneForTesting(boolean bl2) {
        sDaydreamPhoneOverrideForTesting = bl2;
    }

    public static String getDeviceParamsDisplayedName(CardboardDevice.DeviceParams deviceParams) {
        if (deviceParams == null) {
            Log.e((String)TAG, (String)"Null params in getDeviceParamsDisplayedName");
            return "";
        }
        return DaydreamUtils.getDeviceParamsDisplayedName(deviceParams.getVendor(), deviceParams.getModel());
    }

    public static String getDeviceParamsDisplayedName(String string2, String string3) {
        if (string2 == null || string3 == null) {
            Log.e((String)TAG, (String)"Null vendor/model in getDeviceParamsDisplayedName");
            if (string3 != null) {
                return string3;
            }
            return "";
        }
        if (string2.equals("Google, Inc.") || string2.equals("Google")) {
            switch (string3) {
                case "Cardboard": {
                    return "Google Cardboard (I/O 2015)";
                }
                case "Cardboard v1": {
                    return "Google Cardboard";
                }
            }
            return string3;
        }
        return string3;
    }

    static DaydreamCompatibility getComponentDaydreamCompatibility(PackageManager packageManager, ComponentName componentName) {
        int n2 = 0;
        if (DaydreamUtils.checkHeadsetCompatibility(packageManager, componentName, INTENT_CATEGORY_DAYDREAM)) {
            n2 = 1;
        }
        if (DaydreamUtils.checkHeadsetCompatibility(packageManager, componentName, INTENT_CATEGORY_CARDBOARD)) {
            n2 |= 2;
        }
        if (DaydreamUtils.checkHeadsetCompatibility(packageManager, componentName, INTENT_CATEGORY_DAYDREAM_CONTROLLER_OPTIONAL)) {
            n2 |= 4;
        }
        return new DaydreamCompatibility(n2);
    }

    private static boolean checkHeadsetCompatibility(PackageManager packageManager, ComponentName componentName, String string2) {
        Intent intent = new Intent();
        intent.setPackage(componentName.getPackageName());
        intent.addCategory(string2);
        return DaydreamUtils.canResolveIntent(packageManager, componentName, intent);
    }

    private static boolean canResolveIntent(PackageManager packageManager, ComponentName componentName, Intent intent) {
        List list = packageManager.queryIntentActivities(intent, 128);
        if (list != null) {
            for (ResolveInfo resolveInfo : list) {
                if (resolveInfo == null || resolveInfo.activityInfo == null || resolveInfo.activityInfo.name == null || !resolveInfo.activityInfo.name.equals(componentName.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    protected DaydreamUtils() {
    }
}

