/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import com.google.common.logging.nano.Vr;
import com.google.vr.cardboard.AndroidPCompat;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Display;

public abstract class AbstractDaydreamTouchListener {
    static final double MAX_TOUCH_DISTANCE_METERS = 0.015;
    static final int ANGLE_SAMPLE_TO_LOG = 200;
    private final String logTag = this.getClass().getSimpleName();
    private int angleSamplesReceived = 0;
    private DisplayMetrics displayMetrics;
    private float xMetersPerPixel;
    private float yMetersPerPixel;
    private float borderSizeMeters;
    private float[][] markersInPixels;
    private int mostTouchesSeen;
    private int[] touchBestMarker;
    private int[] markerBestTouch;
    private double[] currentMarkerBestDists;
    private float[] pixelTranslation = new float[2];
    private boolean lastMotionEventInHeadset;
    private boolean enabled = true;
    private float[] lastTranslation = new float[2];
    private float[] translation = new float[2];
    private float rotation;
    private boolean useRotationalAlignmentCorrection;
    private final float[] displayCutoutTranslation = new float[2];

    public AbstractDaydreamTouchListener() {
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
        if (!bl2) {
            this.resetTrackingState();
        }
    }

    public void getTranslationInScreenSpace(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Translation array too small");
        }
        if (this.displayMetrics == null) {
            Log.e((String)this.logTag, (String)"displayMetrics must be set before calling getTranslationInScreenSpace.");
            return;
        }
        fArray[0] = this.pixelTranslation[0] / (float)this.displayMetrics.widthPixels;
        fArray[1] = this.pixelTranslation[1] / (float)this.displayMetrics.heightPixels;
        fArray[0] = fArray[0] * 2.0f;
        fArray[1] = fArray[1] * -2.0f;
    }

    public Rect getBoundingRect(DisplayMetrics displayMetrics) {
        if (this.markersInPixels == null || this.markersInPixels.length == 0) {
            Log.e((String)this.logTag, (String)"No touch markers, so there's no bounding rect.");
            return null;
        }
        double d2 = 0.015 / (double)this.xMetersPerPixel;
        double d3 = 0.015 / (double)this.yMetersPerPixel;
        int n2 = displayMetrics.widthPixels;
        int n3 = 0;
        int n4 = displayMetrics.heightPixels;
        int n5 = 0;
        for (int i2 = 0; i2 < this.markersInPixels.length; ++i2) {
            float[] fArray = this.markersInPixels[i2];
            n2 = (int)Math.min((double)n2, (double)fArray[0] - d2);
            n3 = (int)Math.max((double)n3, (double)fArray[0] + d2 + 1.0);
            n4 = (int)Math.min((double)n4, (double)fArray[1] - d3);
            n5 = (int)Math.max((double)n5, (double)fArray[1] + d3 + 1.0);
        }
        n2 = Math.max(n2, 0);
        n3 = Math.min(n3, displayMetrics.widthPixels);
        n4 = Math.max(n4, 0);
        n5 = Math.min(n5, displayMetrics.heightPixels);
        return new Rect(n2, n4, n3, n5);
    }

    protected final boolean handleTouch(MotionEvent motionEvent, float f2, float f3) {
        if (!this.processMotionEvent(motionEvent, f2, f3)) {
            return false;
        }
        this.getTranslationInScreenSpace(this.translation);
        if (this.translation[0] != this.lastTranslation[0] || this.translation[1] != this.lastTranslation[1]) {
            this.lastTranslation[0] = this.translation[0];
            this.lastTranslation[1] = this.translation[1];
            this.setLensOffset(this.translation[0], this.translation[1], this.rotation);
        }
        return true;
    }

    protected final void initWithDisplayParams(DisplayMetrics displayMetrics, Display.DisplayParams displayParams, AndroidPCompat.DisplayCutoutCompat displayCutoutCompat) {
        this.displayMetrics = displayMetrics;
        this.borderSizeMeters = DisplayUtils.getBorderSizeMeters(displayParams);
        this.xMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(this.displayMetrics.xdpi);
        this.yMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(this.displayMetrics.ydpi);
        if (displayCutoutCompat != null) {
            int n2 = displayCutoutCompat.getSafeInsetLeft();
            int n3 = displayMetrics.widthPixels - displayCutoutCompat.getSafeInsetRight();
            int n4 = displayCutoutCompat.getSafeInsetTop();
            int n5 = displayMetrics.heightPixels - displayCutoutCompat.getSafeInsetBottom();
            int n6 = (n3 + n2) / 2;
            int n7 = (n5 + n4) / 2;
            this.displayCutoutTranslation[0] = n6 - displayMetrics.widthPixels / 2;
            this.displayCutoutTranslation[1] = n7 - displayMetrics.heightPixels / 2;
        } else {
            this.displayCutoutTranslation[0] = 0.0f;
            this.displayCutoutTranslation[1] = 0.0f;
        }
        this.resetTrackingState();
    }

    protected final void setDeviceParams(CardboardDevice.DeviceParams deviceParams) {
        if (deviceParams == null || deviceParams.daydreamInternal == null || deviceParams.daydreamInternal.alignmentMarkers == null) {
            Log.e((String)this.logTag, (String)"Null deviceParams or no alignment markers found.");
            this.markersInPixels = null;
            return;
        }
        if (this.displayMetrics == null) {
            Log.e((String)this.logTag, (String)"displayMetrics must be set before calling setDeviceParams.");
            return;
        }
        CardboardDevice.ScreenAlignmentMarker[] screenAlignmentMarkerArray = deviceParams.daydreamInternal.alignmentMarkers;
        this.markersInPixels = new float[screenAlignmentMarkerArray.length][];
        this.currentMarkerBestDists = new double[screenAlignmentMarkerArray.length];
        this.markerBestTouch = new int[screenAlignmentMarkerArray.length];
        for (int i2 = 0; i2 < screenAlignmentMarkerArray.length; ++i2) {
            CardboardDevice.ScreenAlignmentMarker screenAlignmentMarker = screenAlignmentMarkerArray[i2];
            this.markersInPixels[i2] = new float[2];
            this.markersInPixels[i2][0] = (float)(this.displayMetrics.widthPixels / 2) + screenAlignmentMarker.getHorizontal() / this.xMetersPerPixel;
            this.markersInPixels[i2][1] = (float)this.displayMetrics.heightPixels - (screenAlignmentMarker.getVertical() + deviceParams.getTrayToLensDistance() - this.borderSizeMeters) / this.yMetersPerPixel;
        }
        this.useRotationalAlignmentCorrection = deviceParams.daydreamInternal.getUseRotationalAlignmentCorrection();
    }

    protected abstract void logEvent(int var1, Vr.VREvent var2);

    protected abstract void setLensOffset(float var1, float var2, float var3);

    protected abstract boolean isDaydreamImageAlignmentEnabled();

    void getTranslationInPixels(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Translation array too small");
        }
        fArray[0] = this.pixelTranslation[0];
        fArray[1] = this.pixelTranslation[1];
    }

    boolean viewerNeedsTouchProcessing() {
        return this.enabled && this.markersInPixels != null && this.markersInPixels.length > 0;
    }

    boolean wasLastMotionEventInViewer() {
        return this.lastMotionEventInHeadset;
    }

    boolean processMotionEvent(MotionEvent motionEvent, float f2, float f3) {
        int n2;
        int n3;
        if (!this.viewerNeedsTouchProcessing()) {
            this.lastMotionEventInHeadset = false;
            return false;
        }
        if (!this.isDaydreamImageAlignmentEnabled()) {
            return true;
        }
        int n4 = motionEvent.getPointerCount();
        if (n4 > this.mostTouchesSeen) {
            this.touchBestMarker = new int[n4];
            this.mostTouchesSeen = n4;
        }
        for (n3 = 0; n3 < this.markersInPixels.length; ++n3) {
            this.markerBestTouch[n3] = -1;
            this.currentMarkerBestDists[n3] = 2.25E-4;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            double d2 = 2.25E-4;
            this.touchBestMarker[n3] = -1;
            for (n2 = 0; n2 < this.markersInPixels.length; ++n2) {
                double d3;
                float f4 = (this.markersInPixels[n2][0] - (motionEvent.getX(n3) + f2)) * this.xMetersPerPixel;
                float f5 = (this.markersInPixels[n2][1] - (motionEvent.getY(n3) + f3)) * this.yMetersPerPixel;
                double d4 = f4 * f4 + f5 * f5;
                if (d3 < d2) {
                    d2 = d4;
                    this.touchBestMarker[n3] = n2;
                }
                if (!(d4 < this.currentMarkerBestDists[n2])) continue;
                this.currentMarkerBestDists[n2] = d4;
                this.markerBestTouch[n2] = n3;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        int n5 = 0;
        for (n2 = 0; n2 < this.markerBestTouch.length; ++n2) {
            if (this.markerBestTouch[n2] == -1) continue;
            if (this.touchBestMarker[this.markerBestTouch[n2]] != n2) {
                this.markerBestTouch[n2] = -1;
                continue;
            }
            ++n5;
            f6 += motionEvent.getX(this.markerBestTouch[n2]) + f2 - this.markersInPixels[n2][0];
            f7 += motionEvent.getY(this.markerBestTouch[n2]) + f3 - this.markersInPixels[n2][1];
        }
        if (n5 > 0) {
            this.lastMotionEventInHeadset = true;
            this.pixelTranslation[0] = f6 / (float)n5;
            this.pixelTranslation[1] = f7 / (float)n5;
            this.pixelTranslation[0] = this.pixelTranslation[0] + this.displayCutoutTranslation[0];
            this.pixelTranslation[1] = this.pixelTranslation[1] + this.displayCutoutTranslation[1];
        } else {
            this.lastMotionEventInHeadset = false;
            this.pixelTranslation[0] = 0.0f;
            this.pixelTranslation[1] = 0.0f;
        }
        this.rotation = n5 == 2 && this.useRotationalAlignmentCorrection ? this.getRotationRadians(motionEvent) : 0.0f;
        if (n4 > 0) {
            ++this.angleSamplesReceived;
            if (this.angleSamplesReceived == 200) {
                this.logPhoneAlignment(motionEvent, f2, f3);
            }
        }
        return true;
    }

    float getRotationRadians(MotionEvent motionEvent) {
        float f2;
        if (this.markersInPixels == null || this.markersInPixels.length != 2) {
            Log.e((String)this.logTag, (String)"No touch markers or the wrong number of touch markers.");
            return 0.0f;
        }
        float f3 = motionEvent.getX(0) - motionEvent.getX(1);
        float f4 = motionEvent.getY(0) - motionEvent.getY(1);
        double d2 = Math.atan2(f4, f3);
        float f5 = this.markersInPixels[0][0] - this.markersInPixels[1][0];
        float f6 = this.markersInPixels[0][1] - this.markersInPixels[1][1];
        double d3 = Math.atan2(f6, f5);
        float f7 = (float)(d2 - d3);
        if ((double)f2 > 1.5707963267948966) {
            f7 -= (float)Math.PI;
        }
        if ((double)f7 < -1.5707963267948966) {
            f7 += (float)Math.PI;
        }
        return f7;
    }

    private void resetTrackingState() {
        this.lastMotionEventInHeadset = false;
        this.pixelTranslation[0] = 0.0f;
        this.pixelTranslation[1] = 0.0f;
        this.rotation = 0.0f;
        this.mostTouchesSeen = 0;
    }

    private void logPhoneAlignment(MotionEvent motionEvent, float f2, float f3) {
        int n2 = motionEvent.getPointerCount();
        Vr.VREvent vREvent = new Vr.VREvent();
        new Vr.VREvent().phoneAlignment = new Vr.VREvent.PhoneAlignment();
        vREvent.phoneAlignment.touchLocations = new Vr.VREvent.Vector2[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            vREvent.phoneAlignment.touchLocations[i2] = new Vr.VREvent.Vector2();
            vREvent.phoneAlignment.touchLocations[i2].x = Float.valueOf(motionEvent.getX(i2) + f2);
            vREvent.phoneAlignment.touchLocations[i2].y = Float.valueOf(motionEvent.getY(i2) + f3);
        }
        vREvent.phoneAlignment.lensOffset = new Vr.VREvent.Vector2();
        vREvent.phoneAlignment.lensOffset.x = Float.valueOf(this.pixelTranslation[0]);
        vREvent.phoneAlignment.lensOffset.y = Float.valueOf(this.pixelTranslation[1]);
        if (n2 == 2 && this.markersInPixels.length == 2) {
            double d2 = Math.toDegrees(this.getRotationRadians(motionEvent));
            vREvent.phoneAlignment.angleDegrees = Float.valueOf((float)d2);
            Log.i((String)this.logTag, (String)new StringBuilder(58).append("Phone angle in headset (degrees): ").append(d2).toString());
            float f4 = motionEvent.getX(0) + f2;
            float f5 = motionEvent.getY(0) + f3;
            Log.i((String)this.logTag, (String)new StringBuilder(49).append("  Touch point 1: ").append(f4).append(", ").append(f5).toString());
            f4 = motionEvent.getX(1) + f2;
            f5 = motionEvent.getY(1) + f3;
            Log.i((String)this.logTag, (String)new StringBuilder(49).append("  Touch point 2: ").append(f4).append(", ").append(f5).toString());
        }
        this.logEvent(2012, vREvent);
    }
}

