/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.cardboard.TransitionView;
import com.google.vr.cardboard.UiUtils;

public class UiLayer {
    private final Context context;
    private final FrameLayout rootOuterLayout;
    private View settingsButtonHolder;
    private ImageButton settingsButton;
    private View backButtonHolder;
    private ImageButton backButton;
    private RelativeLayout alignmentMarker;
    private TransitionView transitionView;
    private RelativeLayout rootInnerLayout;
    private volatile boolean isEnabled = true;
    private volatile boolean isSettingsButtonEnabled = true;
    private volatile boolean isAlignmentMarkerEnabled = true;
    private volatile Runnable buttonClickCallbackOverride = null;
    private volatile Runnable backButtonListener = null;
    private volatile Runnable settingsButtonListener;
    private volatile Runnable transitionListener = null;
    private volatile boolean transitionViewEnabled = false;
    private volatile String viewerName;
    private volatile float alignmentMarkerScale = 1.0f;
    private int currentLayoutId;

    public UiLayer(Context context) {
        this.context = context;
        this.rootOuterLayout = new RootOuterLayout(context);
        this.inflateViewsWithLayoutId(R.layout.ui_layer);
    }

    private void inflateViewsWithLayoutId(int n2) {
        this.currentLayoutId = n2;
        boolean bl2 = this.transitionView != null && this.transitionView.getParent() != null;
        this.transitionView = null;
        if (this.rootInnerLayout != null) {
            this.rootOuterLayout.removeView((View)this.rootInnerLayout);
        }
        this.rootInnerLayout = (RelativeLayout)LayoutInflater.from((Context)this.context).inflate(n2, null, false);
        this.rootOuterLayout.addView((View)this.rootInnerLayout);
        if (bl2) {
            this.setTransitionViewEnabled(this.transitionViewEnabled);
        }
        this.settingsButtonListener = new Runnable(){

            @Override
            public void run() {
                UiUtils.launchOrInstallCardboard(UiLayer.this.context);
            }
        };
        this.settingsButtonHolder = this.rootInnerLayout.findViewById(R.id.ui_settings_button_holder);
        if (this.settingsButtonHolder != null) {
            this.settingsButtonHolder.setVisibility(UiLayer.computeVisibility(this.isSettingsButtonEnabled));
            this.settingsButtonHolder.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Runnable runnable = UiLayer.this.buttonClickCallbackOverride;
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
        this.settingsButton = (ImageButton)this.rootInnerLayout.findViewById(R.id.ui_settings_button);
        this.settingsButton.setVisibility(UiLayer.computeVisibility(this.isSettingsButtonEnabled));
        this.settingsButton.setContentDescription((CharSequence)"Settings");
        this.settingsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Runnable runnable = UiLayer.this.settingsButtonListener;
                Runnable runnable2 = UiLayer.this.buttonClickCallbackOverride;
                if (runnable2 != null) {
                    runnable2.run();
                    return;
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        this.backButtonHolder = this.rootInnerLayout.findViewById(R.id.ui_back_button_holder);
        if (this.backButtonHolder != null) {
            this.backButtonHolder.setVisibility(UiLayer.computeVisibility(this.getBackButtonEnabled()));
            this.backButtonHolder.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Runnable runnable = UiLayer.this.buttonClickCallbackOverride;
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
        this.backButton = (ImageButton)this.rootInnerLayout.findViewById(R.id.ui_back_button);
        this.backButton.setVisibility(UiLayer.computeVisibility(this.getBackButtonEnabled()));
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Runnable runnable = UiLayer.this.backButtonListener;
                Runnable runnable2 = UiLayer.this.buttonClickCallbackOverride;
                if (runnable2 != null) {
                    runnable2.run();
                    return;
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        if (ActivityManager.isRunningInTestHarness()) {
            ViewGroup.LayoutParams layoutParams;
            if (this.settingsButtonHolder != null) {
                layoutParams = this.settingsButtonHolder.getLayoutParams();
                this.settingsButtonHolder.getLayoutParams().height = -2;
                layoutParams.width = -2;
                this.settingsButtonHolder.setLayoutParams(layoutParams);
            }
            if (this.backButtonHolder != null) {
                layoutParams = this.backButtonHolder.getLayoutParams();
                this.backButtonHolder.getLayoutParams().height = -2;
                layoutParams.width = -2;
                this.backButtonHolder.setLayoutParams(layoutParams);
            }
        }
        this.alignmentMarker = (RelativeLayout)this.rootInnerLayout.findViewById(R.id.ui_alignment_marker);
        this.alignmentMarker.setVisibility(UiLayer.computeVisibility(this.getAlignmentMarkerEnabled()));
        this.setAlignmentMarkerScale(this.alignmentMarkerScale);
    }

    private TransitionView getTransitionView() {
        if (this.transitionView == null) {
            this.transitionView = new TransitionView(this.context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.transitionView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.transitionView.setVisibility(UiLayer.computeVisibility(this.transitionViewEnabled));
            if (this.viewerName != null) {
                this.transitionView.setViewerName(this.viewerName);
            }
            if (this.transitionListener != null) {
                this.transitionView.setTransitionListener(this.transitionListener);
            }
            this.transitionView.setBackButtonListener(this.backButtonListener);
            this.rootInnerLayout.addView((View)this.transitionView);
        }
        return this.transitionView;
    }

    private static int computeVisibility(boolean bl2) {
        if (bl2) {
            return 0;
        }
        return 8;
    }

    public ViewGroup getView() {
        return this.rootOuterLayout;
    }

    public void setEnabled(final boolean bl2) {
        this.isEnabled = bl2;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.rootOuterLayout.setVisibility(UiLayer.computeVisibility(bl2));
            }
        });
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setSettingsButtonEnabled(final boolean bl2) {
        this.isSettingsButtonEnabled = bl2;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.settingsButton.setVisibility(UiLayer.computeVisibility(bl2));
                if (UiLayer.this.settingsButtonHolder != null) {
                    UiLayer.this.settingsButtonHolder.setVisibility(UiLayer.computeVisibility(bl2));
                }
            }
        });
    }

    public void setButtonClickCallbackOverride(Runnable runnable) {
        this.buttonClickCallbackOverride = runnable;
    }

    public void setSettingsButtonListener(Runnable runnable) {
        this.settingsButtonListener = runnable;
    }

    public void setBackButtonListener(final Runnable runnable) {
        this.backButtonListener = runnable;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                boolean bl2 = runnable != null;
                UiLayer.this.backButton.setVisibility(UiLayer.computeVisibility(bl2));
                if (UiLayer.this.backButtonHolder != null) {
                    UiLayer.this.backButtonHolder.setVisibility(UiLayer.computeVisibility(bl2));
                }
                if (UiLayer.this.transitionView != null) {
                    UiLayer.this.transitionView.setBackButtonListener(runnable);
                }
            }
        });
    }

    @TargetApi(value=23)
    public static void scaleAlignmentMarkerLayoutParams(Context context, float f2, RelativeLayout.LayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        int n2 = (int)context.getResources().getDimension(R.dimen.alignment_marker_height);
        int n3 = (int)((float)n2 * f2);
        if (layoutParams.getRule(15) == -1) {
            layoutParams.width = n3;
            return;
        }
        layoutParams.height = n3;
    }

    @TargetApi(value=23)
    public void setAlignmentMarkerScale(final float f2) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (this.alignmentMarkerScale == f2 && f2 == 1.0f) {
            return;
        }
        this.alignmentMarkerScale = f2;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)UiLayer.this.alignmentMarker.getLayoutParams();
                UiLayer.scaleAlignmentMarkerLayoutParams(UiLayer.this.context, f2, layoutParams);
                UiLayer.this.alignmentMarker.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
    }

    public void setTransitionViewEnabled(final boolean bl2) {
        this.transitionViewEnabled = bl2;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!bl2 && UiLayer.this.transitionView == null) {
                    return;
                }
                UiLayer.this.getTransitionView().setVisibility(UiLayer.computeVisibility(bl2));
            }
        });
    }

    public boolean isTransitionViewVisible() {
        return this.transitionView != null && this.transitionView.getVisibility() == 0;
    }

    public void setTransitionViewListener(final Runnable runnable) {
        this.transitionListener = runnable;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (runnable == null && UiLayer.this.transitionView == null) {
                    return;
                }
                UiLayer.this.getTransitionView().setTransitionListener(runnable);
            }
        });
    }

    public void setViewerName(final String string2) {
        this.viewerName = string2;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (UiLayer.this.transitionView != null) {
                    UiLayer.this.transitionView.setViewerName(string2);
                }
            }
        });
    }

    public boolean getBackButtonEnabled() {
        return this.backButtonListener != null;
    }

    public boolean getAlignmentMarkerEnabled() {
        return this.isAlignmentMarkerEnabled;
    }

    class RootOuterLayout
    extends FrameLayout {
        private Configuration currentConfig;

        RootOuterLayout(Context context) {
            super(context);
            this.currentConfig = new Configuration(context.getResources().getConfiguration());
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.handlePotentialConfigurationChange(UiLayer.this.context.getResources().getConfiguration());
        }

        public void onConfigurationChanged(Configuration configuration) {
            super.onConfigurationChanged(configuration);
            this.handlePotentialConfigurationChange(configuration);
        }

        private void handlePotentialConfigurationChange(Configuration configuration) {
            int n2 = configuration.diff(this.currentConfig);
            if ((n2 & 0x1000) != 0 || (n2 & 0x80) != 0) {
                Log.d((String)"UiLayer", (String)"Re-inflating UiLayer due to configuration change.");
                this.currentConfig = new Configuration(configuration);
                UiLayer.this.inflateViewsWithLayoutId(UiLayer.this.currentLayoutId);
            }
        }
    }
}

