/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.graphics.Point;
import android.opengl.GLSurfaceView;
import android.os.Process;
import com.google.vr.cardboard.AndroidNCompat;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class ScanlineRacingRenderer
implements GLSurfaceView.Renderer {
    private final GvrApi gvrApi;
    private GvrSurfaceView gvrSurfaceView;

    public ScanlineRacingRenderer(GvrApi gvrApi) {
        if (gvrApi == null) {
            throw new IllegalArgumentException("GvrApi must be supplied for proper scanline rendering");
        }
        this.gvrApi = gvrApi;
    }

    public void setSurfaceView(GvrSurfaceView gvrSurfaceView) {
        if (gvrSurfaceView == null) {
            throw new IllegalArgumentException("GvrSurfaceView must be supplied for proper scanline rendering");
        }
        this.gvrSurfaceView = gvrSurfaceView;
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        Thread.currentThread().setPriority(10);
        AndroidNCompat.setVrThread(Process.myTid());
        this.gvrApi.onSurfaceCreatedReprojectionThread();
    }

    public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
        this.gvrApi.onSurfaceChangedReprojectionThread();
    }

    public void onDrawFrame(GL10 gL10) {
        Point point = this.gvrApi.renderReprojectionThread();
        if (point != null) {
            this.setSurfaceSize(point.x, point.y);
        }
    }

    public void onSurfaceDestroyed() {
        this.onPause();
    }

    public void setSurfaceSize(final int n2, final int n3) {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (n2 > 0 && n3 > 0) {
                    ScanlineRacingRenderer.this.gvrSurfaceView.getHolder().setFixedSize(n2, n3);
                    return;
                }
                ScanlineRacingRenderer.this.gvrSurfaceView.getHolder().setSizeFromLayout();
            }
        });
    }

    public void onPause() {
        this.gvrApi.onPauseReprojectionThread();
    }
}

