/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import com.google.common.logging.nano.Vr;
import com.google.vr.cardboard.ConfigUtils;
import com.google.vr.cardboard.PpiOverrides;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Display;
import com.google.vr.sdk.proto.nano.Preferences;
import com.google.vr.sdk.proto.nano.SdkConfiguration;

public final class LegacyVrParamsProvider
implements VrParamsProvider {
    private static final String TAG = LegacyVrParamsProvider.class.getSimpleName();
    private final Context context;

    public LegacyVrParamsProvider(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public final CardboardDevice.DeviceParams readDeviceParams() {
        return ConfigUtils.readDeviceParamsFromExternalStorage();
    }

    @Override
    public final boolean writeDeviceParams(CardboardDevice.DeviceParams deviceParams) {
        if (deviceParams == null) {
            return ConfigUtils.removeDeviceParamsFromExternalStorage();
        }
        return ConfigUtils.writeDeviceParamsToExternalStorage(deviceParams);
    }

    @Override
    public final Display.DisplayParams readDisplayParams() {
        Display.DisplayParams displayParams = ConfigUtils.readDisplayParamsFromExternalStorage();
        if (displayParams == null) {
            displayParams = PpiOverrides.getPpiOverride(this.context);
        }
        return displayParams;
    }

    @Override
    public final Preferences.UserPrefs readUserPrefs() {
        return null;
    }

    @Override
    public final boolean updateUserPrefs(Preferences.UserPrefs userPrefs) {
        return false;
    }

    @Override
    public final Vr.VREvent.SdkConfigurationParams readSdkConfigurationParams(SdkConfiguration.SdkConfigurationRequest sdkConfigurationRequest) {
        return null;
    }

    @Override
    public final void close() {
    }

    @Override
    public final CardboardDevice.DeviceParamsList readRecentHeadsets() {
        CardboardDevice.DeviceParamsList deviceParamsList = new CardboardDevice.DeviceParamsList();
        new CardboardDevice.DeviceParamsList().params = new CardboardDevice.DeviceParams[0];
        return deviceParamsList;
    }
}

