/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.google.vr.cardboard.AndroidPCompat;
import com.google.vr.sdk.proto.nano.Display;

public class DisplayUtils {
    public static Display getDefaultDisplay(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    public static DisplayMetrics getDisplayMetricsLandscape(Display display) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getRealMetrics(displayMetrics);
        if (displayMetrics.widthPixels < displayMetrics.heightPixels) {
            int n2 = displayMetrics.widthPixels;
            displayMetrics.widthPixels = displayMetrics.heightPixels;
            displayMetrics.heightPixels = n2;
        }
        float f2 = displayMetrics.xdpi;
        displayMetrics.xdpi = displayMetrics.ydpi;
        displayMetrics.ydpi = f2;
        return displayMetrics;
    }

    public static DisplayMetrics getDisplayMetricsLandscapeWithOverride(Display display, Display.DisplayParams displayParams) {
        DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscape(display);
        if (displayParams != null) {
            if (displayParams.hasXPpi()) {
                displayMetrics.xdpi = displayParams.getXPpi();
            }
            if (displayParams.hasYPpi()) {
                displayMetrics.ydpi = displayParams.getYPpi();
            }
        }
        return displayMetrics;
    }

    public static float getBorderSizeMeters(Display.DisplayParams displayParams) {
        if (displayParams != null && displayParams.hasBottomBezelHeight()) {
            return displayParams.getBottomBezelHeight();
        }
        return 0.003f;
    }

    public static int getCutoutMarginLandscapePixels(Context context, Display display, AndroidPCompat androidPCompat) {
        AndroidPCompat.DisplayCutoutCompat displayCutoutCompat = androidPCompat.getDisplayCutout(display);
        if (displayCutoutCompat == null) {
            return 0;
        }
        if (context.getResources().getConfiguration().orientation == 1) {
            return displayCutoutCompat.getSafeInsetTop() + displayCutoutCompat.getSafeInsetBottom();
        }
        return displayCutoutCompat.getSafeInsetLeft() + displayCutoutCompat.getSafeInsetRight();
    }

    public static float getMetersPerPixelFromDotsPerInch(float f2) {
        return 0.0254f / f2;
    }

    public static String getExternalDisplayName(Context context) {
        Resources resources = context.getResources();
        int n2 = resources.getIdentifier("display_manager_hdmi_display_name", "string", "android");
        try {
            return resources.getString(n2);
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    public static boolean isSameDisplay(Display display, Display display2) {
        if (display == display2) {
            return true;
        }
        if (display == null || display2 == null) {
            return false;
        }
        if (display.getDisplayId() != display2.getDisplayId() || display.getFlags() != display2.getFlags() || display.isValid() != display2.isValid() || !display.getName().equals(display2.getName())) {
            return false;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        DisplayMetrics displayMetrics2 = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        display2.getMetrics(displayMetrics2);
        return displayMetrics.equals(displayMetrics2);
    }
}

