/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.opengl.GLES20;
import com.google.vr.cardboard.UsedByNative;

@UsedByNative
public class Viewport {
    public int x;
    public int y;
    public int width;
    public int height;

    @UsedByNative
    public void setViewport(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setGLViewport() {
        GLES20.glViewport((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    public void setGLScissor() {
        GLES20.glScissor((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    public void getAsArray(int[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        array[offset] = this.x;
        array[offset + 1] = this.y;
        array[offset + 2] = this.width;
        array[offset + 3] = this.height;
    }

    public String toString() {
        int n = this.x;
        StringBuilder stringBuilder = new StringBuilder().append("{\n").append(new StringBuilder(18).append("  x: ").append(n).append(",\n").toString());
        n = this.y;
        StringBuilder stringBuilder2 = stringBuilder.append(new StringBuilder(18).append("  y: ").append(n).append(",\n").toString());
        n = this.width;
        StringBuilder stringBuilder3 = stringBuilder2.append(new StringBuilder(22).append("  width: ").append(n).append(",\n").toString());
        n = this.height;
        return stringBuilder3.append(new StringBuilder(23).append("  height: ").append(n).append(",\n").toString()).append("}").toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Viewport)) {
            return false;
        }
        Viewport other = (Viewport)obj;
        return this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height;
    }

    public int hashCode() {
        return Integer.valueOf(this.x).hashCode() ^ Integer.valueOf(this.y).hashCode() ^ Integer.valueOf(this.width).hashCode() ^ Integer.valueOf(this.height).hashCode();
    }
}

