/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.annotation.TargetApi;
import android.content.Context;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.DaydreamApi;
import com.google.vr.ndk.base.DaydreamUtils;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=24)
public class HeadsetSelector {
    private static final String TAG = "HeadsetSelector";
    private static final HeadsetInfo DEFAULT_HEADSET_INFO = new HeadsetInfo(GvrViewerParams.cardboardV2ViewerParams().toProtobuf());

    public static List<HeadsetInfo> getRecentHeadsetInfos(Context context) {
        ArrayList<HeadsetInfo> headsetInfos = new ArrayList<HeadsetInfo>();
        CardboardDevice.DeviceParamsList deviceParamsList = DaydreamApi.getRecentHeadsets((Context)context);
        if (deviceParamsList != null && deviceParamsList.params.length > 0) {
            for (CardboardDevice.DeviceParams param : deviceParamsList.params) {
                headsetInfos.add(new HeadsetInfo(param));
            }
        }
        if (headsetInfos.isEmpty() || headsetInfos.size() == 1 && !((HeadsetInfo)headsetInfos.get(0)).isCardboardViewer()) {
            headsetInfos.add(DEFAULT_HEADSET_INFO);
        }
        return headsetInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HeadsetInfo getCurrentHeadsetInfo(Context context) {
        HeadsetInfo headsetInfo = DEFAULT_HEADSET_INFO;
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create((Context)context);){
            CardboardDevice.DeviceParams currentDeviceParams = vrParamsProvider.readDeviceParams();
            if (currentDeviceParams != null) {
                headsetInfo = new HeadsetInfo(currentDeviceParams);
            }
        }
        return headsetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean selectHeadset(Context context, HeadsetInfo headsetInfo) {
        if (headsetInfo == null) {
            return false;
        }
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create((Context)context);){
            CardboardDevice.DeviceParamsList deviceParams = vrParamsProvider.readRecentHeadsets();
            if (deviceParams != null && deviceParams.params.length > 0) {
                for (CardboardDevice.DeviceParams param : deviceParams.params) {
                    if (!headsetInfo.equalsDeviceParam(param)) continue;
                    boolean bl = vrParamsProvider.writeDeviceParams(param);
                    return bl;
                }
            }
            boolean bl = headsetInfo.equals(DEFAULT_HEADSET_INFO) && vrParamsProvider.writeDeviceParams(DEFAULT_HEADSET_INFO.deviceParam);
            return bl;
        }
    }

    private static String getHeadsetParamsKey(CardboardDevice.DeviceParams params) {
        String string = params.getVendor();
        String string2 = params.getModel();
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
    }

    public static final class HeadsetInfo {
        private final CardboardDevice.DeviceParams deviceParam;
        private final String uniqueKey;
        private final String displayName;
        private final boolean cardboardViewer;

        private HeadsetInfo(CardboardDevice.DeviceParams deviceParam) {
            this(deviceParam, DaydreamUtils.getDeviceParamsDisplayedName((CardboardDevice.DeviceParams)deviceParam), !DaydreamUtils.isDaydreamViewer((CardboardDevice.DeviceParams)deviceParam));
        }

        private HeadsetInfo(CardboardDevice.DeviceParams deviceParam, String displayName, boolean cardboardViewer) {
            this.deviceParam = deviceParam;
            this.uniqueKey = HeadsetSelector.getHeadsetParamsKey(deviceParam);
            this.displayName = displayName;
            this.cardboardViewer = cardboardViewer;
        }

        public static HeadsetInfo newInstance(String vendor, String model, String displayName, boolean cardboardViewer) {
            CardboardDevice.DeviceParams deviceParam = new CardboardDevice.DeviceParams();
            deviceParam.setVendor(vendor);
            deviceParam.setModel(model);
            return new HeadsetInfo(deviceParam, displayName, cardboardViewer);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isCardboardViewer() {
            return this.cardboardViewer;
        }

        private boolean equalsDeviceParam(CardboardDevice.DeviceParams param) {
            return this.uniqueKey.equalsIgnoreCase(HeadsetSelector.getHeadsetParamsKey(param));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeadsetInfo)) {
                return false;
            }
            HeadsetInfo that = (HeadsetInfo)o;
            return this.uniqueKey.equalsIgnoreCase(that.uniqueKey);
        }

        public int hashCode() {
            return this.uniqueKey.hashCode();
        }
    }
}

