/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.annotation.TargetApi;
import android.content.Context;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.DaydreamApi;
import com.google.vr.ndk.base.DaydreamUtils;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@TargetApi(value=24)
public class HeadsetSelector {
    private static final String TAG = "HeadsetSelector";
    private static final HeadsetInfo DEFAULT_HEADSET_INFO = new HeadsetInfo(GvrViewerParams.cardboardV2ViewerParams().toProtobuf());

    public static List<HeadsetInfo> getRecentHeadsetInfos(Context context) {
        CardboardDevice.DeviceParamsList deviceParamsList = DaydreamApi.getRecentHeadsets((Context)context);
        if (deviceParamsList == null || deviceParamsList.params.length == 0) {
            return Collections.singletonList(DEFAULT_HEADSET_INFO);
        }
        ArrayList<HeadsetInfo> headsetInfos = new ArrayList<HeadsetInfo>(deviceParamsList.params.length);
        for (CardboardDevice.DeviceParams param : deviceParamsList.params) {
            headsetInfos.add(new HeadsetInfo(param));
        }
        if (headsetInfos.size() == 1 && ((HeadsetInfo)headsetInfos.get(0)).isDaydreamViewer()) {
            headsetInfos.add(DEFAULT_HEADSET_INFO);
        }
        return headsetInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HeadsetInfo getCurrentHeadsetInfo(Context context) {
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create((Context)context);){
            HeadsetInfo headsetInfo = null;
            CardboardDevice.DeviceParams currentDeviceParams = vrParamsProvider.readDeviceParams();
            if (currentDeviceParams != null) {
                headsetInfo = new HeadsetInfo(currentDeviceParams);
            }
            HeadsetInfo headsetInfo2 = headsetInfo;
            return headsetInfo2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean selectHeadset(Context context, HeadsetInfo headsetInfo) {
        if (headsetInfo == null) {
            return false;
        }
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create((Context)context);){
            CardboardDevice.DeviceParamsList deviceParams = vrParamsProvider.readRecentHeadsets();
            if (deviceParams != null && deviceParams.params.length > 0) {
                for (CardboardDevice.DeviceParams param : deviceParams.params) {
                    if (!headsetInfo.equalsDeviceParam(param)) continue;
                    boolean bl = vrParamsProvider.writeDeviceParams(param);
                    return bl;
                }
            }
            boolean bl = headsetInfo.equals(DEFAULT_HEADSET_INFO) && vrParamsProvider.writeDeviceParams(DEFAULT_HEADSET_INFO.deviceParam);
            return bl;
        }
    }

    private static String getHeadsetParamsKey(CardboardDevice.DeviceParams params) {
        String string = params.getVendor();
        String string2 = params.getModel();
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
    }

    public static final class HeadsetInfo {
        private final CardboardDevice.DeviceParams deviceParam;
        private final String uniqueKey;
        private final String displayName;
        private final boolean daydreamViewer;

        private HeadsetInfo(CardboardDevice.DeviceParams deviceParam) {
            this.deviceParam = deviceParam;
            this.uniqueKey = HeadsetSelector.getHeadsetParamsKey(deviceParam);
            this.displayName = DaydreamUtils.getDeviceParamsDisplayedName((CardboardDevice.DeviceParams)deviceParam);
            this.daydreamViewer = DaydreamUtils.isDaydreamViewer((CardboardDevice.DeviceParams)deviceParam);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isDaydreamViewer() {
            return this.daydreamViewer;
        }

        private boolean equalsDeviceParam(CardboardDevice.DeviceParams param) {
            return this.uniqueKey.equalsIgnoreCase(HeadsetSelector.getHeadsetParamsKey(param));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeadsetInfo)) {
                return false;
            }
            HeadsetInfo that = (HeadsetInfo)o;
            return this.uniqueKey.equalsIgnoreCase(that.uniqueKey);
        }

        public int hashCode() {
            return this.uniqueKey.hashCode();
        }
    }
}

