/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.util.DisplayMetrics;
import android.view.Display;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.sdk.proto.nano.Display;

public class ScreenParams {
    private int width;
    private int height;
    private float xMetersPerPixel;
    private float yMetersPerPixel;
    private float borderSizeMeters;

    public ScreenParams(Display display) {
        DisplayMetrics metrics = DisplayUtils.getDisplayMetricsLandscape((Display)display);
        this.xMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch((float)metrics.xdpi);
        this.yMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch((float)metrics.ydpi);
        this.width = metrics.widthPixels;
        this.height = metrics.heightPixels;
        this.borderSizeMeters = DisplayUtils.getBorderSizeMeters(null);
        if (this.height > this.width) {
            int tempPx = this.width;
            this.width = this.height;
            this.height = tempPx;
            float tempMetersPerPixel = this.xMetersPerPixel;
            this.xMetersPerPixel = this.yMetersPerPixel;
            this.yMetersPerPixel = tempMetersPerPixel;
        }
    }

    public static ScreenParams fromProto(Display display, Display.DisplayParams params) {
        if (params == null) {
            return null;
        }
        ScreenParams screenParams = new ScreenParams(display);
        if (params.hasXPpi()) {
            screenParams.xMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch((float)params.getXPpi());
        }
        if (params.hasYPpi()) {
            screenParams.yMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch((float)params.getYPpi());
        }
        screenParams.borderSizeMeters = DisplayUtils.getBorderSizeMeters((Display.DisplayParams)params);
        return screenParams;
    }

    public ScreenParams(ScreenParams params) {
        this.width = params.width;
        this.height = params.height;
        this.xMetersPerPixel = params.xMetersPerPixel;
        this.yMetersPerPixel = params.yMetersPerPixel;
        this.borderSizeMeters = params.borderSizeMeters;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public float getWidthMeters() {
        return (float)this.width * this.xMetersPerPixel;
    }

    public float getHeightMeters() {
        return (float)this.height * this.yMetersPerPixel;
    }

    public void setBorderSizeMeters(float displayBorderSize) {
        this.borderSizeMeters = displayBorderSize;
    }

    public float getBorderSizeMeters() {
        return this.borderSizeMeters;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ScreenParams)) {
            return false;
        }
        ScreenParams o = (ScreenParams)other;
        return this.width == o.width && this.height == o.height && this.xMetersPerPixel == o.xMetersPerPixel && this.yMetersPerPixel == o.yMetersPerPixel && this.borderSizeMeters == o.borderSizeMeters;
    }

    public String toString() {
        int n = this.width;
        StringBuilder stringBuilder = new StringBuilder().append("{\n").append(new StringBuilder(22).append("  width: ").append(n).append(",\n").toString());
        n = this.height;
        float f = this.xMetersPerPixel;
        StringBuilder stringBuilder2 = stringBuilder.append(new StringBuilder(23).append("  height: ").append(n).append(",\n").toString()).append(new StringBuilder(39).append("  x_meters_per_pixel: ").append(f).append(",\n").toString());
        f = this.yMetersPerPixel;
        StringBuilder stringBuilder3 = stringBuilder2.append(new StringBuilder(39).append("  y_meters_per_pixel: ").append(f).append(",\n").toString());
        f = this.borderSizeMeters;
        return stringBuilder3.append(new StringBuilder(39).append("  border_size_meters: ").append(f).append(",\n").toString()).append("}").toString();
    }
}

