/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.opengl.GLES20;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;

class GLStateBackup {
    private boolean cullFaceEnabled;
    private boolean scissorTestEnabled;
    private boolean depthTestEnabled;
    private IntBuffer viewport = IntBuffer.allocate(4);
    private IntBuffer texture2dId = IntBuffer.allocate(1);
    private IntBuffer textureUnit = IntBuffer.allocate(1);
    private IntBuffer scissorBox = IntBuffer.allocate(4);
    private IntBuffer shaderProgram = IntBuffer.allocate(1);
    private IntBuffer arrayBufferBinding = IntBuffer.allocate(1);
    private IntBuffer elementArrayBufferBinding = IntBuffer.allocate(1);
    private FloatBuffer clearColor = FloatBuffer.allocate(4);
    private ArrayList<VertexAttributeState> vertexAttributes = new ArrayList();

    GLStateBackup() {
    }

    void addTrackedVertexAttribute(int attributeId) {
        this.vertexAttributes.add(new VertexAttributeState(this, attributeId));
    }

    void clearTrackedVertexAttributes() {
        this.vertexAttributes.clear();
    }

    void readFromGL() {
        GLES20.glGetIntegerv((int)2978, (IntBuffer)this.viewport);
        this.cullFaceEnabled = GLES20.glIsEnabled((int)2884);
        this.scissorTestEnabled = GLES20.glIsEnabled((int)3089);
        this.depthTestEnabled = GLES20.glIsEnabled((int)2929);
        GLES20.glGetFloatv((int)3106, (FloatBuffer)this.clearColor);
        GLES20.glGetIntegerv((int)35725, (IntBuffer)this.shaderProgram);
        GLES20.glGetIntegerv((int)3088, (IntBuffer)this.scissorBox);
        GLES20.glGetIntegerv((int)34016, (IntBuffer)this.textureUnit);
        GLES20.glGetIntegerv((int)32873, (IntBuffer)this.texture2dId);
        GLES20.glGetIntegerv((int)34964, (IntBuffer)this.arrayBufferBinding);
        GLES20.glGetIntegerv((int)34965, (IntBuffer)this.elementArrayBufferBinding);
        for (VertexAttributeState vas : this.vertexAttributes) {
            vas.readFromGL();
        }
    }

    void writeToGL() {
        for (VertexAttributeState vas : this.vertexAttributes) {
            vas.writeToGL();
        }
        GLES20.glBindBuffer((int)34962, (int)this.arrayBufferBinding.array()[0]);
        GLES20.glBindBuffer((int)34963, (int)this.elementArrayBufferBinding.array()[0]);
        GLES20.glBindTexture((int)3553, (int)this.texture2dId.array()[0]);
        GLES20.glActiveTexture((int)this.textureUnit.array()[0]);
        GLES20.glScissor((int)this.scissorBox.array()[0], (int)this.scissorBox.array()[1], (int)this.scissorBox.array()[2], (int)this.scissorBox.array()[3]);
        GLES20.glUseProgram((int)this.shaderProgram.array()[0]);
        GLES20.glClearColor((float)this.clearColor.array()[0], (float)this.clearColor.array()[1], (float)this.clearColor.array()[2], (float)this.clearColor.array()[3]);
        if (this.cullFaceEnabled) {
            GLES20.glEnable((int)2884);
        } else {
            GLES20.glDisable((int)2884);
        }
        if (this.scissorTestEnabled) {
            GLES20.glEnable((int)3089);
        } else {
            GLES20.glDisable((int)3089);
        }
        if (this.depthTestEnabled) {
            GLES20.glEnable((int)2929);
        } else {
            GLES20.glDisable((int)2929);
        }
        GLES20.glViewport((int)this.viewport.array()[0], (int)this.viewport.array()[1], (int)this.viewport.array()[2], (int)this.viewport.array()[3]);
    }

    private class VertexAttributeState {
        private int attributeId;
        private IntBuffer enabled = IntBuffer.allocate(1);

        VertexAttributeState(GLStateBackup gLStateBackup, int attributeId) {
            this.attributeId = attributeId;
        }

        void readFromGL() {
            GLES20.glGetVertexAttribiv((int)this.attributeId, (int)34338, (IntBuffer)this.enabled);
        }

        void writeToGL() {
            if (this.enabled.array()[0] == 0) {
                GLES20.glDisableVertexAttribArray((int)this.attributeId);
            } else {
                GLES20.glEnableVertexAttribArray((int)this.attributeId);
            }
        }
    }
}

