/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base.testing.sensors;

import android.hardware.SensorEventListener;
import com.google.vr.sdk.base.sensors.Clock;
import com.google.vr.sdk.base.sensors.SensorEventProvider;
import com.google.vr.sdk.base.testing.sensors.SensorEventAndTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SensorEventProviderFromRecordedData
implements SensorEventProvider {
    private final List<SensorEventAndTime> events;
    private ListIterator<SensorEventAndTime> eventsIterator = null;
    private EventClock eventClock = new EventClock();
    private final List<SensorEventListener> registeredListeners = new ArrayList<SensorEventListener>();

    public SensorEventProviderFromRecordedData(List<SensorEventAndTime> events) {
        this.events = events;
    }

    @Override
    public void start() {
        this.reset();
        this.next();
    }

    public void reset() {
        this.eventsIterator = this.events.listIterator();
    }

    @Override
    public void stop() {
    }

    public boolean atEnd() {
        return !this.eventsIterator.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        if (this.atEnd()) {
            return false;
        }
        SensorEventAndTime currentEvent = this.eventsIterator.next();
        this.eventClock.setTimeNs(currentEvent.timeNs);
        List<SensorEventListener> list = this.registeredListeners;
        synchronized (list) {
            for (SensorEventListener listener : this.registeredListeners) {
                listener.onSensorChanged(currentEvent.event);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(SensorEventListener listener) {
        List<SensorEventListener> list = this.registeredListeners;
        synchronized (list) {
            this.registeredListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(SensorEventListener listener) {
        List<SensorEventListener> list = this.registeredListeners;
        synchronized (list) {
            this.registeredListeners.remove(listener);
        }
    }

    public Clock getClock() {
        return this.eventClock;
    }

    private static class EventClock
    implements Clock {
        private long currentTimeNs;

        private EventClock() {
        }

        @Override
        public long nanoTime() {
            return this.currentTimeNs;
        }

        public void setTimeNs(long nanos) {
            this.currentTimeNs = nanos;
        }
    }
}

